/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory.epsg;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.referencing.factory.epsg.DirectEpsgFactory;

public class AnsiDialectEpsgFactory
extends DirectEpsgFactory {
    private static final String[] SENTINAL = new String[]{"Coordinate Reference System", "coordinatereferencesystem", "epsg_coordinatereferencesystem"};
    static final String TABLE_PREFIX = "epsg_";
    static final String[] ACCESS_TO_ANSI = new String[]{"[Alias]", "epsg_alias", "[Area]", "epsg_area", "[Coordinate Axis]", "epsg_coordinateaxis", "[Coordinate Axis Name]", "epsg_coordinateaxisname", "[Coordinate_Operation]", "epsg_coordoperation", "[Coordinate_Operation Method]", "epsg_coordoperationmethod", "[Coordinate_Operation Parameter]", "epsg_coordoperationparam", "[Coordinate_Operation Parameter Usage]", "epsg_coordoperationparamusage", "[Coordinate_Operation Parameter Value]", "epsg_coordoperationparamvalue", "[Coordinate_Operation Path]", "epsg_coordoperationpath", "[Coordinate Reference System]", "epsg_coordinatereferencesystem", "[Coordinate System]", "epsg_coordinatesystem", "[Datum]", "epsg_datum", "[Ellipsoid]", "epsg_ellipsoid", "[Naming System]", "epsg_namingsystem", "[Prime Meridian]", "epsg_primemeridian", "[Supersession]", "epsg_supersession", "[Unit of Measure]", "epsg_unitofmeasure", "[Version History]", "epsg_versionhistory", "[Change]", "epsg_change", "[Deprecation]", "epsg_deprecation", "[ORDER]", "coord_axis_order"};
    protected final Map<String, String> toANSI;
    private String schema;

    public AnsiDialectEpsgFactory(Hints hints, Connection connection) {
        super(hints, connection);
        this.toANSI = new LinkedHashMap<String, String>();
        for (int i = 0; i < ACCESS_TO_ANSI.length; ++i) {
            this.toANSI.put(ACCESS_TO_ANSI[i], ACCESS_TO_ANSI[++i]);
        }
    }

    AnsiDialectEpsgFactory(Hints hints, Connection connection, Map<String, String> map) {
        super(hints, connection);
        this.toANSI = map;
    }

    final void autoconfig(DatabaseMetaData databaseMetaData) throws SQLException {
        int n = SENTINAL.length;
        while (--n >= 0) {
            String string = SENTINAL[n];
            String string2 = databaseMetaData.getIdentifierQuoteString();
            ResultSet resultSet = databaseMetaData.getTables(null, this.schema, string, null);
            if (!resultSet.next()) {
                resultSet.close();
                continue;
            }
            String string3 = resultSet.getString("TABLE_SCHEM");
            resultSet.close();
            if (string3 != null && !string3.equals(this.schema)) {
                this.setSchema(string3, string2, !string.startsWith(TABLE_PREFIX));
            }
            if (n != 0) break;
            this.useOriginalTableNames(string2);
            break;
        }
    }

    final void setSchema(String string, String string2, boolean bl) {
        if ((string = string.trim()).length() == 0) {
            throw new IllegalArgumentException(string);
        }
        String string3 = this.schema;
        string3 = string3 != null ? string2 + string3 + string2 + '.' : "";
        String string4 = bl ? TABLE_PREFIX : "";
        StringBuilder stringBuilder = new StringBuilder(string2).append(string).append(string2).append('.');
        int n = stringBuilder.length();
        for (Map.Entry<String, String> entry : this.toANSI.entrySet()) {
            if (!AnsiDialectEpsgFactory.isTableName(entry.getKey())) continue;
            String string5 = entry.getValue();
            if (string5.startsWith(string3)) {
                string5 = string5.substring(string3.length());
            }
            if (string5.startsWith(string4)) {
                string5 = string5.substring(string4.length());
            }
            stringBuilder.setLength(n);
            string5 = stringBuilder.append(string5).toString();
            entry.setValue(string5);
        }
        this.schema = string;
    }

    private void useOriginalTableNames(String string) {
        for (Map.Entry<String, String> entry : this.toANSI.entrySet()) {
            int n;
            String string2 = entry.getKey();
            if (!AnsiDialectEpsgFactory.isTableName(string2)) continue;
            int n2 = string2.indexOf(91);
            if (n2 >= 0 && (n = string2.lastIndexOf(93)) > n2) {
                string2 = string2.substring(n2 + 1, n);
            }
            String string3 = entry.getValue();
            string3 = string3.substring(0, string3.indexOf(46) + 1);
            string3 = string3 + string + string2 + string;
            entry.setValue(string3);
        }
    }

    private static boolean isTableName(String string) {
        int n = string.length();
        while (--n >= 0) {
            char c = string.charAt(n);
            if (c == Character.toUpperCase(c)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String adaptSQL(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        for (Map.Entry<String, String> entry : this.toANSI.entrySet()) {
            String string2 = entry.getKey();
            String string3 = entry.getValue();
            int n = 0;
            while ((n = stringBuilder.indexOf(string2, n)) >= 0) {
                stringBuilder.replace(n, n + string2.length(), string3);
                n += string3.length();
            }
        }
        return stringBuilder.toString();
    }
}

