/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory.epsg;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.geotoolkit.internal.sql.DefaultDataSource;
import org.geotoolkit.referencing.factory.epsg.EpsgInstaller;
import org.geotoolkit.referencing.factory.epsg.EpsgScriptRunner;

final class EmbeddedDataSource
extends DefaultDataSource {
    private static final Map<String, EmbeddedDataSource> SOURCES = new HashMap<String, EmbeddedDataSource>(4);
    private boolean tested;

    private EmbeddedDataSource(String string) {
        super(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static EmbeddedDataSource instance(String string) {
        Map<String, EmbeddedDataSource> map = SOURCES;
        synchronized (map) {
            EmbeddedDataSource embeddedDataSource = SOURCES.get(string);
            if (embeddedDataSource == null) {
                embeddedDataSource = new EmbeddedDataSource(string);
                SOURCES.put(string, embeddedDataSource);
            }
            return embeddedDataSource;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection connection = super.getConnection();
        this.createIfEmpty(connection);
        return connection;
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        Connection connection = super.getConnection(string, string2);
        this.createIfEmpty(connection);
        return connection;
    }

    private synchronized void createIfEmpty(Connection connection) throws SQLException {
        if (this.tested) {
            return;
        }
        this.tested = true;
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        String string = "epsg";
        if (databaseMetaData.storesLowerCaseIdentifiers()) {
            string = string.toLowerCase(Locale.US);
        } else if (databaseMetaData.storesUpperCaseIdentifiers()) {
            string = string.toUpperCase(Locale.US);
        }
        ResultSet resultSet = databaseMetaData.getSchemas(null, string);
        boolean bl = resultSet.next();
        assert (!bl || string.equals(resultSet.getString("TABLE_SCHEM")));
        resultSet.close();
        if (!bl) {
            EpsgInstaller epsgInstaller = new EpsgInstaller();
            try {
                epsgInstaller.call(new EpsgScriptRunner(connection));
            }
            catch (IOException iOException) {
                throw new SQLNonTransientException(iOException);
            }
        }
    }
}

