/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory.epsg;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.geotoolkit.internal.sql.ScriptRunner;
import org.geotoolkit.referencing.factory.epsg.EpsgScriptRunner;
import org.geotoolkit.referencing.factory.epsg.ThreadedEpsgFactory;
import org.geotoolkit.resources.Descriptions;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Loggings;
import org.opengis.referencing.FactoryException;

public class EpsgInstaller
implements Callable<Result> {
    public static final String DEFAULT_SCHEMA = "epsg";
    private String schema = "epsg";
    private File scriptsDirectory;
    private String databaseUrl;
    private String user;
    private String password;

    public synchronized void setScriptDirectory(File file) {
        this.scriptsDirectory = file;
    }

    public synchronized void setDatabase(String string) {
        this.databaseUrl = string;
    }

    public synchronized void setDatabase(String string, String string2, String string3) {
        this.databaseUrl = string;
        this.user = string2;
        this.password = string3;
    }

    public synchronized void setSchema(String string) {
        this.schema = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Result call() throws FactoryException {
        String string;
        Exception exception;
        ScriptRunner scriptRunner;
        block8: {
            Result result;
            scriptRunner = null;
            if (this.databaseUrl == null) {
                this.databaseUrl = ThreadedEpsgFactory.getDefaultURL(true);
            }
            Connection connection = this.user == null ? DriverManager.getConnection(this.databaseUrl) : DriverManager.getConnection(this.databaseUrl, this.user, this.password);
            try {
                scriptRunner = new EpsgScriptRunner(connection);
                result = this.call((EpsgScriptRunner)scriptRunner);
            }
            catch (Throwable throwable) {
                try {
                    connection.close();
                    ThreadedEpsgFactory.shutdown(this.databaseUrl);
                    throw throwable;
                }
                catch (SQLException sQLException) {
                    exception = sQLException;
                    break block8;
                }
                catch (IOException iOException) {
                    exception = iOException;
                }
            }
            connection.close();
            ThreadedEpsgFactory.shutdown(this.databaseUrl);
            return result;
        }
        String string2 = exception.getLocalizedMessage();
        if (scriptRunner != null && (string = scriptRunner.getCurrentPosition()) != null) {
            string2 = string2 + '\n' + string;
        }
        throw new FactoryException(string2, exception);
    }

    final synchronized Result call(EpsgScriptRunner epsgScriptRunner) throws SQLException, IOException {
        long l = System.currentTimeMillis();
        int n = 0;
        if (this.schema != null) {
            epsgScriptRunner.setSchema(this.schema);
        }
        if (this.scriptsDirectory != null) {
            n += epsgScriptRunner.run(this.scriptsDirectory);
        } else {
            LogRecord logRecord = Loggings.format(Level.INFO, 20, "7.01");
            logRecord.setSourceMethodName("call");
            logRecord.setSourceClassName(EpsgInstaller.class.getName());
            logRecord.setLoggerName(ThreadedEpsgFactory.LOGGER.getName());
            ThreadedEpsgFactory.LOGGER.log(logRecord);
            epsgScriptRunner.maxRowsPerInsert = 100;
            for (String string : EpsgScriptRunner.SCRIPTS) {
                InputStream inputStream = EpsgScriptRunner.class.getResourceAsStream(string = string + ".sql");
                if (inputStream == null) {
                    throw new FileNotFoundException(Errors.format(54, string));
                }
                n += epsgScriptRunner.run(inputStream);
                inputStream.close();
            }
        }
        epsgScriptRunner.close();
        return new Result(n, System.currentTimeMillis() - l);
    }

    public static final class Result {
        public final int numRows;
        public final long ellapsedTime;

        Result(int n, long l) {
            this.numRows = n;
            this.ellapsedTime = l;
        }

        public String toString() {
            return Descriptions.format(6, this.numRows, (double)this.ellapsedTime / 1000.0);
        }
    }
}

