/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory.epsg;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geotoolkit.internal.StringUtilities;
import org.geotoolkit.internal.sql.ScriptRunner;
import org.geotoolkit.referencing.factory.epsg.AnsiDialectEpsgFactory;

final class EpsgScriptRunner
extends ScriptRunner {
    static final String[] SCRIPTS = new String[]{"Tables", "Data", "FKeys", "Indexes"};
    static final String REPLACE_STATEMENT = "\\s*UPDATE\\s+[\\w\\.\" ]+\\s+SET\\s+(\\w+)\\s*=\\s*replace\\s*\\(\\s*\\1\\W+.*";
    private final boolean supportsCommit;
    private final boolean supportsSchemas;
    int maxRowsPerInsert;
    private final boolean replaceParagraphs;
    private final Matcher skip;

    public EpsgScriptRunner(Connection connection) throws SQLException {
        super(connection);
        this.setEncoding("ISO-8859-1");
        for (String string : SCRIPTS) {
            this.suffixes.add(string);
        }
        boolean bl = false;
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ResultSet resultSet = databaseMetaData.getTypeInfo();
        while (resultSet.next()) {
            String string;
            string = resultSet.getString("TYPE_NAME");
            if (!string.equalsIgnoreCase("TEXT")) continue;
            bl = true;
            break;
        }
        resultSet.close();
        boolean bl2 = false;
        String string = databaseMetaData.getStringFunctions();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (!string2.equalsIgnoreCase("REPLACE")) continue;
            bl2 = true;
            break;
        }
        this.skip = bl2 ? null : Pattern.compile(REPLACE_STATEMENT, 2).matcher("");
        this.replaceParagraphs = false;
        if (!bl) {
            this.replacements.put("TEXT", "VARCHAR(4000)");
        }
        switch (this.dialect) {
            case POSTGRESQL: {
                this.replacements.put("CHAR", "CHR");
                this.supportsCommit = false;
                break;
            }
            case DERBY: {
                this.replacements.put("UNIQUE", "UNIQUE NOT NULL");
                this.supportsCommit = false;
                break;
            }
            default: {
                this.supportsCommit = true;
            }
        }
        this.supportsSchemas = databaseMetaData.supportsSchemasInTableDefinitions() && databaseMetaData.supportsSchemasInDataManipulation();
    }

    @Override
    public boolean accept(File file, String string) {
        return super.accept(file, string) && string.startsWith("EPSG");
    }

    public void setSchema(String string) throws SQLException, IOException {
        if (!this.supportsSchemas) {
            return;
        }
        this.execute(new StringBuilder("CREATE SCHEMA ").append(string));
        StringBuilder stringBuilder = new StringBuilder(string).append('.').append(this.identifierQuote);
        int n = stringBuilder.length();
        String[] stringArray = AnsiDialectEpsgFactory.ACCESS_TO_ANSI;
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string2;
            String string3 = stringArray[n2++];
            if (!(string2 = stringArray[n2++]).startsWith("epsg_")) continue;
            stringBuilder.setLength(n);
            assert (string3.charAt(0) == '[' && string3.charAt(string3.length() - 1) == ']') : string3;
            String string4 = stringBuilder.append(string3, 1, string3.length() - 1).append(this.identifierQuote).toString();
            if (this.replacements.put(string2, string4) != null) {
                throw new AssertionError((Object)string2);
            }
        }
    }

    @Override
    protected int execute(StringBuilder stringBuilder) throws SQLException, IOException {
        int n;
        if (!this.supportsCommit && StringUtilities.equalsIgnoreCase("COMMIT", stringBuilder)) {
            return 0;
        }
        if (this.skip != null && this.skip.reset(stringBuilder).matches()) {
            return 0;
        }
        if (this.replaceParagraphs) {
            StringUtilities.replace(stringBuilder, "\u00b6", "\n");
        }
        if (this.maxRowsPerInsert != 0 && StringUtilities.startsWith(stringBuilder, "INSERT INTO", true) && (n = stringBuilder.indexOf("\n")) >= 0) {
            StringBuilder stringBuilder2 = new StringBuilder(stringBuilder.substring(0, n)).append(' ');
            int n2 = stringBuilder2.length();
            int n3 = n + 1;
            int n4 = 0;
            int n5 = this.maxRowsPerInsert;
            while (true) {
                ++n;
                if ((n = stringBuilder.indexOf("\n", n)) < 0) break;
                if (--n5 != 0 || n == n3) continue;
                int n6 = n;
                if (stringBuilder.charAt(n6 - 1) == ',') {
                    --n6;
                }
                n4 += super.execute(stringBuilder2.append(stringBuilder.substring(n3, n6)));
                stringBuilder2.setLength(n2);
                n5 = this.maxRowsPerInsert;
                n3 = n + 1;
            }
            return n4 += super.execute(stringBuilder2.append(stringBuilder.substring(n3)));
        }
        return super.execute(stringBuilder);
    }
}

