/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory.epsg;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.geotoolkit.factory.AuthorityFactoryFinder;
import org.geotoolkit.factory.Factory;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.io.IndentedLineWriter;
import org.geotoolkit.io.TableWriter;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.referencing.factory.AbstractAuthorityFactory;
import org.geotoolkit.referencing.factory.PropertyAuthorityFactory;
import org.geotoolkit.referencing.factory.epsg.LongitudeFirstEpsgFactory;
import org.geotoolkit.referencing.factory.epsg.ThreadedEpsgFactory;
import org.geotoolkit.resources.Vocabulary;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PropertyEpsgFactory
extends PropertyAuthorityFactory
implements CRSAuthorityFactory {
    public static final String FILENAME = "epsg.properties";

    public PropertyEpsgFactory() throws IOException {
        this(EMPTY_HINTS);
    }

    public PropertyEpsgFactory(Hints hints) throws IOException {
        this(hints, FILENAME, Citations.EPSG);
    }

    public PropertyEpsgFactory(Hints hints, String string, Citation ... citationArray) throws IOException {
        super(hints, Hints.CRS_AUTHORITY_EXTRA_DIRECTORY, PropertyEpsgFactory.class, string, citationArray);
    }

    @Override
    protected void setOrdering(Factory.Organizer organizer) {
        super.setOrdering(organizer);
        organizer.after(ThreadedEpsgFactory.class, true);
        organizer.after(LongitudeFirstEpsgFactory.class, false);
    }

    public Set<String> reportDuplicates(PrintWriter printWriter) throws FactoryException {
        Object object;
        AbstractAuthorityFactory abstractAuthorityFactory = (AbstractAuthorityFactory)((Object)AuthorityFactoryFinder.getCRSAuthorityFactory("EPSG", new Hints(Hints.CRS_AUTHORITY_FACTORY, ThreadedEpsgFactory.class)));
        Vocabulary vocabulary = Vocabulary.getResources(null);
        printWriter.println(vocabulary.getLabel(37));
        try {
            object = new IndentedLineWriter(printWriter);
            ((IndentedLineWriter)object).setIndentation(4);
            ((Writer)object).write(abstractAuthorityFactory.getBackingStoreDescription());
            ((FilterWriter)object).flush();
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        printWriter.println();
        object = this.getAuthorityCodes(IdentifiedObject.class);
        Set<String> set = abstractAuthorityFactory.getAuthorityCodes(IdentifiedObject.class);
        TreeSet<String> treeSet = new TreeSet<String>();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!set.contains(string = string.trim())) continue;
            treeSet.add(string);
        }
        if (treeSet.isEmpty()) {
            printWriter.println(vocabulary.getString(189));
        } else {
            for (String string : treeSet) {
                printWriter.print(vocabulary.getLabel(74));
                printWriter.println(string);
            }
        }
        return treeSet;
    }

    public Set<String> reportInstantiationFailures(PrintWriter printWriter) throws FactoryException {
        Set<String> set = this.getAuthorityCodes(CoordinateReferenceSystem.class);
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (String object : set) {
            try {
                this.createCoordinateReferenceSystem(object);
            }
            catch (FactoryException entry) {
                treeMap.put(object, entry.getLocalizedMessage());
            }
        }
        if (!treeMap.isEmpty()) {
            TableWriter tableWriter = new TableWriter((Writer)printWriter, " ");
            for (Map.Entry entry : treeMap.entrySet()) {
                tableWriter.write((String)entry.getKey());
                tableWriter.write(58);
                tableWriter.nextColumn();
                tableWriter.write((String)entry.getValue());
                tableWriter.nextLine();
            }
            try {
                tableWriter.flush();
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }
        return treeMap.keySet();
    }
}

