/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory.epsg;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NoInitialContextException;
import javax.sql.DataSource;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.internal.JNDI;
import org.geotoolkit.internal.io.Installation;
import org.geotoolkit.internal.sql.DefaultDataSource;
import org.geotoolkit.internal.sql.Dialect;
import org.geotoolkit.referencing.factory.AbstractAuthorityFactory;
import org.geotoolkit.referencing.factory.NoSuchFactoryException;
import org.geotoolkit.referencing.factory.ReferencingFactoryContainer;
import org.geotoolkit.referencing.factory.ThreadedAuthorityFactory;
import org.geotoolkit.referencing.factory.epsg.AnsiDialectEpsgFactory;
import org.geotoolkit.referencing.factory.epsg.DirectEpsgFactory;
import org.geotoolkit.referencing.factory.epsg.EmbeddedDataSource;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Loggings;
import org.geotoolkit.resources.Vocabulary;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;

public class ThreadedEpsgFactory
extends ThreadedAuthorityFactory
implements CRSAuthorityFactory,
CSAuthorityFactory,
DatumAuthorityFactory,
CoordinateOperationAuthorityFactory {
    static final String VERSION = "7.01";
    public static final String CONFIGURATION_FILE = "EPSG-DataSource.properties";
    private final ReferencingFactoryContainer factories;
    private DataSource datasource;
    protected String schema;
    protected String user;
    protected String password;
    private transient Map<String, String> dialect;

    public ThreadedEpsgFactory() {
        this(EMPTY_HINTS);
        this.hints.put(Hints.EPSG_DATA_SOURCE, null);
    }

    public ThreadedEpsgFactory(DataSource dataSource) {
        this(EMPTY_HINTS);
        ThreadedEpsgFactory.ensureNonNull("source", dataSource);
        this.hints.put(Hints.EPSG_DATA_SOURCE, dataSource);
    }

    public ThreadedEpsgFactory(Hints hints) {
        super(hints);
        this.factories = ReferencingFactoryContainer.instance(hints);
        this.hints.put(Hints.EPSG_DATA_SOURCE, hints != null ? hints.get(Hints.EPSG_DATA_SOURCE) : null);
        this.setKeyCollisionAllowed(true);
        this.setTimeout(15000L);
    }

    public static String getDefaultURL() {
        try {
            return ThreadedEpsgFactory.getDefaultURL(false);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    static String getDefaultURL(boolean bl) throws IOException {
        File file = bl ? Installation.EPSG.validDirectory(true) : Installation.EPSG.directory(true);
        StringBuilder stringBuilder = new StringBuilder("jdbc:derby:").append(file.getPath().replace(File.pathSeparatorChar, '/')).append('/').append(VERSION);
        if (bl) {
            stringBuilder.append(";create=true");
        }
        return stringBuilder.toString();
    }

    static void shutdown(String string) {
        if (string.startsWith("jdbc:derby:")) {
            int n = string.indexOf(59);
            if (n >= 0) {
                string = string.substring(0, n);
            }
            string = string + ";shutdown=true";
            try {
                DriverManager.getConnection(string).close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static Properties properties() throws FactoryException {
        File file = new File(CONFIGURATION_FILE);
        if (!(file.isFile() || (file = new File(System.getProperty("user.home", "."), CONFIGURATION_FILE)).isFile() || (file = new File(Installation.EPSG.directory(true), "DataSource.properties")).isFile())) {
            return null;
        }
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
            ((InputStream)fileInputStream).close();
        }
        catch (IOException iOException) {
            throw new FactoryException(Errors.format(29, file), iOException);
        }
        return properties;
    }

    protected synchronized DataSource getDataSource() throws FactoryException {
        DataSource dataSource = this.datasource;
        if (dataSource == null) {
            this.password = null;
            this.user = null;
            this.schema = null;
            Object v = this.hints.get(Hints.EPSG_DATA_SOURCE);
            if (v == null) {
                Properties properties = ThreadedEpsgFactory.properties();
                if (properties != null) {
                    this.schema = properties.getProperty("schema");
                    this.user = properties.getProperty("user");
                    this.password = properties.getProperty("password");
                }
                dataSource = this.createDataSource(properties);
            } else if (v instanceof DataSource) {
                dataSource = (DataSource)v;
            } else {
                try {
                    Object object;
                    Hints hints = EMPTY_HINTS.clone();
                    hints.putAll((Map<?, ?>)this.hints);
                    InitialContext initialContext = JNDI.getInitialContext(hints);
                    if (v instanceof Name) {
                        object = initialContext.lookup((Name)v);
                    } else {
                        String string = v.toString();
                        string = JNDI.fixName(initialContext, string);
                        object = initialContext.lookup(string);
                    }
                    dataSource = (DataSource)object;
                }
                catch (NoInitialContextException noInitialContextException) {
                    throw new NoSuchFactoryException(Errors.format(140), noInitialContextException);
                }
                catch (NameNotFoundException nameNotFoundException) {
                    throw new NoSuchFactoryException(Errors.format(140), nameNotFoundException);
                }
                catch (Exception exception) {
                    throw new FactoryException(Errors.format(28, v), exception);
                }
            }
            if (dataSource == null) {
                throw new NoSuchFactoryException(Errors.format(140));
            }
            this.datasource = dataSource;
        }
        return dataSource;
    }

    protected DataSource createDataSource(Properties properties) throws FactoryException {
        if (properties != null) {
            String string = properties.getProperty("URL");
            if (string != null) {
                return new DefaultDataSource(string);
            }
        } else {
            String string;
            boolean bl = ThreadedEpsgFactory.class.getResource("Data.sql") != null;
            try {
                string = ThreadedEpsgFactory.getDefaultURL(bl);
            }
            catch (IOException iOException) {
                throw new FactoryException(iOException);
            }
            if (bl) {
                return EmbeddedDataSource.instance(string);
            }
            return new DefaultDataSource(string);
        }
        return null;
    }

    protected AbstractAuthorityFactory createBackingStore(Hints hints) throws FactoryException, SQLException {
        DataSource dataSource = this.getDataSource();
        Connection connection = this.user != null && this.password != null ? dataSource.getConnection(this.user, this.password) : dataSource.getConnection();
        connection.setReadOnly(true);
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        switch (Dialect.guess(databaseMetaData)) {
            case ACCESS: {
                return new DirectEpsgFactory(hints, connection);
            }
        }
        Map<String, String> map = this.dialect;
        if (map != null) {
            return new AnsiDialectEpsgFactory(hints, connection, map);
        }
        AnsiDialectEpsgFactory ansiDialectEpsgFactory = new AnsiDialectEpsgFactory(hints, connection);
        if (this.schema != null) {
            ansiDialectEpsgFactory.setSchema(this.schema, databaseMetaData.getIdentifierQuoteString(), true);
        }
        ansiDialectEpsgFactory.autoconfig(databaseMetaData);
        this.dialect = ansiDialectEpsgFactory.toANSI;
        return ansiDialectEpsgFactory;
    }

    @Override
    protected synchronized AbstractAuthorityFactory createBackingStore() throws FactoryException {
        AbstractAuthorityFactory abstractAuthorityFactory;
        boolean bl = LOGGER.isLoggable(Level.CONFIG);
        String string = null;
        String string2 = null;
        Hints hints = EMPTY_HINTS.clone();
        hints.putAll((Map<?, ?>)this.hints);
        hints.putAll(this.factories.getImplementationHints());
        try {
            abstractAuthorityFactory = this.createBackingStore(hints);
            if (bl && abstractAuthorityFactory instanceof DirectEpsgFactory) {
                DatabaseMetaData databaseMetaData = ((DirectEpsgFactory)abstractAuthorityFactory).connection.getMetaData();
                string = databaseMetaData.getDatabaseProductName();
                string2 = databaseMetaData.getURL();
            }
        }
        catch (SQLException sQLException) {
            String string3 = Errors.format(21, "EPSG");
            String string4 = sQLException.getSQLState();
            if ("08001".equals(string4) || "XJ004".equals(string4)) {
                throw new NoSuchFactoryException(string3, sQLException);
            }
            throw new FactoryException(string3, sQLException);
        }
        if (bl) {
            if (string == null) {
                string = '<' + Vocabulary.format(278) + '>';
            }
            if (string2 == null) {
                string2 = string;
            }
            ThreadedEpsgFactory.log(Loggings.format(Level.CONFIG, 16, string2, string));
        }
        if (abstractAuthorityFactory instanceof DirectEpsgFactory) {
            ((DirectEpsgFactory)abstractAuthorityFactory).buffered = this;
        }
        return abstractAuthorityFactory;
    }

    private static void log(LogRecord logRecord) {
        logRecord.setSourceClassName(ThreadedEpsgFactory.class.getName());
        logRecord.setSourceMethodName("createBackingStore");
        logRecord.setLoggerName(LOGGER.getName());
        LOGGER.log(logRecord);
    }

    @Override
    protected boolean canDisposeBackingStore(AbstractAuthorityFactory abstractAuthorityFactory) {
        if (abstractAuthorityFactory instanceof DirectEpsgFactory) {
            return ((DirectEpsgFactory)abstractAuthorityFactory).canDispose();
        }
        return super.canDisposeBackingStore(abstractAuthorityFactory);
    }

    @Override
    protected synchronized void dispose(boolean bl) {
        super.dispose(bl);
        if (bl && this.datasource instanceof DefaultDataSource) {
            ThreadedEpsgFactory.shutdown(((DefaultDataSource)this.datasource).url);
        }
        this.password = null;
        this.user = null;
        this.schema = null;
        this.datasource = null;
    }
}

