/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory.web;

import java.util.Collections;
import org.geotoolkit.referencing.crs.DefaultGeographicCRS;
import org.geotoolkit.referencing.cs.DefaultCartesianCS;
import org.geotoolkit.referencing.factory.ReferencingFactoryContainer;
import org.geotoolkit.referencing.factory.web.Code;
import org.geotoolkit.referencing.operation.DefiningConversion;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.ProjectedCRS;

abstract class Factlet {
    Factlet() {
    }

    public abstract int code();

    public abstract String getName();

    public abstract String getClassification();

    public final ProjectedCRS create(Code code, ReferencingFactoryContainer referencingFactoryContainer) throws FactoryException {
        String string = this.getClassification();
        ParameterValueGroup parameterValueGroup = referencingFactoryContainer.getMathTransformFactory().getDefaultParameters(string);
        this.setProjectionParameters(parameterValueGroup, code);
        String string2 = this.getName();
        DefiningConversion definingConversion = new DefiningConversion(string2, parameterValueGroup);
        return referencingFactoryContainer.getCRSFactory().createProjectedCRS(Collections.singletonMap("name", string2), DefaultGeographicCRS.WGS84, definingConversion, DefaultCartesianCS.PROJECTED);
    }

    protected abstract void setProjectionParameters(ParameterValueGroup var1, Code var2);
}

