/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory.web;

import java.util.Arrays;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.geotoolkit.factory.Factory;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.referencing.factory.AbstractAuthorityFactory;
import org.geotoolkit.referencing.factory.AllAuthoritiesFactory;
import org.geotoolkit.referencing.factory.AuthorityFactoryAdapter;
import org.geotoolkit.referencing.factory.FallbackAuthorityFactory;
import org.geotoolkit.referencing.factory.web.HTTP_AuthorityFactory;
import org.geotoolkit.referencing.factory.web.URN_Parser;
import org.geotoolkit.util.Version;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;

public class URN_AuthorityFactory
extends AuthorityFactoryAdapter
implements CRSAuthorityFactory,
CSAuthorityFactory,
DatumAuthorityFactory,
CoordinateOperationAuthorityFactory {
    private final AllAuthoritiesFactory factory;
    private final SortedMap<Version, AuthorityFactory> byVersions = new TreeMap<Version, AuthorityFactory>();
    private transient URN_Parser last;

    public URN_AuthorityFactory() {
        this(EMPTY_HINTS);
    }

    public URN_AuthorityFactory(Hints hints) {
        this(AllAuthoritiesFactory.getInstance(HTTP_AuthorityFactory.removeIgnoredHints(hints, "urn")));
    }

    public URN_AuthorityFactory(AllAuthoritiesFactory allAuthoritiesFactory) {
        super((AuthorityFactory)allAuthoritiesFactory);
        this.factory = allAuthoritiesFactory;
    }

    @Override
    public Citation getAuthority() {
        return Citations.URN_OGC;
    }

    private URN_Parser getParser(String string) throws NoSuchAuthorityCodeException {
        URN_Parser uRN_Parser = this.last;
        if (uRN_Parser == null || !uRN_Parser.urn.equals(string)) {
            this.last = uRN_Parser = new URN_Parser(string);
        }
        return uRN_Parser;
    }

    @Override
    protected AuthorityFactory getAuthorityFactory(String string) throws FactoryException {
        if (string != null) {
            return this.getAuthorityFactory(this.getParser((String)string).type.type.asSubclass(AuthorityFactory.class), string);
        }
        return super.getAuthorityFactory(string);
    }

    @Override
    protected DatumAuthorityFactory getDatumAuthorityFactory(String string) throws FactoryException {
        if (string != null) {
            URN_Parser uRN_Parser = this.getParser(string);
            uRN_Parser.logWarningIfTypeMismatch(DatumAuthorityFactory.class);
            AuthorityFactory authorityFactory = this.getVersionedFactory(uRN_Parser);
            if (authorityFactory instanceof DatumAuthorityFactory) {
                return (DatumAuthorityFactory)authorityFactory;
            }
        }
        return super.getDatumAuthorityFactory(string);
    }

    @Override
    protected CSAuthorityFactory getCSAuthorityFactory(String string) throws FactoryException {
        if (string != null) {
            URN_Parser uRN_Parser = this.getParser(string);
            uRN_Parser.logWarningIfTypeMismatch(CSAuthorityFactory.class);
            AuthorityFactory authorityFactory = this.getVersionedFactory(uRN_Parser);
            if (authorityFactory instanceof CSAuthorityFactory) {
                return (CSAuthorityFactory)authorityFactory;
            }
        }
        return super.getCSAuthorityFactory(string);
    }

    @Override
    protected CRSAuthorityFactory getCRSAuthorityFactory(String string) throws FactoryException {
        if (string != null) {
            URN_Parser uRN_Parser = this.getParser(string);
            uRN_Parser.logWarningIfTypeMismatch(CRSAuthorityFactory.class);
            AuthorityFactory authorityFactory = this.getVersionedFactory(uRN_Parser);
            if (authorityFactory instanceof CRSAuthorityFactory) {
                return (CRSAuthorityFactory)authorityFactory;
            }
        }
        return super.getCRSAuthorityFactory(string);
    }

    @Override
    protected CoordinateOperationAuthorityFactory getCoordinateOperationAuthorityFactory(String string) throws FactoryException {
        if (string != null) {
            URN_Parser uRN_Parser = this.getParser(string);
            uRN_Parser.logWarningIfTypeMismatch(CoordinateOperationAuthorityFactory.class);
            AuthorityFactory authorityFactory = this.getVersionedFactory(uRN_Parser);
            if (authorityFactory instanceof CoordinateOperationAuthorityFactory) {
                return (CoordinateOperationAuthorityFactory)authorityFactory;
            }
        }
        return super.getCoordinateOperationAuthorityFactory(string);
    }

    private synchronized AuthorityFactory getVersionedFactory(URN_Parser uRN_Parser) throws FactoryException {
        Version version = uRN_Parser.version;
        if (version == null) {
            return null;
        }
        AuthorityFactory authorityFactory = (AuthorityFactory)this.byVersions.get(version);
        if (authorityFactory == null && (authorityFactory = this.createVersionedFactory(version)) != null) {
            this.byVersions.put(version, authorityFactory);
        }
        return authorityFactory;
    }

    protected AuthorityFactory createVersionedFactory(Version version) throws FactoryException {
        Hints hints = EMPTY_HINTS.clone();
        hints.putAll(this.factory.getImplementationHints());
        hints.put(Hints.VERSION, version);
        List<AuthorityFactory> list = Arrays.asList(AllAuthoritiesFactory.getInstance(hints), this.factory);
        return FallbackAuthorityFactory.create(list);
    }

    @Override
    protected String toBackingFactoryCode(String string) throws FactoryException {
        return this.getParser(string).getAuthorityCode();
    }

    @Override
    protected boolean hasCompatibleHints(Hints hints) {
        return super.hasCompatibleHints(HTTP_AuthorityFactory.removeIgnoredHints(hints, "urn"));
    }

    @Override
    protected void setOrdering(Factory.Organizer organizer) {
        super.setOrdering(organizer);
        organizer.after(AbstractAuthorityFactory.class, true);
    }
}

