/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory.web;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.referencing.cs.DefaultEllipsoidalCS;
import org.geotoolkit.referencing.datum.DefaultEllipsoid;
import org.geotoolkit.referencing.datum.DefaultPrimeMeridian;
import org.geotoolkit.referencing.factory.DirectAuthorityFactory;
import org.geotoolkit.util.SimpleInternationalString;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.util.InternationalString;

public class WebCRSFactory
extends DirectAuthorityFactory
implements CRSAuthorityFactory {
    private static final String PREFIX = "CRS";
    private final Map<Integer, CoordinateReferenceSystem> crsMap = new TreeMap<Integer, CoordinateReferenceSystem>();

    public WebCRSFactory() {
        this(EMPTY_HINTS);
    }

    public WebCRSFactory(Hints hints) {
        super(hints);
    }

    private synchronized void ensureInitialized() throws FactoryException {
        if (this.crsMap.isEmpty()) {
            this.add(84, "WGS84", DefaultEllipsoid.WGS84);
            this.add(83, "NAD83", DefaultEllipsoid.GRS80);
            this.add(27, "NAD27", DefaultEllipsoid.CLARKE_1866);
        }
    }

    private void add(int n, String string, Ellipsoid ellipsoid) throws FactoryException {
        assert (Thread.holdsLock(this));
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Citation citation = this.getAuthority();
        String string2 = String.valueOf(n);
        hashMap.put("name", string);
        hashMap.put("authority", citation);
        GeodeticDatum geodeticDatum = this.factories.getDatumFactory().createGeodeticDatum(hashMap, ellipsoid, DefaultPrimeMeridian.GREENWICH);
        hashMap.put("identifiers", new NamedIdentifier[]{new NamedIdentifier(citation, string2), new NamedIdentifier(citation, PREFIX + string2)});
        GeographicCRS geographicCRS = this.factories.getCRSFactory().createGeographicCRS(hashMap, geodeticDatum, DefaultEllipsoidalCS.GEODETIC_2D);
        if (this.crsMap.put(n, geographicCRS) != null) {
            throw new IllegalArgumentException(string2);
        }
    }

    @Override
    public Citation getAuthority() {
        return Citations.CRS;
    }

    @Override
    public Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> clazz) throws FactoryException {
        this.ensureInitialized();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (Map.Entry<Integer, CoordinateReferenceSystem> entry : this.crsMap.entrySet()) {
            CoordinateReferenceSystem coordinateReferenceSystem = entry.getValue();
            if (!clazz.isAssignableFrom(coordinateReferenceSystem.getClass())) continue;
            Integer n = entry.getKey();
            linkedHashSet.add(String.valueOf(n));
        }
        return linkedHashSet;
    }

    @Override
    public InternationalString getDescriptionText(String string) throws FactoryException {
        return new SimpleInternationalString(this.createObject(string).getName().getCode());
    }

    @Override
    public IdentifiedObject createObject(String string) throws FactoryException {
        return this.createCoordinateReferenceSystem(string);
    }

    @Override
    public CoordinateReferenceSystem createCoordinateReferenceSystem(String string) throws FactoryException {
        int n;
        String string2 = this.trimAuthority(string).toUpperCase();
        if (string2.startsWith(PREFIX)) {
            string2 = string2.substring(PREFIX.length());
        }
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            NoSuchAuthorityCodeException noSuchAuthorityCodeException = this.noSuchAuthorityCode(CoordinateReferenceSystem.class, string);
            noSuchAuthorityCodeException.initCause(numberFormatException);
            throw noSuchAuthorityCodeException;
        }
        this.ensureInitialized();
        CoordinateReferenceSystem coordinateReferenceSystem = this.crsMap.get(n);
        if (coordinateReferenceSystem != null) {
            return coordinateReferenceSystem;
        }
        throw this.noSuchAuthorityCode(CoordinateReferenceSystem.class, string);
    }
}

