/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.geotoolkit.factory.AuthorityFactoryFinder;
import org.geotoolkit.factory.Factory;
import org.geotoolkit.factory.FactoryRegistryException;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.referencing.AbstractIdentifiedObject;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.factory.BackingStoreException;
import org.geotoolkit.referencing.operation.AbstractCoordinateOperation;
import org.geotoolkit.referencing.operation.DefaultCoordinateOperationFactory;
import org.geotoolkit.referencing.operation.DefaultOperationMethod;
import org.geotoolkit.resources.Loggings;
import org.geotoolkit.util.Utilities;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.quality.ConformanceResult;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;

public class AuthorityBackedFactory
extends DefaultCoordinateOperationFactory {
    private static final String DEFAULT_AUTHORITY = "EPSG";
    private CoordinateOperationAuthorityFactory authorityFactory;
    private final ThreadLocal<Boolean> processing = new ThreadLocal();

    public AuthorityBackedFactory() {
        this(EMPTY_HINTS);
    }

    public AuthorityBackedFactory(Hints hints) {
        super(hints);
        if (hints == null) {
            hints = EMPTY_HINTS;
        }
        hints = hints.clone();
        hints.keySet().removeAll(this.hints.keySet());
        hints.remove(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER);
        hints.remove(Hints.FORCE_STANDARD_AXIS_DIRECTIONS);
        hints.remove(Hints.FORCE_STANDARD_AXIS_UNITS);
        if (!hints.isEmpty()) {
            AuthorityBackedFactory.noForce(hints);
            this.authorityFactory = AuthorityFactoryFinder.getCoordinateOperationAuthorityFactory(DEFAULT_AUTHORITY, hints);
        }
    }

    private static void noForce(Hints hints) {
        hints.put(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, Boolean.FALSE);
        hints.put(Hints.FORCE_STANDARD_AXIS_DIRECTIONS, Boolean.FALSE);
        hints.put(Hints.FORCE_STANDARD_AXIS_UNITS, Boolean.FALSE);
    }

    @Override
    protected void setOrdering(Factory.Organizer organizer) {
        super.setOrdering(organizer);
        organizer.before(DefaultCoordinateOperationFactory.class, false);
    }

    protected CoordinateOperationAuthorityFactory getAuthorityFactory() {
        if (this.authorityFactory == null) {
            Hints hints = EMPTY_HINTS.clone();
            AuthorityBackedFactory.noForce(hints);
            this.authorityFactory = AuthorityFactoryFinder.getCoordinateOperationAuthorityFactory(DEFAULT_AUTHORITY, hints);
        }
        return this.authorityFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CoordinateOperation createFromDatabase(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) {
        boolean bl;
        Set<CoordinateOperation> set;
        String string;
        if (Boolean.TRUE.equals(this.processing.get())) {
            return null;
        }
        CoordinateOperationAuthorityFactory coordinateOperationAuthorityFactory = this.getAuthorityFactory();
        Citation citation = coordinateOperationAuthorityFactory.getAuthority();
        ReferenceIdentifier referenceIdentifier = AbstractIdentifiedObject.getIdentifier(coordinateReferenceSystem, citation);
        if (referenceIdentifier == null) {
            return null;
        }
        ReferenceIdentifier referenceIdentifier2 = AbstractIdentifiedObject.getIdentifier(coordinateReferenceSystem2, citation);
        if (referenceIdentifier2 == null) {
            return null;
        }
        String string2 = referenceIdentifier.getCode().trim();
        if (string2.equals(string = referenceIdentifier2.getCode().trim())) {
            return null;
        }
        try {
            set = coordinateOperationAuthorityFactory.createFromCoordinateReferenceSystemCodes(string2, string);
            boolean bl2 = bl = set == null || set.isEmpty();
            if (bl) {
                set = coordinateOperationAuthorityFactory.createFromCoordinateReferenceSystemCodes(string, string2);
            }
        }
        catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
            return null;
        }
        catch (FactoryException factoryException) {
            AuthorityBackedFactory.log(factoryException, coordinateOperationAuthorityFactory);
            return null;
        }
        if (set != null) {
            Iterator<CoordinateOperation> iterator = set.iterator();
            while (iterator.hasNext()) {
                CoordinateOperation coordinateOperation;
                block26: {
                    try {
                        coordinateOperation = iterator.next();
                        if (coordinateOperation == null) continue;
                        if (!bl) break block26;
                        coordinateOperation = this.inverse(coordinateOperation);
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        continue;
                    }
                    catch (FactoryException factoryException) {
                        AuthorityBackedFactory.log(factoryException, coordinateOperationAuthorityFactory);
                        continue;
                    }
                    catch (BackingStoreException backingStoreException) {
                        AuthorityBackedFactory.log(backingStoreException, coordinateOperationAuthorityFactory);
                        continue;
                    }
                }
                CoordinateReferenceSystem coordinateReferenceSystem3 = coordinateOperation.getSourceCRS();
                CoordinateReferenceSystem coordinateReferenceSystem4 = coordinateOperation.getTargetCRS();
                try {
                    MathTransform mathTransform;
                    MathTransform mathTransform2;
                    if (!CRS.equalsIgnoreMetadata(coordinateReferenceSystem, coordinateReferenceSystem3)) {
                        try {
                            this.processing.set(Boolean.TRUE);
                            mathTransform2 = this.createOperation(coordinateReferenceSystem, coordinateReferenceSystem3).getMathTransform();
                            coordinateReferenceSystem3 = coordinateReferenceSystem;
                        }
                        finally {
                            this.processing.set(Boolean.FALSE);
                        }
                    } else {
                        mathTransform2 = null;
                    }
                    if (!CRS.equalsIgnoreMetadata(coordinateReferenceSystem4, coordinateReferenceSystem2)) {
                        try {
                            this.processing.set(Boolean.TRUE);
                            mathTransform = this.createOperation(coordinateReferenceSystem4, coordinateReferenceSystem2).getMathTransform();
                            coordinateReferenceSystem4 = coordinateReferenceSystem2;
                        }
                        finally {
                            this.processing.set(Boolean.FALSE);
                        }
                    } else {
                        mathTransform = null;
                    }
                    coordinateOperation = this.transform(coordinateReferenceSystem3, mathTransform2, coordinateOperation, mathTransform, coordinateReferenceSystem4);
                }
                catch (FactoryException factoryException) {
                    AuthorityBackedFactory.log(factoryException, coordinateOperationAuthorityFactory);
                    return null;
                }
                if (!this.accept(coordinateOperation)) continue;
                return coordinateOperation;
            }
        }
        return null;
    }

    private CoordinateOperation transform(CoordinateReferenceSystem coordinateReferenceSystem, MathTransform mathTransform, CoordinateOperation coordinateOperation, MathTransform mathTransform2, CoordinateReferenceSystem coordinateReferenceSystem2) throws FactoryException {
        Object object;
        CoordinateOperation[] coordinateOperationArray;
        if ((mathTransform == null || mathTransform.isIdentity()) && (mathTransform2 == null || mathTransform2.isIdentity())) {
            return coordinateOperation;
        }
        Map<String, ?> map = AbstractIdentifiedObject.getProperties(coordinateOperation);
        if (coordinateOperation instanceof ConcatenatedOperation && (coordinateOperationArray = (object = ((ConcatenatedOperation)coordinateOperation).getOperations()).toArray(new CoordinateOperation[object.size()])).length != 0) {
            CoordinateOperation coordinateOperation2 = coordinateOperationArray[0];
            if (coordinateOperationArray.length == 1) {
                coordinateOperationArray[0] = this.transform(coordinateReferenceSystem, mathTransform, coordinateOperation2, mathTransform2, coordinateReferenceSystem2);
            } else {
                CoordinateOperation coordinateOperation3 = coordinateOperationArray[coordinateOperationArray.length - 1];
                coordinateOperationArray[0] = this.transform(coordinateReferenceSystem, mathTransform, coordinateOperation2, null, coordinateOperation2.getTargetCRS());
                coordinateOperationArray[coordinateOperationArray.length - 1] = this.transform(coordinateOperation3.getSourceCRS(), null, coordinateOperation3, mathTransform2, coordinateReferenceSystem2);
            }
            return this.createConcatenatedOperation(map, coordinateOperationArray);
        }
        object = coordinateOperation.getMathTransform();
        coordinateOperationArray = this.getMathTransformFactory();
        if (mathTransform != null) {
            object = coordinateOperationArray.createConcatenatedTransform(mathTransform, (MathTransform)object);
        }
        if (mathTransform2 != null) {
            object = coordinateOperationArray.createConcatenatedTransform((MathTransform)object, mathTransform2);
        }
        assert (!object.equals(coordinateOperation.getMathTransform())) : object;
        Class<? extends CoordinateOperation> clazz = AbstractCoordinateOperation.getType(coordinateOperation);
        OperationMethod operationMethod = null;
        if (coordinateOperation instanceof SingleOperation && (operationMethod = ((SingleOperation)coordinateOperation).getMethod()) != null) {
            Integer n = object.getSourceDimensions();
            Integer n2 = object.getTargetDimensions();
            if (!Utilities.equals(n, operationMethod.getSourceDimensions()) || !Utilities.equals(n2, operationMethod.getTargetDimensions())) {
                operationMethod = new DefaultOperationMethod(operationMethod, n, n2);
            }
        }
        return this.createFromMathTransform(map, coordinateReferenceSystem, coordinateReferenceSystem2, (MathTransform)object, operationMethod, clazz);
    }

    private static void log(Exception exception, AuthorityFactory authorityFactory) {
        LogRecord logRecord = Loggings.format(Level.WARNING, 7, authorityFactory.getAuthority().getTitle());
        logRecord.setSourceClassName(AuthorityBackedFactory.class.getName());
        logRecord.setSourceMethodName("createFromDatabase");
        logRecord.setThrown(exception);
        logRecord.setLoggerName(LOGGER.getName());
        LOGGER.log(logRecord);
    }

    protected boolean accept(CoordinateOperation coordinateOperation) {
        return true;
    }

    @Override
    public ConformanceResult availability() {
        try {
            CoordinateOperationAuthorityFactory coordinateOperationAuthorityFactory = this.getAuthorityFactory();
            if (coordinateOperationAuthorityFactory instanceof Factory) {
                return ((Factory)((Object)coordinateOperationAuthorityFactory)).availability();
            }
        }
        catch (FactoryRegistryException factoryRegistryException) {
            return new Factory.Availability(factoryRegistryException);
        }
        return super.availability();
    }
}

