/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation;

import java.io.Serializable;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.NullArgumentException;
import org.geotoolkit.util.SimpleInternationalString;
import org.geotoolkit.util.Utilities;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.operation.Formula;
import org.opengis.util.InternationalString;

public class DefaultFormula
implements Formula,
Serializable {
    private static final long serialVersionUID = 1929966748615362698L;
    private final InternationalString formula;
    private final Citation citation;

    public DefaultFormula(CharSequence charSequence) {
        DefaultFormula.ensureNonNull("formula", charSequence);
        this.formula = charSequence instanceof InternationalString ? (InternationalString)charSequence : new SimpleInternationalString(((Object)charSequence).toString());
        this.citation = null;
    }

    public DefaultFormula(Citation citation) {
        DefaultFormula.ensureNonNull("citation", citation);
        this.citation = citation;
        this.formula = null;
    }

    private static void ensureNonNull(String string, Object object) throws NullArgumentException {
        if (object == null) {
            throw new NullArgumentException(Errors.format(152, string));
        }
    }

    @Override
    public InternationalString getFormula() {
        return this.formula;
    }

    @Override
    public Citation getCitation() {
        return this.citation;
    }

    public int hashCode() {
        int n = 1334364298;
        if (this.formula != null) {
            n += this.formula.hashCode();
        }
        if (this.citation != null) {
            n += this.citation.hashCode() * 31;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            DefaultFormula defaultFormula = (DefaultFormula)object;
            return Utilities.equals(this.formula, defaultFormula.formula) && Utilities.equals(this.citation, defaultFormula.citation);
        }
        return false;
    }

    public String toString() {
        InternationalString internationalString = this.citation != null ? this.citation.getTitle() : this.formula;
        return "FORMULA[\"" + internationalString + "\"]";
    }
}

