/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import javax.measure.converter.ConversionException;
import org.geotoolkit.factory.FactoryRegistry;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.internal.referencing.CRSUtilities;
import org.geotoolkit.internal.referencing.MathTransformDecorator;
import org.geotoolkit.internal.referencing.ParameterizedAffine;
import org.geotoolkit.io.wkt.MathTransformParser;
import org.geotoolkit.io.wkt.Symbols;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.parameter.Parameters;
import org.geotoolkit.referencing.cs.AbstractCS;
import org.geotoolkit.referencing.factory.ReferencingFactory;
import org.geotoolkit.referencing.operation.MathTransformProvider;
import org.geotoolkit.referencing.operation.OperationMethodSet;
import org.geotoolkit.referencing.operation.matrix.MatrixFactory;
import org.geotoolkit.referencing.operation.transform.ConcatenatedTransform;
import org.geotoolkit.referencing.operation.transform.PassThroughTransform;
import org.geotoolkit.referencing.operation.transform.ProjectiveTransform;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.XArrays;
import org.geotoolkit.util.collection.WeakHashSet;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchIdentifierException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;

public class DefaultMathTransformFactory
extends ReferencingFactory
implements MathTransformFactory {
    private static final Hints HINTS = null;
    private final ThreadLocal<MathTransformParser> parser;
    private MathTransformProvider lastProvider;
    private final ThreadLocal<OperationMethod> lastMethod;
    private final WeakHashSet<MathTransform> pool;
    private final FactoryRegistry registry = new FactoryRegistry(MathTransformProvider.class);
    private volatile MathTransformProvider[] providers;

    public DefaultMathTransformFactory() {
        this.lastMethod = new ThreadLocal();
        this.parser = new ThreadLocal();
        this.pool = WeakHashSet.newInstance(MathTransform.class);
    }

    @Override
    public Citation getVendor() {
        return Citations.GEOTOOLKIT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MathTransformProvider[] getAvailableMethods() {
        MathTransformProvider[] mathTransformProviderArray = this.providers;
        if (mathTransformProviderArray == null) {
            FactoryRegistry factoryRegistry = this.registry;
            synchronized (factoryRegistry) {
                mathTransformProviderArray = this.providers;
                if (mathTransformProviderArray == null) {
                    Iterator<MathTransformProvider> iterator = this.registry.getServiceProviders(MathTransformProvider.class, null, HINTS, null);
                    int n = 0;
                    mathTransformProviderArray = new MathTransformProvider[64];
                    while (iterator.hasNext()) {
                        if (n == mathTransformProviderArray.length) {
                            mathTransformProviderArray = Arrays.copyOf(mathTransformProviderArray, n * 2);
                        }
                        mathTransformProviderArray[n++] = iterator.next();
                    }
                    mathTransformProviderArray = XArrays.resize(mathTransformProviderArray, n);
                    this.providers = mathTransformProviderArray;
                }
            }
        }
        return mathTransformProviderArray;
    }

    @Override
    public Set<OperationMethod> getAvailableMethods(Class<? extends SingleOperation> clazz) {
        return new OperationMethodSet(this.getAvailableMethods(), clazz);
    }

    @Override
    public OperationMethod getLastMethodUsed() {
        return this.lastMethod.get();
    }

    public OperationMethod getOperationMethod(String string) throws NoSuchIdentifierException {
        return this.getProvider(string);
    }

    private MathTransformProvider getProvider(String string) throws NoSuchIdentifierException {
        int n;
        MathTransformProvider mathTransformProvider = this.lastProvider;
        if (mathTransformProvider != null && mathTransformProvider.nameMatches(string)) {
            return mathTransformProvider;
        }
        MathTransformProvider[] mathTransformProviderArray = this.getAvailableMethods();
        for (n = 0; n < mathTransformProviderArray.length; ++n) {
            mathTransformProvider = mathTransformProviderArray[n];
            if (!mathTransformProvider.nameMatches(string)) continue;
            this.lastProvider = mathTransformProvider;
            return this.lastProvider;
        }
        n = string.indexOf(58);
        while (n >= 0) {
            String string2 = string.substring(0, n).trim();
            String string3 = string.substring(++n).trim();
            mathTransformProvider = this.lastProvider;
            if (mathTransformProvider != null && mathTransformProvider.identifierMatches(string2, string3)) {
                return mathTransformProvider;
            }
            for (int i = 0; i < mathTransformProviderArray.length; ++i) {
                mathTransformProvider = mathTransformProviderArray[i];
                if (!mathTransformProvider.identifierMatches(string2, string3)) continue;
                this.lastProvider = mathTransformProvider;
                return this.lastProvider;
            }
            n = string.indexOf(58, n);
        }
        throw new NoSuchIdentifierException(Errors.format(150, string), string);
    }

    @Override
    public ParameterValueGroup getDefaultParameters(String string) throws NoSuchIdentifierException {
        return this.getProvider(string).getParameters().createValue();
    }

    @Override
    public MathTransform createBaseToDerived(CoordinateReferenceSystem coordinateReferenceSystem, ParameterValueGroup parameterValueGroup, CoordinateSystem coordinateSystem) throws NoSuchIdentifierException, FactoryException {
        Object object;
        Ellipsoid ellipsoid = CRSUtilities.getHeadGeoEllipsoid(coordinateReferenceSystem);
        if (ellipsoid != null) {
            object = ellipsoid.getAxisUnit();
            Parameters.ensureSet(parameterValueGroup, "semi_major", ellipsoid.getSemiMajorAxis(), object, false);
            Parameters.ensureSet(parameterValueGroup, "semi_minor", ellipsoid.getSemiMinorAxis(), object, false);
        }
        object = this.createParameterizedTransform(parameterValueGroup);
        OperationMethod operationMethod = this.lastMethod.get();
        object = this.createBaseToDerived(coordinateReferenceSystem, (MathTransform)object, coordinateSystem);
        this.lastMethod.set(operationMethod);
        return object;
    }

    public MathTransform createBaseToDerived(CoordinateReferenceSystem coordinateReferenceSystem, MathTransform mathTransform, CoordinateSystem coordinateSystem) throws FactoryException {
        Object object;
        int n;
        int n2;
        Matrix matrix;
        Matrix matrix2;
        CoordinateSystem coordinateSystem2 = coordinateReferenceSystem.getCoordinateSystem();
        try {
            matrix2 = AbstractCS.swapAndScaleAxis(coordinateSystem2, AbstractCS.standard(coordinateSystem2));
            matrix = AbstractCS.swapAndScaleAxis(AbstractCS.standard(coordinateSystem), coordinateSystem);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        catch (ConversionException conversionException) {
            throw new FactoryException(conversionException);
        }
        MathTransform mathTransform2 = this.createAffineTransform(matrix2);
        MathTransform mathTransform3 = this.createAffineTransform(matrix);
        MathTransform mathTransform4 = mathTransform;
        int n3 = mathTransform3.getSourceDimensions() - mathTransform4.getTargetDimensions();
        if (n3 > 0) {
            mathTransform4 = this.createPassThroughTransform(0, mathTransform4, n3);
        }
        if ((n2 = mathTransform2.getTargetDimensions()) > (n = mathTransform4.getSourceDimensions())) {
            object = MatrixFactory.create(n + 1, n2 + 1);
            object.setElement(n, n2, 1.0);
            mathTransform2 = this.createConcatenatedTransform(this.createAffineTransform((Matrix)object), mathTransform2);
        }
        object = this.createConcatenatedTransform(this.createConcatenatedTransform(mathTransform2, mathTransform4), mathTransform3);
        if (mathTransform instanceof ParameterizedAffine) {
            object = ((ParameterizedAffine)mathTransform).wrap((MathTransform)object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MathTransform createParameterizedTransform(ParameterValueGroup parameterValueGroup) throws NoSuchIdentifierException, FactoryException {
        MathTransform mathTransform;
        OperationMethod operationMethod = null;
        try {
            MathTransformProvider mathTransformProvider;
            String string = parameterValueGroup.getDescriptor().getName().getCode();
            operationMethod = mathTransformProvider = this.getProvider(string);
            try {
                parameterValueGroup = mathTransformProvider.ensureValidValues(parameterValueGroup);
                mathTransform = mathTransformProvider.createMathTransform(parameterValueGroup);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new FactoryException(illegalArgumentException);
            }
            catch (IllegalStateException illegalStateException) {
                throw new FactoryException(illegalStateException);
            }
            if (mathTransform instanceof MathTransformDecorator) {
                MathTransformDecorator mathTransformDecorator = (MathTransformDecorator)mathTransform;
                operationMethod = mathTransformDecorator.method;
                mathTransform = mathTransformDecorator.transform;
            }
            mathTransform = this.pool.unique(mathTransform);
            this.lastMethod.set(operationMethod);
        }
        catch (Throwable throwable) {
            this.lastMethod.set(operationMethod);
            throw throwable;
        }
        return mathTransform;
    }

    @Override
    public MathTransform createAffineTransform(Matrix matrix) throws FactoryException {
        this.lastMethod.remove();
        return this.pool.unique(ProjectiveTransform.create(matrix));
    }

    @Override
    public MathTransform createConcatenatedTransform(MathTransform mathTransform, MathTransform mathTransform2) throws FactoryException {
        MathTransform mathTransform3;
        try {
            mathTransform3 = ConcatenatedTransform.create(mathTransform, mathTransform2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        mathTransform3 = this.pool.unique(mathTransform3);
        return mathTransform3;
    }

    @Override
    public MathTransform createPassThroughTransform(int n, MathTransform mathTransform, int n2) throws FactoryException {
        MathTransform mathTransform2;
        try {
            mathTransform2 = PassThroughTransform.create(n, mathTransform, n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        mathTransform2 = this.pool.unique(mathTransform2);
        return mathTransform2;
    }

    @Override
    public MathTransform createFromXML(String string) throws FactoryException {
        throw new FactoryException("Not yet implemented.");
    }

    @Override
    public MathTransform createFromWKT(String string) throws FactoryException {
        MathTransformParser mathTransformParser = this.parser.get();
        if (mathTransformParser == null) {
            mathTransformParser = new MathTransformParser(Symbols.DEFAULT, this);
            this.parser.set(mathTransformParser);
        }
        try {
            return mathTransformParser.parseMathTransform(string);
        }
        catch (ParseException parseException) {
            Throwable throwable = parseException.getCause();
            if (throwable instanceof FactoryException) {
                throw (FactoryException)throwable;
            }
            throw new FactoryException(parseException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanForPlugins() {
        FactoryRegistry factoryRegistry = this.registry;
        synchronized (factoryRegistry) {
            this.providers = null;
            this.registry.scanForPlugins();
        }
    }
}

