/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation;

import java.util.Map;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.referencing.operation.DefaultOperationMethod;
import org.geotoolkit.referencing.operation.DefaultSingleOperation;
import org.geotoolkit.referencing.operation.transform.PassThroughTransform;
import org.geotoolkit.util.UnsupportedImplementationException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.PassThroughOperation;
import org.opengis.referencing.operation.SingleOperation;

public class DefaultPassThroughOperation
extends DefaultSingleOperation
implements PassThroughOperation {
    private static final long serialVersionUID = 4308173919747248695L;
    protected final SingleOperation operation;

    public DefaultPassThroughOperation(Map<String, ?> map, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, SingleOperation singleOperation, int n, int n2) {
        this(map, coordinateReferenceSystem, coordinateReferenceSystem2, singleOperation, PassThroughTransform.create(n, singleOperation.getMathTransform(), n2));
    }

    public DefaultPassThroughOperation(Map<String, ?> map, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, SingleOperation singleOperation, MathTransform mathTransform) {
        super(map, coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform, new DefaultOperationMethod(mathTransform));
        this.operation = singleOperation;
        DefaultPassThroughOperation.ensureNonNull("operation", singleOperation);
        DefaultPassThroughOperation.ensureValidDimension(singleOperation.getSourceCRS(), mathTransform.getSourceDimensions());
        DefaultPassThroughOperation.ensureValidDimension(singleOperation.getTargetCRS(), mathTransform.getTargetDimensions());
    }

    private static void ensureValidDimension(CoordinateReferenceSystem coordinateReferenceSystem, int n) {
        if (coordinateReferenceSystem.getCoordinateSystem().getDimension() > n) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public SingleOperation getOperation() {
        return this.operation;
    }

    @Override
    public int[] getModifiedCoordinates() {
        if (!(this.transform instanceof PassThroughTransform)) {
            throw new UnsupportedImplementationException(this.transform.getClass());
        }
        return ((PassThroughTransform)this.transform).getModifiedCoordinates();
    }

    @Override
    public String formatWKT(Formatter formatter) {
        String string = super.formatWKT(formatter);
        try {
            int[] nArray = this.getModifiedCoordinates();
            for (int i = 0; i < nArray.length; ++i) {
                formatter.append(nArray[i]);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            formatter.setInvalidWKT(PassThroughOperation.class);
        }
        formatter.append(this.operation);
        return string;
    }
}

