/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.measure.unit.Unit;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.referencing.operation.DefaultOperationMethod;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.NullArgumentException;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterNameException;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.Projection;
import org.opengis.referencing.operation.SingleOperation;

public abstract class MathTransformProvider
extends DefaultOperationMethod {
    private static final long serialVersionUID = 7530475536803158473L;

    public MathTransformProvider(int n, int n2, ParameterDescriptorGroup parameterDescriptorGroup) {
        this((Map<String, ?>)MathTransformProvider.toMap(parameterDescriptorGroup), n, n2, parameterDescriptorGroup);
    }

    public MathTransformProvider(Map<String, ?> map, int n, int n2, ParameterDescriptorGroup parameterDescriptorGroup) {
        super(map, n, n2, parameterDescriptorGroup);
    }

    private static Map<String, Object> toMap(IdentifiedObject identifiedObject) {
        if (identifiedObject == null) {
            throw new NullArgumentException("parameters");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        hashMap.put("name", identifiedObject.getName());
        hashMap.put("identifiers", identifiedObject.getIdentifiers().toArray(EMPTY_IDENTIFIER_ARRAY));
        hashMap.put("alias", identifiedObject.getAlias().toArray(EMPTY_ALIAS_ARRAY));
        return hashMap;
    }

    final boolean identifierMatches(String string, String string2) {
        for (ReferenceIdentifier referenceIdentifier : this.getIdentifiers()) {
            if (!string.equals(referenceIdentifier.getCodeSpace()) || !string2.equals(referenceIdentifier.getCode())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Class<? extends SingleOperation> getOperationType() {
        return SingleOperation.class;
    }

    protected abstract MathTransform createMathTransform(ParameterValueGroup var1) throws InvalidParameterNameException, ParameterNotFoundException, InvalidParameterValueException, FactoryException;

    protected ParameterValueGroup ensureValidValues(ParameterValueGroup parameterValueGroup) throws InvalidParameterNameException, InvalidParameterValueException {
        ParameterDescriptorGroup parameterDescriptorGroup;
        ParameterDescriptorGroup parameterDescriptorGroup2 = this.getParameters();
        if (parameterDescriptorGroup2.equals(parameterDescriptorGroup = parameterValueGroup.getDescriptor())) {
            return parameterValueGroup;
        }
        ParameterValueGroup parameterValueGroup2 = parameterDescriptorGroup2.createValue();
        MathTransformProvider.copy(parameterValueGroup, parameterValueGroup2);
        return parameterValueGroup2;
    }

    private static void copy(ParameterValueGroup parameterValueGroup, ParameterValueGroup parameterValueGroup2) throws InvalidParameterNameException, InvalidParameterValueException {
        for (GeneralParameterValue generalParameterValue : parameterValueGroup.values()) {
            Serializable serializable;
            GeneralParameterValue generalParameterValue2;
            Object object;
            String string = generalParameterValue.getDescriptor().getName().getCode();
            if (generalParameterValue instanceof ParameterValueGroup) {
                object = parameterValueGroup2.getDescriptor().descriptor(string);
                if (object instanceof ParameterDescriptorGroup) {
                    generalParameterValue2 = (ParameterValueGroup)object.createValue();
                    MathTransformProvider.copy((ParameterValueGroup)generalParameterValue, generalParameterValue2);
                    parameterValueGroup.groups(string).add((ParameterValueGroup)generalParameterValue2);
                    continue;
                }
                throw new InvalidParameterNameException(Errors.format(186, string), string);
            }
            object = (ParameterValue)generalParameterValue;
            try {
                generalParameterValue2 = parameterValueGroup2.parameter(string);
            }
            catch (ParameterNotFoundException parameterNotFoundException) {
                serializable = new InvalidParameterNameException(Errors.format(186, string), string);
                ((Throwable)serializable).initCause(parameterNotFoundException);
                throw serializable;
            }
            Object t = object.getValue();
            serializable = object.getUnit();
            if (serializable == null) {
                generalParameterValue2.setValue(t);
                continue;
            }
            if (t instanceof Number) {
                generalParameterValue2.setValue(((Number)t).doubleValue(), (Unit<?>)serializable);
                continue;
            }
            if (t instanceof double[]) {
                generalParameterValue2.setValue((double[])t, (Unit<?>)serializable);
                continue;
            }
            throw new InvalidParameterValueException(Errors.format(63, string, t), string, t);
        }
    }

    @Override
    public String formatWKT(Formatter formatter) {
        Class<? extends SingleOperation> clazz = this.getOperationType();
        if (Projection.class.isAssignableFrom(clazz)) {
            return super.formatWKT(formatter);
        }
        formatter.setInvalidWKT(OperationMethod.class);
        return "OperationMethod";
    }
}

