/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.builder;

import java.awt.geom.AffineTransform;
import java.util.Arrays;
import org.geotoolkit.referencing.operation.matrix.MatrixFactory;
import org.geotoolkit.referencing.operation.matrix.XMatrix;
import org.geotoolkit.referencing.operation.transform.ProjectiveTransform;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.NullArgumentException;
import org.geotoolkit.util.Utilities;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;

public class GridToEnvelopeMapper {
    public static final int SWAP_XY = 1;
    public static final int REVERSE_AXIS = 2;
    private int defined;
    private GridEnvelope gridEnvelope;
    private Envelope userEnvelope;
    private PixelInCell anchor = PixelInCell.CELL_CENTER;
    private Boolean swapXY;
    private boolean[] reverseAxis;
    private MathTransform transform;

    public GridToEnvelopeMapper() {
    }

    public GridToEnvelopeMapper(GridEnvelope gridEnvelope, Envelope envelope) throws MismatchedDimensionException {
        GridToEnvelopeMapper.ensureNonNull("gridEnvelope", gridEnvelope);
        GridToEnvelopeMapper.ensureNonNull("userEnvelope", envelope);
        int n = gridEnvelope.getDimension();
        int n2 = envelope.getDimension();
        if (n2 != n) {
            throw new MismatchedDimensionException(Errors.format(100, n, n2));
        }
        this.gridEnvelope = gridEnvelope;
        this.userEnvelope = envelope;
    }

    private static void ensureNonNull(String string, Object object) throws NullArgumentException {
        if (object == null) {
            throw new NullArgumentException(Errors.format(152, string));
        }
    }

    private static void ensureDimensionMatch(GridEnvelope gridEnvelope, Envelope envelope, boolean bl) {
        if (gridEnvelope != null && envelope != null) {
            int n;
            int n2;
            String string;
            if (bl) {
                string = "gridEnvelope";
                n2 = gridEnvelope.getDimension();
                n = envelope.getDimension();
            } else {
                string = "userEnvelope";
                n2 = envelope.getDimension();
                n = gridEnvelope.getDimension();
            }
            if (n2 != n) {
                throw new MismatchedDimensionException(Errors.format(101, string, n2, n));
            }
        }
    }

    private void reset() {
        this.transform = null;
        if (this.isAutomatic(2)) {
            this.reverseAxis = null;
        }
        if (this.isAutomatic(1)) {
            this.swapXY = null;
        }
    }

    public PixelInCell getPixelAnchor() {
        return this.anchor;
    }

    public void setPixelAnchor(PixelInCell pixelInCell) {
        GridToEnvelopeMapper.ensureNonNull("anchor", pixelInCell);
        if (!Utilities.equals(this.anchor, pixelInCell)) {
            this.anchor = pixelInCell;
            this.reset();
        }
    }

    public GridEnvelope getGridRange() throws IllegalStateException {
        if (this.gridEnvelope == null) {
            throw new IllegalStateException(Errors.format(107, "gridEnvelope"));
        }
        return this.gridEnvelope;
    }

    public void setGridRange(GridEnvelope gridEnvelope) {
        GridToEnvelopeMapper.ensureNonNull("gridEnvelope", gridEnvelope);
        GridToEnvelopeMapper.ensureDimensionMatch(gridEnvelope, this.userEnvelope, true);
        if (!Utilities.equals(this.gridEnvelope, gridEnvelope)) {
            this.gridEnvelope = gridEnvelope;
            this.reset();
        }
    }

    public Envelope getEnvelope() throws IllegalStateException {
        if (this.userEnvelope == null) {
            throw new IllegalStateException(Errors.format(107, "envelope"));
        }
        return this.userEnvelope;
    }

    public void setEnvelope(Envelope envelope) {
        GridToEnvelopeMapper.ensureNonNull("envelope", envelope);
        GridToEnvelopeMapper.ensureDimensionMatch(this.gridEnvelope, envelope, false);
        if (!Utilities.equals(this.userEnvelope, envelope)) {
            this.userEnvelope = envelope;
            this.reset();
        }
    }

    private static boolean swapXY(CoordinateSystem coordinateSystem) {
        if (coordinateSystem != null && coordinateSystem.getDimension() >= 2) {
            return AxisDirection.NORTH.equals(coordinateSystem.getAxis(0).getDirection().absolute()) && AxisDirection.EAST.equals(coordinateSystem.getAxis(1).getDirection().absolute());
        }
        return false;
    }

    public boolean getSwapXY() {
        if (this.swapXY == null) {
            boolean bl = false;
            if (this.isAutomatic(1)) {
                bl = GridToEnvelopeMapper.swapXY(this.getCoordinateSystem());
            }
            this.swapXY = bl;
        }
        return this.swapXY;
    }

    public void setSwapXY(boolean bl) {
        Boolean bl2 = bl;
        if (!bl2.equals(this.swapXY)) {
            this.reset();
        }
        this.swapXY = bl2;
        this.defined |= 1;
    }

    public boolean[] getReverseAxis() {
        if (this.reverseAxis == null) {
            CoordinateSystem coordinateSystem = this.getCoordinateSystem();
            if (coordinateSystem != null) {
                int n = coordinateSystem.getDimension();
                this.reverseAxis = new boolean[n];
                if (this.isAutomatic(2)) {
                    int n2;
                    for (n2 = 0; n2 < n; ++n2) {
                        AxisDirection axisDirection = coordinateSystem.getAxis(n2).getDirection();
                        AxisDirection axisDirection2 = axisDirection.absolute();
                        this.reverseAxis[n2] = axisDirection.equals(axisDirection2.opposite());
                    }
                    if (n >= 2) {
                        n2 = this.getSwapXY() ? 0 : 1;
                        this.reverseAxis[n2] = !this.reverseAxis[n2];
                    }
                }
            } else {
                int n = 0;
                if (this.gridEnvelope != null) {
                    n = this.gridEnvelope.getDimension();
                } else if (this.userEnvelope != null) {
                    n = this.userEnvelope.getDimension();
                }
                if (n >= 2) {
                    this.reverseAxis = new boolean[n];
                    this.reverseAxis[1] = true;
                }
            }
        }
        return this.reverseAxis;
    }

    public void setReverseAxis(boolean[] blArray) {
        if (!Arrays.equals(this.reverseAxis, blArray)) {
            this.reset();
        }
        this.reverseAxis = blArray;
        this.defined |= 2;
    }

    public void reverseAxis(int n) {
        if (this.reverseAxis == null) {
            int n2;
            if (this.gridEnvelope != null) {
                n2 = this.gridEnvelope.getDimension();
            } else {
                GridToEnvelopeMapper.ensureNonNull("envelope", this.userEnvelope);
                n2 = this.userEnvelope.getDimension();
            }
            this.reverseAxis = new boolean[n2];
        }
        if (!this.reverseAxis[n]) {
            this.reset();
        }
        this.reverseAxis[n] = true;
        this.defined |= 2;
    }

    public boolean isAutomatic(int n) {
        return (this.defined & n) == 0;
    }

    public void setAutomatic(int n) {
        this.defined &= ~n;
    }

    private CoordinateSystem getCoordinateSystem() {
        CoordinateReferenceSystem coordinateReferenceSystem;
        if (this.userEnvelope != null && (coordinateReferenceSystem = this.userEnvelope.getCoordinateReferenceSystem()) != null) {
            return coordinateReferenceSystem.getCoordinateSystem();
        }
        return null;
    }

    public MathTransform createTransform() throws IllegalStateException {
        if (this.transform == null) {
            double d;
            GridEnvelope gridEnvelope = this.getGridRange();
            Envelope envelope = this.getEnvelope();
            boolean bl = this.getSwapXY();
            boolean[] blArray = this.getReverseAxis();
            PixelInCell pixelInCell = this.getPixelAnchor();
            int n = gridEnvelope.getDimension();
            if (PixelInCell.CELL_CENTER.equals(pixelInCell)) {
                d = 0.5;
            } else if (PixelInCell.CELL_CORNER.equals(pixelInCell)) {
                d = 0.0;
            } else {
                throw new IllegalStateException(Errors.format(63, "gridType", pixelInCell));
            }
            XMatrix xMatrix = MatrixFactory.create(n + 1);
            for (int i = 0; i < n; ++i) {
                double d2;
                int n2 = i;
                if (bl && n2 <= 1) {
                    n2 = 1 - n2;
                }
                double d3 = envelope.getSpan(n2) / (double)gridEnvelope.getSpan(i);
                if (blArray == null || n2 >= blArray.length || !blArray[n2]) {
                    d2 = envelope.getMinimum(n2);
                } else {
                    d3 = -d3;
                    d2 = envelope.getMaximum(n2);
                }
                xMatrix.setElement(n2, n2, 0.0);
                xMatrix.setElement(n2, i, d3);
                xMatrix.setElement(n2, n, d2 -= d3 * ((double)gridEnvelope.getLow(i) - d));
            }
            this.transform = ProjectiveTransform.create(xMatrix);
        }
        return this.transform;
    }

    public AffineTransform createAffineTransform() throws IllegalStateException {
        MathTransform mathTransform = this.createTransform();
        if (mathTransform instanceof AffineTransform) {
            return (AffineTransform)((Object)mathTransform);
        }
        throw new IllegalStateException(Errors.format(126));
    }
}

