/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.matrix;

import java.io.Serializable;
import javax.vecmath.SingularMatrixException;
import org.geotoolkit.internal.referencing.MatrixUtilities;
import org.geotoolkit.referencing.operation.matrix.GeneralMatrix;
import org.geotoolkit.referencing.operation.matrix.XMatrix;
import org.geotoolkit.resources.Errors;
import org.opengis.referencing.operation.Matrix;

public class Matrix1
implements XMatrix,
Serializable {
    private static final long serialVersionUID = -4829171016106097031L;
    public double m00;
    public static final int SIZE = 1;

    public Matrix1() {
        this.m00 = 1.0;
    }

    public Matrix1(double d) {
        this.m00 = d;
    }

    public Matrix1(Matrix matrix) throws IllegalArgumentException {
        if (matrix.getNumRow() != 1 || matrix.getNumCol() != 1) {
            throw new IllegalArgumentException(Errors.format(75));
        }
        this.m00 = matrix.getElement(0, 0);
    }

    @Override
    public final int getNumRow() {
        return 1;
    }

    @Override
    public final int getNumCol() {
        return 1;
    }

    @Override
    public final double getElement(int n, int n2) {
        if (n == 0 && n2 == 0) {
            return this.m00;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final void setElement(int n, int n2, double d) {
        if (n != 0 || n2 != 0) {
            throw new IndexOutOfBoundsException();
        }
        this.m00 = d;
    }

    @Override
    public final void setZero() {
        this.m00 = 0.0;
    }

    @Override
    public final void setIdentity() {
        this.m00 = 1.0;
    }

    @Override
    public final boolean isIdentity() {
        return this.m00 == 1.0;
    }

    @Override
    public final boolean isIdentity(double d) {
        return Math.abs(this.m00 - 1.0) <= Math.abs(d);
    }

    @Override
    public final boolean isAffine() {
        return this.m00 == 1.0;
    }

    @Override
    public final void negate() {
        this.m00 = -this.m00;
    }

    @Override
    public final void transpose() {
    }

    @Override
    public final void invert() {
        if (this.m00 == 0.0) {
            throw new SingularMatrixException();
        }
        this.m00 = 1.0 / this.m00;
    }

    @Override
    public final void multiply(Matrix matrix) {
        if (matrix.getNumRow() != 1 || matrix.getNumCol() != 1) {
            throw new IllegalArgumentException(Errors.format(75));
        }
        this.m00 *= matrix.getElement(0, 0);
    }

    @Override
    public boolean equals(Matrix matrix, double d) {
        return MatrixUtilities.epsilonEqual(this, matrix, d, false);
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            Matrix1 matrix1 = (Matrix1)object;
            return Double.doubleToLongBits(this.m00) == Double.doubleToLongBits(matrix1.m00);
        }
        return false;
    }

    public int hashCode() {
        return (int)(Double.doubleToLongBits(this.m00) ^ 0xBCFB568C01624679L);
    }

    public String toString() {
        return GeneralMatrix.toString(this);
    }

    @Override
    public Matrix1 clone() {
        try {
            return (Matrix1)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }
}

