/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.projection;

import java.awt.geom.AffineTransform;
import org.geotoolkit.internal.referencing.Identifiers;
import org.geotoolkit.measure.Latitude;
import org.geotoolkit.referencing.operation.projection.Assertions;
import org.geotoolkit.referencing.operation.projection.ProjectionException;
import org.geotoolkit.referencing.operation.projection.UnitaryProjection;
import org.geotoolkit.resources.Errors;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;

public class AlbersEqualArea
extends UnitaryProjection {
    private static final long serialVersionUID = -3024658742514888646L;
    private static final double EPSILON = 1.0E-7;
    final double n;
    final double c;
    private final double ec;

    public static MathTransform2D create(ParameterDescriptorGroup parameterDescriptorGroup, ParameterValueGroup parameterValueGroup) {
        UnitaryProjection.Parameters parameters = new UnitaryProjection.Parameters(parameterDescriptorGroup, parameterValueGroup);
        AlbersEqualArea albersEqualArea = parameters.isSpherical() ? new Spherical(parameters) : new AlbersEqualArea(parameters);
        return albersEqualArea.createConcatenatedTransform();
    }

    protected AlbersEqualArea(UnitaryProjection.Parameters parameters) {
        super(parameters);
        double d;
        boolean bl;
        double d2;
        double d3;
        double d4 = parameters.latitudeOfOrigin;
        switch (parameters.standardParallels.length) {
            default: {
                throw AlbersEqualArea.unknownParameter("standard_parallel_3");
            }
            case 2: {
                d3 = parameters.standardParallels[0];
                d2 = parameters.standardParallels[1];
                break;
            }
            case 1: {
                d2 = d3 = parameters.standardParallels[0];
                break;
            }
            case 0: {
                d2 = d3 = parameters.latitudeOfOrigin;
            }
        }
        UnitaryProjection.Parameters.ensureLatitudeInRange(org.geotoolkit.referencing.operation.provider.AlbersEqualArea.STANDARD_PARALLEL_1, d3, true);
        UnitaryProjection.Parameters.ensureLatitudeInRange(org.geotoolkit.referencing.operation.provider.AlbersEqualArea.STANDARD_PARALLEL_2, d2, true);
        if (Math.abs(d3 + d2) < 5.729577951308232E-5) {
            throw new IllegalArgumentException(Errors.format(2, new Latitude(d3), new Latitude(d2)));
        }
        d3 = Math.toRadians(d3);
        d2 = Math.toRadians(d2);
        d4 = Math.toRadians(d4);
        if (Math.abs(d3 + d2) < 1.0E-6) {
            throw new IllegalArgumentException(Errors.format(2, new Latitude(Math.toDegrees(d3)), new Latitude(Math.toDegrees(d2))));
        }
        double d5 = Math.sin(d3);
        double d6 = Math.cos(d3);
        double d7 = d5;
        boolean bl2 = bl = Math.abs(d3 - d2) >= 1.0E-6;
        if (parameters.isSpherical()) {
            if (bl) {
                d7 = 0.5 * (d7 + Math.sin(d2));
            }
            this.c = d6 * d6 + d7 * 2.0 * d5;
            d = Math.sqrt(this.c - d7 * 2.0 * Math.sin(d4)) / d7;
            this.ec = Double.NaN;
        } else {
            double d8 = this.msfn(d5, d6);
            double d9 = this.qsfn(d5);
            if (bl) {
                d5 = Math.sin(d2);
                d6 = Math.cos(d2);
                double d10 = this.msfn(d5, d6);
                double d11 = this.qsfn(d5);
                d7 = (d8 * d8 - d10 * d10) / (d11 - d9);
            }
            this.c = d8 * d8 + d7 * d9;
            d = Math.sqrt(this.c - d7 * this.qsfn(Math.sin(d4))) / d7;
            this.ec = 1.0 - 0.5 * (1.0 - this.excentricitySquared) * Math.log((1.0 - this.excentricity) / (1.0 + this.excentricity)) / this.excentricity;
        }
        this.n = d7;
        AffineTransform affineTransform = parameters.normalize(true);
        AffineTransform affineTransform2 = parameters.normalize(false);
        affineTransform.scale(d7, 1.0);
        parameters.validate();
        affineTransform2.translate(0.0, d);
        affineTransform2.scale(1.0 / d7, -1.0 / d7);
        this.finish();
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return org.geotoolkit.referencing.operation.provider.AlbersEqualArea.PARAMETERS;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        double[] dArray = this.parameters.standardParallels;
        int n = dArray.length;
        double d = this.parameters.latitudeOfOrigin;
        double d2 = n != 0 ? dArray[0] : d;
        double d3 = n >= 2 ? dArray[1] : d2;
        ParameterValueGroup parameterValueGroup = super.getParameterValues();
        AlbersEqualArea.setValue(Identifiers.LATITUDE_OF_ORIGIN, parameterValueGroup, this.parameters.latitudeOfOrigin);
        AlbersEqualArea.setValue(Identifiers.STANDARD_PARALLEL_1, parameterValueGroup, d2);
        AlbersEqualArea.setValue(Identifiers.STANDARD_PARALLEL_2, parameterValueGroup, d3);
        return parameterValueGroup;
    }

    @Override
    protected void transform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d = this.rollLongitude(dArray[n]);
        double d2 = dArray[n + 1];
        double d3 = this.c - this.n * this.qsfn(Math.sin(d2));
        if (d3 < 0.0) {
            if (d3 > -1.0E-7) {
                d3 = 0.0;
            } else {
                throw new ProjectionException(176);
            }
        }
        d3 = Math.sqrt(d3);
        dArray2[n2] = d3 * Math.sin(d);
        dArray2[n2 + 1] = d3 * Math.cos(d);
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d = dArray[n];
        double d2 = dArray[n + 1];
        double d3 = Math.hypot(d, d2);
        d = Math.atan2(d, d2);
        d2 = d3 <= 1.0E-7 ? Math.copySign(1.5707963267948966, this.n) : (Math.abs(this.ec - Math.abs(d2 = (this.c - d3 * d3) / this.n)) <= 1.0E-7 ? Math.copySign(1.5707963267948966, d2) : this.phi1(d2));
        dArray2[n2] = this.unrollLongitude(d);
        dArray2[n2 + 1] = d2;
    }

    final double phi1(double d) throws ProjectionException {
        double d2 = 1.0 - this.excentricitySquared;
        double d3 = Math.asin(0.5 * d);
        if (this.excentricity < 1.0E-7) {
            return d3;
        }
        for (int i = 0; i < 15; ++i) {
            double d4 = Math.sin(d3);
            double d5 = Math.cos(d3);
            double d6 = this.excentricity * d4;
            double d7 = 1.0 - d6 * d6;
            double d8 = 0.5 * d7 * d7 / d5 * (d / d2 - d4 / d7 + 0.5 / this.excentricity * Math.log((1.0 - d6) / (1.0 + d6)));
            d3 += d8;
            if (!(Math.abs(d8) <= 1.0E-10)) continue;
            return d3;
        }
        throw new ProjectionException(138);
    }

    @Override
    public boolean equivalent(MathTransform mathTransform, boolean bl) {
        if (super.equivalent(mathTransform, bl)) {
            AlbersEqualArea albersEqualArea = (AlbersEqualArea)mathTransform;
            return AlbersEqualArea.equals(this.n, albersEqualArea.n, bl) && AlbersEqualArea.equals(this.c, albersEqualArea.c, bl);
        }
        return false;
    }

    @Override
    double getErrorEstimate(double d, double d2) {
        return 0.0;
    }

    static final class Spherical
    extends AlbersEqualArea {
        private static final long serialVersionUID = 9090765015127854096L;

        protected Spherical(UnitaryProjection.Parameters parameters) {
            super(parameters);
            parameters.ensureSpherical();
        }

        @Override
        final boolean isSpherical() {
            return true;
        }

        @Override
        protected void transform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
            double d = this.rollLongitude(dArray[n]);
            double d2 = dArray[n + 1];
            double d3 = this.c - this.n * 2.0 * Math.sin(d2);
            if (d3 < 0.0) {
                if (d3 > -1.0E-7) {
                    d3 = 0.0;
                } else {
                    throw new ProjectionException(176);
                }
            }
            d3 = Math.sqrt(d3);
            d2 = d3 * Math.cos(d);
            d = d3 * Math.sin(d);
            assert (this.checkTransform(dArray, n, dArray2, n2, d, d2));
            dArray2[n2] = d;
            dArray2[n2 + 1] = d2;
        }

        private boolean checkTransform(double[] dArray, int n, double[] dArray2, int n2, double d, double d2) throws ProjectionException {
            super.transform(dArray, n, dArray2, n2);
            return Assertions.checkTransform(dArray2, n2, d, d2);
        }

        @Override
        protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
            double d = dArray[n];
            double d2 = dArray[n + 1];
            double d3 = Math.hypot(d, d2);
            d = this.unrollLongitude(Math.atan2(d, d2));
            d2 = d3 <= 1.0E-7 ? Math.copySign(1.5707963267948966, this.n) : (Math.abs(d2 = (this.c - d3 * d3) / (this.n * 2.0)) >= 1.0 ? Math.copySign(1.5707963267948966, d2) : Math.asin(d2));
            assert (this.checkInverseTransform(dArray, n, dArray2, n2, d, d2));
            dArray2[n2] = d;
            dArray2[n2 + 1] = d2;
        }

        private boolean checkInverseTransform(double[] dArray, int n, double[] dArray2, int n2, double d, double d2) throws ProjectionException {
            super.inverseTransform(dArray, n, dArray2, n2);
            return Assertions.checkInverseTransform(dArray2, n2, d, d2);
        }
    }
}

