/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.projection;

import org.geotoolkit.referencing.operation.projection.Assertions;
import org.geotoolkit.referencing.operation.projection.CassiniOrMercator;
import org.geotoolkit.referencing.operation.projection.ProjectionException;
import org.geotoolkit.referencing.operation.projection.UnitaryProjection;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform2D;

public class CassiniSoldner
extends CassiniOrMercator {
    private static final long serialVersionUID = 4710150547701615178L;
    private static final double C1 = 0.16666666666666666;
    private static final double C2 = 0.08333333333333333;
    private static final double C3 = 0.4166666666666667;
    private static final double C4 = 0.3333333333333333;
    private static final double C5 = 0.6666666666666666;

    public static MathTransform2D create(ParameterDescriptorGroup parameterDescriptorGroup, ParameterValueGroup parameterValueGroup) {
        UnitaryProjection.Parameters parameters = new UnitaryProjection.Parameters(parameterDescriptorGroup, parameterValueGroup);
        CassiniSoldner cassiniSoldner = parameters.isSpherical() ? new Spherical(parameters) : new CassiniSoldner(parameters);
        return cassiniSoldner.createConcatenatedTransform();
    }

    protected CassiniSoldner(UnitaryProjection.Parameters parameters) {
        super(parameters);
    }

    @Override
    protected void transform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d = this.rollLongitude(dArray[n]);
        double d2 = dArray[n + 1];
        double d3 = Math.sin(d2);
        double d4 = Math.cos(d2);
        double d5 = 1.0 / Math.sqrt(1.0 - this.excentricitySquared * d3 * d3);
        double d6 = Math.tan(d2);
        double d7 = d6 * d6;
        double d8 = d * d4;
        double d9 = d4 * d4 * this.excentricitySquared / (1.0 - this.excentricitySquared);
        double d10 = d8 * d8;
        dArray2[n2] = d5 * d8 * (1.0 - d10 * d7 * (0.16666666666666666 - (8.0 - d7 + 8.0 * d9) * d10 * 0.08333333333333333));
        dArray2[n2 + 1] = this.mlfn(d2, d3, d4) + d5 * d6 * d10 * (0.5 + (5.0 - d7 + 6.0 * d9) * d10 * 0.4166666666666667);
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d = dArray[n];
        double d2 = dArray[n + 1];
        double d3 = this.inv_mlfn(d2);
        double d4 = Math.tan(d3);
        double d5 = d4 * d4;
        double d6 = Math.sin(d3);
        double d7 = 1.0 / (1.0 - this.excentricitySquared * d6 * d6);
        d6 = Math.sqrt(d7);
        double d8 = d / d6;
        double d9 = d8 * d8;
        dArray2[n2] = this.unrollLongitude(d8 * (1.0 + d5 * d9 * (-0.3333333333333333 + (1.0 + 3.0 * d5) * d9 * 0.6666666666666666)) / Math.cos(d3));
        dArray2[n2 + 1] = d3 - d6 * d4 / (d7 *= (1.0 - this.excentricitySquared) * d6) * d9 * (0.5 - (1.0 + 3.0 * d5) * d9 * 0.4166666666666667);
    }

    static final class Spherical
    extends CassiniSoldner {
        private static final long serialVersionUID = 8808830539248891527L;

        protected Spherical(UnitaryProjection.Parameters parameters) {
            super(parameters);
            parameters.ensureSpherical();
        }

        @Override
        final boolean isSpherical() {
            return true;
        }

        @Override
        protected void transform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
            double d = this.rollLongitude(dArray[n]);
            double d2 = dArray[n + 1];
            double d3 = Math.asin(Math.cos(d2) * Math.sin(d));
            double d4 = Math.atan2(Math.tan(d2), Math.cos(d));
            assert (this.checkTransform(dArray, n, dArray2, n2, d3, d4));
            dArray2[n2] = d3;
            dArray2[n2 + 1] = d4;
        }

        private boolean checkTransform(double[] dArray, int n, double[] dArray2, int n2, double d, double d2) throws ProjectionException {
            double d3 = dArray[n];
            if (Math.abs(d3) < 0.08726646259971647) {
                super.transform(dArray, n, dArray2, n2);
                return Assertions.checkTransform(dArray2, n2, d, d2, 1.0E-4);
            }
            return true;
        }

        @Override
        protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
            double d = dArray[n];
            double d2 = dArray[n + 1];
            double d3 = Math.asin(Math.sin(d2) * Math.cos(d));
            double d4 = this.unrollLongitude(Math.atan2(Math.tan(d), Math.cos(d2)));
            assert (this.checkInverseTransform(dArray, n, dArray2, n2, d, d2));
            dArray2[n2] = d4;
            dArray2[n2 + 1] = d3;
        }

        private boolean checkInverseTransform(double[] dArray, int n, double[] dArray2, int n2, double d, double d2) throws ProjectionException {
            if (Math.abs(d) < 0.08726646259971647 && Math.abs(d2) < 1.4835298641951802) {
                super.inverseTransform(dArray, n, dArray2, n2);
                return Assertions.checkInverseTransform(dArray2, n2, d, d2, 0.1);
            }
            return true;
        }
    }
}

