/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.projection;

import org.geotoolkit.referencing.operation.projection.Assertions;
import org.geotoolkit.referencing.operation.projection.ProjectionException;
import org.geotoolkit.referencing.operation.projection.Stereographic;
import org.geotoolkit.referencing.operation.projection.UnitaryProjection;

public class EquatorialStereographic
extends Stereographic {
    private static final long serialVersionUID = -5098015759558831875L;

    protected EquatorialStereographic(UnitaryProjection.Parameters parameters) {
        super(parameters);
        assert (this.phi0 == 0.0) : this.phi0;
    }

    @Override
    protected void transform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d = this.rollLongitude(dArray[n]);
        double d2 = dArray[n + 1];
        double d3 = 2.0 * Math.atan(this.ssfn(d2, Math.sin(d2))) - 1.5707963267948966;
        double d4 = Math.cos(d3);
        double d5 = 1.0 + d4 * Math.cos(d);
        d = d4 * Math.sin(d) / d5;
        d2 = Math.sin(d3) / d5;
        assert (this.checkTransform(dArray, n, dArray2, n2, d, d2));
        dArray2[n2] = d;
        dArray2[n2 + 1] = d2;
    }

    private boolean checkTransform(double[] dArray, int n, double[] dArray2, int n2, double d, double d2) throws ProjectionException {
        super.transform(dArray, n, dArray2, n2);
        return Assertions.checkTransform(dArray2, n2, d, d2);
    }

    static final class Spherical
    extends EquatorialStereographic {
        private static final long serialVersionUID = -4790138052004333003L;

        protected Spherical(UnitaryProjection.Parameters parameters) {
            super(parameters);
            parameters.ensureSpherical();
        }

        @Override
        final boolean isSpherical() {
            return true;
        }

        @Override
        protected void transform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
            double d = this.rollLongitude(dArray[n]);
            double d2 = dArray[n + 1];
            double d3 = Math.cos(d2);
            double d4 = 1.0 + d3 * Math.cos(d);
            d = d3 * Math.sin(d) / d4;
            d2 = Math.sin(d2) / d4;
            assert (this.checkTransform(dArray, n, dArray2, n2, d, d2));
            dArray2[n2] = d;
            dArray2[n2 + 1] = d2;
        }

        @Override
        private boolean checkTransform(double[] dArray, int n, double[] dArray2, int n2, double d, double d2) throws ProjectionException {
            super.transform(dArray, n, dArray2, n2);
            return Assertions.checkTransform(dArray2, n2, d, d2);
        }

        @Override
        protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
            double d;
            double d2 = this.unrollLongitude(dArray[n]);
            double d3 = Math.hypot(d2, d = dArray[n + 1]);
            if (d3 < 1.0E-6) {
                d = 0.0;
                d2 = 0.0;
            } else {
                double d4 = 2.0 * Math.atan(d3);
                double d5 = Math.sin(d4);
                double d6 = d3 * Math.cos(d4);
                double d7 = d2 * d5;
                d = Math.asin(d * d5 / d3);
                d2 = Math.atan2(d7, d6);
            }
            assert (this.checkInverseTransform(dArray, n, dArray2, n2, d2, d));
            dArray2[n2] = d2;
            dArray2[n2 + 1] = d;
        }

        private boolean checkInverseTransform(double[] dArray, int n, double[] dArray2, int n2, double d, double d2) throws ProjectionException {
            super.inverseTransform(dArray, n, dArray2, n2);
            return Assertions.checkInverseTransform(dArray2, n2, d, d2);
        }
    }
}

