/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.projection;

import java.awt.geom.AffineTransform;
import org.geotoolkit.referencing.operation.projection.Assertions;
import org.geotoolkit.referencing.operation.projection.ProjectionException;
import org.geotoolkit.referencing.operation.projection.UnitaryProjection;
import org.geotoolkit.referencing.operation.provider.LambertAzimuthalEqualArea;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;

public class LambertAzimuthalEqualArea
extends UnitaryProjection {
    private static final long serialVersionUID = 1639914708790574760L;
    private static final double EPSILON = 1.0E-10;
    private static final double P00 = 0.3333333333333333;
    private static final double P01 = 0.17222222222222222;
    private static final double P02 = 0.10257936507936508;
    private static final double P10 = 0.06388888888888888;
    private static final double P11 = 0.0664021164021164;
    private static final double P20 = 0.016415012942191543;
    final boolean pole;
    final boolean north;
    final boolean oblique;
    final double latitudeOfOrigin;
    final double sinb1;
    final double cosb1;
    final double qp;
    final double rq;
    private final double APA0;
    private final double APA1;
    private final double APA2;

    public static MathTransform2D create(ParameterDescriptorGroup parameterDescriptorGroup, ParameterValueGroup parameterValueGroup) {
        UnitaryProjection.Parameters parameters = new UnitaryProjection.Parameters(parameterDescriptorGroup, parameterValueGroup);
        if (parameters.nameMatches(LambertAzimuthalEqualArea.Spherical.PARAMETERS)) {
            parameters.ensureSpherical();
        }
        LambertAzimuthalEqualArea lambertAzimuthalEqualArea = parameters.isSpherical() ? new Spherical(parameters) : new LambertAzimuthalEqualArea(parameters);
        return lambertAzimuthalEqualArea.createConcatenatedTransform();
    }

    protected LambertAzimuthalEqualArea(UnitaryProjection.Parameters parameters) {
        super(parameters);
        this.latitudeOfOrigin = Math.toRadians(parameters.latitudeOfOrigin);
        double d = Math.abs(this.latitudeOfOrigin);
        if (Math.abs(d - 1.5707963267948966) < 1.0E-10) {
            this.pole = true;
            this.north = this.latitudeOfOrigin >= 0.0;
            this.oblique = false;
        } else {
            this.pole = false;
            this.north = false;
            this.oblique = Math.abs(d) >= 1.0E-10;
        }
        double d2 = this.excentricitySquared * this.excentricitySquared;
        double d3 = this.excentricitySquared * d2;
        this.APA0 = 0.10257936507936508 * d3 + 0.17222222222222222 * d2 + 0.3333333333333333 * this.excentricitySquared;
        this.APA1 = 0.0664021164021164 * d3 + 0.06388888888888888 * d2;
        this.APA2 = 0.016415012942191543 * d3;
        this.qp = this.qsfn(1.0);
        this.rq = Math.sqrt(0.5 * this.qp);
        double d4 = Math.sin(this.latitudeOfOrigin);
        boolean bl = this.isSpherical();
        if (bl) {
            this.sinb1 = d4;
            this.cosb1 = Math.cos(this.latitudeOfOrigin);
        } else {
            this.sinb1 = this.qsfn(d4) / this.qp;
            this.cosb1 = Math.sqrt(1.0 - this.sinb1 * this.sinb1);
        }
        AffineTransform affineTransform = parameters.normalize(true);
        AffineTransform affineTransform2 = parameters.normalize(false);
        parameters.validate();
        if (this.north) {
            affineTransform.scale(1.0, -1.0);
            affineTransform2.scale(1.0, -1.0);
        } else if (!bl && this.oblique) {
            double d5 = Math.cos(this.latitudeOfOrigin) / (Math.sqrt(1.0 - this.excentricitySquared * (d4 * d4)) * this.rq * this.cosb1);
            affineTransform2.scale(d5, 1.0 / d5);
        }
        this.finish();
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return org.geotoolkit.referencing.operation.provider.LambertAzimuthalEqualArea.PARAMETERS;
    }

    @Override
    protected void transform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d;
        double d2;
        double d3;
        double d4 = this.rollLongitude(dArray[n]);
        double d5 = dArray[n + 1];
        double d6 = Math.cos(d4);
        double d7 = Math.sin(d4);
        double d8 = Math.sin(d5);
        double d9 = this.qsfn(d8);
        if (!this.pole) {
            double d10 = d9 / this.qp;
            double d11 = Math.sqrt(1.0 - d10 * d10);
            if (this.oblique) {
                d3 = 1.0 + d10 * this.sinb1 + d11 * d6 * this.cosb1;
                d2 = this.rq * (d10 * this.cosb1 - d11 * d6 * this.sinb1);
                d = this.rq * d11 * d7;
            } else {
                d3 = 1.0 + d11 * d6;
                d2 = d10 * (0.5 * this.qp);
                d = d11 * d7;
            }
            double d12 = Math.sqrt(2.0 / d3);
            d *= d12;
            d2 *= d12;
        } else {
            d3 = d5 - 1.5707963267948966;
            double d13 = Math.sqrt(this.qp + d9);
            d = d13 * d7;
            d2 = d13 * d6;
        }
        if (Math.abs(d3) < 1.0E-10) {
            d2 = Double.NaN;
            d = Double.NaN;
        }
        dArray2[n2] = d;
        dArray2[n2 + 1] = d2;
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d;
        double d2;
        double d3 = dArray[n];
        double d4 = dArray[n + 1];
        if (this.pole) {
            d2 = (d3 * d3 + d4 * d4) / this.qp - 1.0;
        } else {
            if (!this.oblique) {
                d3 *= this.rq;
                d4 /= this.rq;
            }
            if ((d = Math.hypot(d3, d4)) < 1.0E-10) {
                dArray2[n2] = 0.0;
                dArray2[n2 + 1] = this.latitudeOfOrigin;
                return;
            }
            double d5 = 2.0 * Math.asin(0.5 * d / this.rq);
            double d6 = Math.cos(d5);
            d5 = Math.sin(d5);
            d3 *= d5;
            if (this.oblique) {
                d2 = d6 * this.sinb1 + d4 * d5 * this.cosb1 / d;
                d4 = d * this.cosb1 * d6 - d4 * this.sinb1 * d5;
            } else {
                d2 = d4 * d5 / d;
                d4 = d * d6;
            }
        }
        d = Math.abs(d2);
        d = d > 1.0 && d <= 1.000001 ? Math.copySign(1.5707963267948966, d2) : Math.asin(d2);
        double d7 = d;
        double d8 = d + d;
        d = d8;
        d += d;
        dArray2[n2 + 1] = d7 + this.APA0 * Math.sin(d8) + this.APA1 * Math.sin(d) + this.APA2 * Math.sin(d + d);
        dArray2[n2] = this.unrollLongitude(Math.atan2(d3, d4));
    }

    @Override
    public boolean equivalent(MathTransform mathTransform, boolean bl) {
        if (super.equivalent(mathTransform, bl)) {
            LambertAzimuthalEqualArea lambertAzimuthalEqualArea = (LambertAzimuthalEqualArea)mathTransform;
            return LambertAzimuthalEqualArea.equals(this.latitudeOfOrigin, lambertAzimuthalEqualArea.latitudeOfOrigin, bl);
        }
        return false;
    }

    @Override
    double getErrorEstimate(double d, double d2) {
        return 1.0E-8;
    }

    static final class Spherical
    extends LambertAzimuthalEqualArea {
        private static final long serialVersionUID = 2091431369806844342L;

        protected Spherical(UnitaryProjection.Parameters parameters) {
            super(parameters);
            parameters.ensureSpherical();
        }

        @Override
        final boolean isSpherical() {
            return true;
        }

        @Override
        protected void transform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
            double d;
            double d2;
            double d3 = this.rollLongitude(dArray[n]);
            double d4 = dArray[n + 1];
            double d5 = Math.cos(d3);
            if (!this.pole) {
                double d6 = Math.sin(d4);
                double d7 = Math.cos(d4);
                if (!this.oblique) {
                    d2 = 1.0 + d7 * d5;
                    if (d2 >= 1.0E-10) {
                        d2 = Math.sqrt(2.0 / d2);
                        d = d2 * d6;
                    } else {
                        d = Double.NaN;
                        d2 = Double.NaN;
                    }
                } else {
                    d = d7 * d5;
                    d2 = 1.0 + this.sinb1 * d6 + this.cosb1 * d;
                    if (d2 >= 1.0E-10) {
                        d2 = Math.sqrt(2.0 / d2);
                        d = d2 * (this.cosb1 * d6 - this.sinb1 * d);
                    } else {
                        d = Double.NaN;
                        d2 = Double.NaN;
                    }
                }
                d2 *= d7 * Math.sin(d3);
            } else if (Math.abs(d4 - 1.5707963267948966) >= 1.0E-10) {
                d = 2.0 * Math.cos(0.7853981633974483 - 0.5 * d4);
                d2 = d * Math.sin(d3);
                d *= d5;
            } else {
                d = Double.NaN;
                d2 = Double.NaN;
            }
            assert (this.checkTransform(dArray, n, dArray2, n2, d2, d));
            dArray2[n2] = d2;
            dArray2[n2 + 1] = d;
        }

        private boolean checkTransform(double[] dArray, int n, double[] dArray2, int n2, double d, double d2) throws ProjectionException {
            super.transform(dArray, n, dArray2, n2);
            return Assertions.checkTransform(dArray2, n2, d, d2);
        }

        @Override
        protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
            double d;
            double d2 = dArray[n];
            double d3 = dArray[n + 1];
            double d4 = Math.hypot(d2, d3);
            double d5 = 2.0 * Math.asin(0.5 * d4);
            if (this.pole) {
                d5 -= 1.5707963267948966;
                d = Math.atan2(d2, d3);
            } else {
                double d6 = Math.sin(d5);
                double d7 = Math.cos(d5);
                if (!this.oblique) {
                    d5 = Math.abs(d4) <= 1.0E-10 ? 0.0 : Math.asin(d3 * d6 / d4);
                    d3 = d4 * d7;
                } else {
                    d5 = Math.abs(d4) <= 1.0E-10 ? this.latitudeOfOrigin : Math.asin(d7 * this.sinb1 + (d3 *= d6) * this.cosb1 / d4);
                    d3 = d4 * d7 * this.cosb1 - d3 * this.sinb1;
                }
                d = Math.atan2(d2 *= d6, d3);
            }
            d = this.unrollLongitude(d);
            assert (this.checkInverseTransform(dArray, n, dArray2, n2, d, d5));
            dArray2[n2] = d;
            dArray2[n2 + 1] = d5;
        }

        private boolean checkInverseTransform(double[] dArray, int n, double[] dArray2, int n2, double d, double d2) throws ProjectionException {
            super.inverseTransform(dArray, n, dArray2, n2);
            return Assertions.checkInverseTransform(dArray2, n2, d, d2);
        }
    }
}

