/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.projection;

import java.awt.geom.AffineTransform;
import org.geotoolkit.internal.referencing.Identifiers;
import org.geotoolkit.measure.Latitude;
import org.geotoolkit.referencing.operation.projection.Assertions;
import org.geotoolkit.referencing.operation.projection.ProjectionException;
import org.geotoolkit.referencing.operation.projection.UnitaryProjection;
import org.geotoolkit.referencing.operation.provider.LambertConformal1SP;
import org.geotoolkit.referencing.operation.provider.LambertConformal2SP;
import org.geotoolkit.resources.Errors;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;

public class LambertConformal
extends UnitaryProjection {
    private static final long serialVersionUID = 2067358524298002016L;
    private static final double BELGE_A = 1.42043136359877E-4;
    final double n;

    public static MathTransform2D create(ParameterDescriptorGroup parameterDescriptorGroup, ParameterValueGroup parameterValueGroup) {
        UnitaryProjection.Parameters parameters = new UnitaryProjection.Parameters(parameterDescriptorGroup, parameterValueGroup);
        LambertConformal lambertConformal = parameters.isSpherical() ? new Spherical(parameters) : new LambertConformal(parameters);
        return lambertConformal.createConcatenatedTransform();
    }

    protected LambertConformal(UnitaryProjection.Parameters parameters) {
        super(parameters);
        double d;
        double d2;
        double d3;
        double d4;
        double d5 = parameters.latitudeOfOrigin;
        boolean bl = parameters.nameMatches(LambertConformal2SP.Belgium.PARAMETERS);
        if (parameters.nameMatches(LambertConformal1SP.PARAMETERS)) {
            d3 = d4 = d5;
            UnitaryProjection.Parameters.ensureLatitudeInRange(LambertConformal1SP.LATITUDE_OF_ORIGIN, d3, true);
        } else {
            switch (parameters.standardParallels.length) {
                default: {
                    throw LambertConformal.unknownParameter("standard_parallel_3");
                }
                case 2: {
                    d3 = parameters.standardParallels[0];
                    d4 = parameters.standardParallels[1];
                    break;
                }
                case 1: {
                    d4 = d3 = parameters.standardParallels[0];
                    break;
                }
                case 0: {
                    d4 = d3 = d5;
                }
            }
            UnitaryProjection.Parameters.ensureLatitudeInRange(LambertConformal2SP.STANDARD_PARALLEL_1, d3, true);
            UnitaryProjection.Parameters.ensureLatitudeInRange(LambertConformal2SP.STANDARD_PARALLEL_2, d4, true);
        }
        if (Math.abs(d3 + d4) < 5.729577951308232E-5) {
            throw new IllegalArgumentException(Errors.format(2, new Latitude(d3), new Latitude(d4)));
        }
        d3 = Math.toRadians(d3);
        d4 = Math.toRadians(d4);
        d5 = Math.toRadians(d5);
        double d6 = Math.cos(d3);
        double d7 = Math.sin(d3);
        boolean bl2 = Math.abs(d3 - d4) > 1.0E-6;
        boolean bl3 = parameters.isSpherical();
        if (bl3) {
            this.n = bl2 ? Math.log(d6 / Math.cos(d4)) / Math.log(Math.tan(0.7853981633974483 + 0.5 * d4) / Math.tan(0.7853981633974483 + 0.5 * d3)) : d7;
            d2 = d6 * Math.pow(Math.tan(0.7853981633974483 + 0.5 * d3), this.n) / this.n;
            d = Math.abs(Math.abs(d5) - 1.5707963267948966) >= 1.0E-6 ? d2 * Math.pow(Math.tan(0.7853981633974483 + 0.5 * d5), -this.n) : 0.0;
        } else {
            double d8 = this.msfn(d7, d6);
            double d9 = this.tsfn(d3, d7);
            if (bl2) {
                double d10 = Math.sin(d4);
                double d11 = this.msfn(d10, Math.cos(d4));
                double d12 = this.tsfn(d4, d10);
                this.n = Math.log(d8 / d11) / Math.log(d9 / d12);
            } else {
                this.n = d7;
            }
            d2 = d8 * Math.pow(d9, -this.n) / this.n;
            d = Math.abs(Math.abs(d5) - 1.5707963267948966) >= 1.0E-6 ? d2 * Math.pow(this.tsfn(d5, Math.sin(d5)), this.n) : 0.0;
        }
        AffineTransform affineTransform = parameters.normalize(true);
        AffineTransform affineTransform2 = parameters.normalize(false);
        if (bl) {
            affineTransform.translate(-1.42043136359877E-4, 0.0);
        }
        affineTransform.scale(this.n, 1.0);
        parameters.validate();
        affineTransform2.translate(0.0, d);
        affineTransform2.scale(d2, -d2);
        this.finish();
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return LambertConformal2SP.PARAMETERS;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        double[] dArray = this.parameters.standardParallels;
        int n = dArray.length;
        double d = this.parameters.latitudeOfOrigin;
        double d2 = n != 0 ? dArray[0] : d;
        double d3 = n >= 2 ? dArray[1] : d2;
        ParameterValueGroup parameterValueGroup = super.getParameterValues();
        LambertConformal.setValue(Identifiers.STANDARD_PARALLEL_1, parameterValueGroup, d2);
        LambertConformal.setValue(Identifiers.STANDARD_PARALLEL_2, parameterValueGroup, d3);
        return parameterValueGroup;
    }

    @Override
    protected void transform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d = dArray[n + 1];
        double d2 = Math.abs(d);
        double d3 = d2 < 1.5707963267948966 ? Math.pow(this.tsfn(d, Math.sin(d)), this.n) : (d2 < 1.5707973267948965 ? (d * this.n <= 0.0 ? Double.POSITIVE_INFINITY : 0.0) : Double.NaN);
        double d4 = this.rollLongitude(dArray[n]);
        dArray2[n2] = d3 * Math.sin(d4);
        dArray2[n2 + 1] = d3 * Math.cos(d4);
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d = dArray[n];
        double d2 = dArray[n + 1];
        double d3 = Math.hypot(d, d2);
        dArray2[n2] = this.unrollLongitude(Math.atan2(d, d2));
        dArray2[n2 + 1] = this.cphi2(Math.pow(d3, 1.0 / this.n));
    }

    @Override
    public boolean equivalent(MathTransform mathTransform, boolean bl) {
        if (super.equivalent(mathTransform, bl)) {
            LambertConformal lambertConformal = (LambertConformal)mathTransform;
            return LambertConformal.equals(this.n, lambertConformal.n, bl);
        }
        return false;
    }

    @Override
    double getErrorEstimate(double d, double d2) {
        return 0.0;
    }

    static final class Spherical
    extends LambertConformal {
        private static final long serialVersionUID = -7005092237343502956L;

        protected Spherical(UnitaryProjection.Parameters parameters) {
            super(parameters);
            parameters.ensureSpherical();
        }

        @Override
        final boolean isSpherical() {
            return true;
        }

        @Override
        protected void transform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
            double d = dArray[n + 1];
            double d2 = Math.abs(d);
            double d3 = d2 < 1.5707963267948966 ? Math.pow(Math.tan(0.7853981633974483 + 0.5 * d), -this.n) : (d2 < 1.5707973267948965 ? (d * this.n <= 0.0 ? Double.POSITIVE_INFINITY : 0.0) : Double.NaN);
            double d4 = this.rollLongitude(dArray[n]);
            d = d3 * Math.cos(d4);
            d4 = d3 * Math.sin(d4);
            assert (this.checkTransform(dArray, n, dArray2, n2, d4, d));
            dArray2[n2] = d4;
            dArray2[n2 + 1] = d;
        }

        private boolean checkTransform(double[] dArray, int n, double[] dArray2, int n2, double d, double d2) throws ProjectionException {
            super.transform(dArray, n, dArray2, n2);
            return Assertions.checkTransform(dArray2, n2, d, d2);
        }

        @Override
        protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
            double d = dArray[n];
            double d2 = dArray[n + 1];
            double d3 = Math.hypot(d, d2);
            d = this.unrollLongitude(Math.atan2(d, d2));
            d2 = 2.0 * Math.atan(Math.pow(1.0 / d3, 1.0 / this.n)) - 1.5707963267948966;
            assert (this.checkInverseTransform(dArray, n, dArray2, n2, d, d2));
            dArray2[n2] = d;
            dArray2[n2 + 1] = d2;
        }

        private boolean checkInverseTransform(double[] dArray, int n, double[] dArray2, int n2, double d, double d2) throws ProjectionException {
            super.inverseTransform(dArray, n, dArray2, n2);
            return Assertions.checkInverseTransform(dArray2, n2, d, d2);
        }
    }
}

