/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.projection;

import java.awt.geom.AffineTransform;
import org.geotoolkit.referencing.operation.projection.ProjectionException;
import org.geotoolkit.referencing.operation.projection.UnitaryProjection;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;

public class Orthographic
extends UnitaryProjection {
    private static final long serialVersionUID = 5036668705538661686L;
    private static final double EPSILON = 1.0E-6;
    private final byte type;
    private final double latitudeOfOrigin;
    private final double sinphi0;
    private final double cosphi0;

    public static MathTransform2D create(ParameterDescriptorGroup parameterDescriptorGroup, ParameterValueGroup parameterValueGroup) {
        UnitaryProjection.Parameters parameters = new UnitaryProjection.Parameters(parameterDescriptorGroup, parameterValueGroup);
        Orthographic orthographic = new Orthographic(parameters);
        return orthographic.createConcatenatedTransform();
    }

    protected Orthographic(UnitaryProjection.Parameters parameters) {
        super(parameters);
        double d = Math.toRadians(parameters.latitudeOfOrigin);
        boolean bl = false;
        boolean bl2 = false;
        if (Math.abs(Math.abs(d) - 1.5707963267948966) <= 1.0E-6) {
            if (d >= 0.0) {
                bl = true;
            } else {
                bl2 = true;
            }
            d = 1.5707963267948966;
            this.type = 1;
        } else {
            this.type = d == 0.0 ? (byte)0 : (byte)2;
        }
        this.latitudeOfOrigin = d;
        this.sinphi0 = Math.sin(d);
        this.cosphi0 = Math.cos(d);
        if (bl2) {
            parameters.normalize(true).scale(1.0, -1.0);
        }
        parameters.validate();
        AffineTransform affineTransform = parameters.normalize(false);
        if (!parameters.isSpherical()) {
            double d2 = Math.sin(Math.abs(d));
            d2 = Math.sqrt(1.0 - this.excentricitySquared) / (1.0 - d2 * d2 * this.excentricitySquared);
            affineTransform.scale(d2, d2);
        }
        if (bl) {
            affineTransform.scale(1.0, -1.0);
        }
        this.finish();
    }

    @Override
    boolean isSpherical() {
        return true;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return org.geotoolkit.referencing.operation.provider.Orthographic.PARAMETERS;
    }

    @Override
    protected void transform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d;
        double d2;
        double d3 = this.rollLongitude(dArray[n]);
        double d4 = dArray[n + 1];
        double d5 = Math.cos(d4);
        double d6 = Math.cos(d3);
        switch (this.type) {
            default: {
                double d7 = Math.sin(d4);
                d2 = this.sinphi0 * d7 + this.cosphi0 * d5 * d6;
                d = this.cosphi0 * d7 - this.sinphi0 * d5 * d6;
                break;
            }
            case 0: {
                d2 = d5 * d6;
                d = Math.sin(d4);
                break;
            }
            case 1: {
                d2 = d4;
                d = d5 * d6;
            }
        }
        if (d2 < -1.0E-6) {
            throw new ProjectionException(166);
        }
        dArray2[n2] = d5 * Math.sin(d3);
        dArray2[n2 + 1] = d;
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d;
        double d2 = dArray[n];
        double d3 = dArray[n + 1];
        double d4 = Math.hypot(d2, d3);
        double d5 = d4;
        if (d5 > 1.0) {
            if (d5 - 1.0 > 1.0E-6) {
                throw new ProjectionException(166);
            }
            d5 = 1.0;
        }
        if (d4 <= 1.0E-6) {
            d = this.latitudeOfOrigin;
            d2 = 0.0;
        } else {
            if (this.type != 1) {
                double d6 = Math.sqrt(1.0 - d5 * d5);
                if (this.type != 0) {
                    d = d6 * this.sinphi0 + d3 * d5 * this.cosphi0 / d4;
                    d2 *= d5 * this.cosphi0;
                    d3 = (d6 - this.sinphi0 * d) * d4;
                } else {
                    d = d3 * d5 / d4;
                    d2 *= d5;
                    d3 = d6 * d4;
                }
                d = Math.abs(d) >= 1.0 ? Math.copySign(1.5707963267948966, d) : Math.asin(d);
            } else {
                d = Math.acos(d5);
            }
            d2 = Math.atan2(d2, d3);
        }
        dArray2[n2] = this.unrollLongitude(d2);
        dArray2[n2 + 1] = d;
    }

    @Override
    public boolean equivalent(MathTransform mathTransform, boolean bl) {
        if (super.equivalent(mathTransform, bl)) {
            Orthographic orthographic = (Orthographic)mathTransform;
            return Orthographic.equals(this.latitudeOfOrigin, orthographic.latitudeOfOrigin, bl);
        }
        return false;
    }
}

