/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.projection;

import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.geotoolkit.internal.referencing.Identifiers;
import org.geotoolkit.math.XMath;
import org.geotoolkit.measure.Latitude;
import org.geotoolkit.measure.Longitude;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.referencing.AbstractIdentifiedObject;
import org.geotoolkit.referencing.operation.projection.Assertions;
import org.geotoolkit.referencing.operation.projection.ProjectionException;
import org.geotoolkit.referencing.operation.provider.MapProjection;
import org.geotoolkit.referencing.operation.transform.AbstractMathTransform;
import org.geotoolkit.referencing.operation.transform.AbstractMathTransform2D;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Loggings;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.collection.WeakHashSet;
import org.geotoolkit.util.logging.Logging;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.GenericName;

public abstract class UnitaryProjection
extends AbstractMathTransform2D
implements Serializable {
    private static final long serialVersionUID = 1969740225939106310L;
    private static final double PARAMETER_TOLERANCE = 1.0E-14;
    static final double ANGLE_TOLERANCE = 1.0E-6;
    static final double ITERATION_TOLERANCE = 1.0E-10;
    static final int MAXIMUM_ITERATIONS = 15;
    private static final double EPSILON = 1.0E-7;
    private static final WeakHashSet<UnitaryProjection> POOL = WeakHashSet.newInstance(UnitaryProjection.class);
    final Parameters parameters;
    protected final double excentricity;
    protected final double excentricitySquared;
    private final MathTransform2D inverse;
    private double longitudeBound = Double.POSITIVE_INFINITY;
    private double longitudeRotation = 0.0;
    private transient int rangeCheckSemaphore;
    private static int globalRangeCheckSemaphore;

    protected UnitaryProjection(Parameters parameters) {
        this.parameters = parameters;
        UnitaryProjection.ensureNonNull("parameters", parameters);
        double d = parameters.semiMajor;
        double d2 = parameters.semiMinor;
        this.excentricitySquared = 1.0 - d2 * d2 / (d * d);
        this.excentricity = Math.sqrt(this.excentricitySquared);
        this.inverse = new Inverse();
    }

    protected final void finish() {
        double d = 0.0;
        double d2 = Double.POSITIVE_INFINITY;
        Boolean bl = this.parameters.rollLongitude;
        if (bl == null ? this.parameters.centralMeridian != 0.0 : bl != false) {
            AffineTransform affineTransform = this.parameters.normalize(true);
            if (affineTransform.getShearX() == 0.0 && affineTransform.getShearY() == 0.0) {
                d = -affineTransform.getTranslateX();
                d2 = Math.abs(affineTransform.getScaleX()) * 180.0;
                if (Math.abs(d2 - Math.PI) <= 1.0E-6) {
                    d2 = Math.PI;
                }
            } else {
                Class<?> clazz = this.getClass();
                LogRecord logRecord = Loggings.format(Level.WARNING, 13, clazz);
                logRecord.setSourceClassName(clazz.getCanonicalName());
                logRecord.setSourceMethodName("<init>");
                Logging.log(UnitaryProjection.class, logRecord);
            }
        }
        this.longitudeBound = d2;
        this.longitudeRotation = d;
    }

    final MathTransform2D createConcatenatedTransform() {
        return this.parameters.createConcatenatedTransform(POOL.unique(this));
    }

    static IllegalArgumentException unknownParameter(Object object) {
        String string = object instanceof IdentifiedObject ? ((IdentifiedObject)object).getName().getCode() : String.valueOf(object);
        return new IllegalArgumentException(Errors.format(195, string));
    }

    private static LogRecord verifyGeographicRanges(AbstractMathTransform abstractMathTransform, double d, double d2) {
        boolean bl;
        boolean bl2 = d < -3.1415936535897933 || d > 3.1415936535897933;
        boolean bl3 = bl = d2 < -1.5707973267948965 || d2 > 1.5707973267948965;
        if (!bl2 && !bl) {
            return null;
        }
        String string = System.getProperty("line.separator", "\n");
        StringBuilder stringBuilder = new StringBuilder(Errors.format(161, abstractMathTransform.getName()));
        if (bl2) {
            stringBuilder.append(string).append(Errors.format(95, new Longitude(Math.toDegrees(d))));
        }
        if (bl) {
            stringBuilder.append(string).append(Errors.format(92, new Latitude(Math.toDegrees(d2))));
        }
        String string2 = abstractMathTransform instanceof Inverse ? ((Inverse)abstractMathTransform).inverse().getClass().getCanonicalName() + ".Inverse" : abstractMathTransform.getClass().getCanonicalName();
        LogRecord logRecord = new LogRecord(Level.WARNING, stringBuilder.toString());
        logRecord.setSourceClassName(string2);
        logRecord.setSourceMethodName("transform");
        return logRecord;
    }

    final void verifyGeographicRanges(double[] dArray, int n, int n2) {
        while (--n2 >= 0 && !this.logWarning(UnitaryProjection.verifyGeographicRanges(this, dArray[n++], dArray[n++]))) {
        }
    }

    final boolean rollLongitude() {
        return this.longitudeBound != Double.POSITIVE_INFINITY;
    }

    protected final double rollLongitude(double d) {
        double d2 = this.longitudeBound;
        if (d2 != Double.POSITIVE_INFINITY) {
            d = UnitaryProjection.rollLongitude(d, d2);
        }
        return d;
    }

    protected final double unrollLongitude(double d) {
        double d2 = this.longitudeRotation;
        if (d2 != 0.0) {
            double d3 = this.longitudeBound;
            if (XMath.xorSign(d + d2, d2) > d3) {
                d -= 2.0 * Math.copySign(d3, d2);
            }
        }
        return d;
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
        if (this.verifyCoordinateRanges()) {
            this.verifyGeographicRanges(dArray, n, n3);
        }
        super.transform(dArray, n, dArray2, n2, n3);
        assert (Assertions.checkReciprocal(this, true, dArray, n, dArray2, n2, n3));
    }

    @Override
    protected abstract void transform(double[] var1, int var2, double[] var3, int var4) throws ProjectionException;

    protected abstract void inverseTransform(double[] var1, int var2, double[] var3, int var4) throws ProjectionException;

    @Override
    public MathTransform2D inverse() {
        return this.inverse;
    }

    double getErrorEstimate(double d, double d2) {
        return Double.NaN;
    }

    final boolean verifyCoordinateRanges() {
        return this.rangeCheckSemaphore != globalRangeCheckSemaphore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean logWarning(LogRecord logRecord) {
        if (logRecord == null) return false;
        Class<UnitaryProjection> clazz = UnitaryProjection.class;
        synchronized (UnitaryProjection.class) {
            if (this.rangeCheckSemaphore == globalRangeCheckSemaphore) return false;
            this.rangeCheckSemaphore = globalRangeCheckSemaphore;
            Logging.log(UnitaryProjection.class, logRecord);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return true;
        }
    }

    public static synchronized void resetWarnings() {
        ++globalRangeCheckSemaphore;
    }

    final double msfn(double d, double d2) {
        return d2 / Math.sqrt(1.0 - d * d * this.excentricitySquared);
    }

    final double ssfn(double d, double d2) {
        assert (!(Math.abs(d2 - Math.sin(d)) > 1.0E-15)) : d;
        return Math.tan(0.7853981633974483 + 0.5 * d) * Math.pow((1.0 - (d2 *= this.excentricity)) / (1.0 + d2), 0.5 * this.excentricity);
    }

    final double tsfn(double d, double d2) {
        assert (!(Math.abs(d2 - Math.sin(d)) > 1.0E-15)) : d;
        return Math.tan(0.5 * (1.5707963267948966 - d)) / Math.pow((1.0 - (d2 *= this.excentricity)) / (1.0 + d2), 0.5 * this.excentricity);
    }

    final double cphi2(double d) throws ProjectionException {
        double d2 = 0.5 * this.excentricity;
        double d3 = 1.5707963267948966 - 2.0 * Math.atan(d);
        for (int i = 0; i < 15; ++i) {
            double d4 = this.excentricity * Math.sin(d3);
            double d5 = d3;
            d3 = 1.5707963267948966 - 2.0 * Math.atan(d * Math.pow((1.0 - d4) / (1.0 + d4), d2));
            double d6 = Math.abs(d5 - d3);
            if (!(d6 <= 1.0E-10)) continue;
            return d3;
        }
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        throw new ProjectionException(138);
    }

    final double qsfn(double d) {
        if (this.excentricity < 1.0E-7) {
            return d + d;
        }
        double d2 = this.excentricity * d;
        return (1.0 - this.excentricitySquared) * (d / (1.0 - d2 * d2) - 0.5 / this.excentricity * Math.log((1.0 - d2) / (1.0 + d2)));
    }

    @Override
    protected final Parameters getUnmarshalledParameters() {
        return this.parameters;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        ParameterDescriptorGroup parameterDescriptorGroup = this.getParameterDescriptors();
        ParameterValueGroup parameterValueGroup = parameterDescriptorGroup.createValue();
        UnitaryProjection.setValue(MapProjection.SEMI_MAJOR, parameterValueGroup, 1.0);
        UnitaryProjection.setValue(MapProjection.SEMI_MINOR, parameterValueGroup, Math.sqrt(1.0 - this.excentricitySquared));
        return parameterValueGroup;
    }

    static void setValue(ParameterDescriptor<Double> parameterDescriptor, ParameterValueGroup parameterValueGroup, double d) {
        parameterValueGroup.parameter(parameterDescriptor.getName().getCode()).setValue(d);
    }

    boolean isSpherical() {
        return false;
    }

    @Override
    public int hashCode() {
        return this.parameters.hashCode() + 31 * this.getClass().hashCode() ^ 0xA2E5EA06;
    }

    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof MathTransform && this.equivalent((MathTransform)object, true)) {
            return Utilities.equals(this.parameters, ((UnitaryProjection)object).parameters);
        }
        return false;
    }

    @Override
    public boolean equivalent(MathTransform mathTransform, boolean bl) {
        if (mathTransform != null && mathTransform.getClass().equals(this.getClass())) {
            UnitaryProjection unitaryProjection = (UnitaryProjection)mathTransform;
            return UnitaryProjection.equals(this.excentricitySquared, unitaryProjection.excentricitySquared, bl) && UnitaryProjection.equals(this.longitudeRotation, unitaryProjection.longitudeRotation, bl) && UnitaryProjection.equals(this.longitudeBound, unitaryProjection.longitudeBound, bl);
        }
        return false;
    }

    static boolean equals(double d, double d2, boolean bl) {
        double d3;
        double d4;
        if (!bl && (d4 = Math.abs(d - d2)) <= (d3 = Math.max(Math.abs(d), Math.abs(d2))) * 1.0E-14) {
            return true;
        }
        return Utilities.equals(d, d2);
    }

    private final class Inverse
    extends AbstractMathTransform2D.Inverse {
        private static final long serialVersionUID = -9138242780765956870L;

        public Inverse() {
            super(UnitaryProjection.this);
        }

        @Override
        protected void transform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
            UnitaryProjection.this.inverseTransform(dArray, n, dArray2, n2);
            if (UnitaryProjection.this.verifyCoordinateRanges()) {
                UnitaryProjection.this.logWarning(UnitaryProjection.verifyGeographicRanges(this, dArray[n], dArray[n + 1]));
            }
            assert (Assertions.checkReciprocal(UnitaryProjection.this, false, dArray, n, dArray2, n2, 1));
        }
    }

    protected static class Parameters
    extends AbstractMathTransform2D.Parameters {
        private static final long serialVersionUID = -4952134260969915530L;
        private static final double[] EMPTY = new double[0];
        public final double semiMajor;
        public final double semiMinor;
        final Boolean rollLongitude;
        public double centralMeridian;
        public double latitudeOfOrigin;
        public final double[] standardParallels;
        public double azimuth;
        public double scaleFactor;
        public double falseEasting;
        public double falseNorthing;
        private final double[] xyScaleAndRotation;

        public Parameters(ParameterDescriptorGroup parameterDescriptorGroup, ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
            super(parameterDescriptorGroup);
            UnitaryProjection.ensureNonNull("values", parameterValueGroup);
            List<GeneralParameterDescriptor> list = parameterDescriptorGroup.descriptors();
            this.semiMajor = org.geotoolkit.parameter.Parameters.doubleValue(MapProjection.SEMI_MAJOR, parameterValueGroup);
            this.semiMinor = org.geotoolkit.parameter.Parameters.doubleValue(MapProjection.SEMI_MINOR, parameterValueGroup);
            this.rollLongitude = org.geotoolkit.parameter.Parameters.value(MapProjection.ROLL_LONGITUDE, parameterValueGroup);
            this.centralMeridian = Parameters.doubleValue(list, Identifiers.CENTRAL_MERIDIAN, parameterValueGroup);
            this.latitudeOfOrigin = Parameters.doubleValue(list, Identifiers.LATITUDE_OF_ORIGIN, parameterValueGroup);
            double d = Parameters.doubleValue(list, Identifiers.STANDARD_PARALLEL_1, parameterValueGroup);
            double d2 = Parameters.doubleValue(list, Identifiers.STANDARD_PARALLEL_2, parameterValueGroup);
            this.azimuth = Parameters.doubleValue(list, Identifiers.AZIMUTH, parameterValueGroup);
            this.scaleFactor = Parameters.doubleValue(list, Identifiers.SCALE_FACTOR, parameterValueGroup);
            this.falseEasting = Parameters.doubleValue(list, Identifiers.FALSE_EASTING, parameterValueGroup);
            this.falseNorthing = Parameters.doubleValue(list, Identifiers.FALSE_NORTHING, parameterValueGroup);
            double d3 = Parameters.doubleValue(list, MapProjection.X_SCALE, parameterValueGroup);
            double d4 = Parameters.doubleValue(list, MapProjection.Y_SCALE, parameterValueGroup);
            double d5 = Parameters.doubleValue(list, MapProjection.XY_PLANE_ROTATION, parameterValueGroup);
            switch ((Double.isNaN(d) ? 0 : 1) | (Double.isNaN(d2) ? 0 : 2)) {
                case 0: {
                    this.standardParallels = EMPTY;
                    break;
                }
                case 1: {
                    this.standardParallels = new double[]{d};
                    break;
                }
                case 2: {
                    this.standardParallels = new double[]{d2};
                    break;
                }
                case 3: {
                    this.standardParallels = new double[]{d, d2};
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.xyScaleAndRotation = (double[])(d3 != 1.0 || d4 != 1.0 || d5 != 0.0 ? new double[]{d3, d4, d5} : null);
        }

        final boolean nameMatches(ParameterDescriptorGroup parameterDescriptorGroup) {
            ParameterDescriptorGroup parameterDescriptorGroup2 = this.getParameterDescriptors();
            for (GenericName genericName : parameterDescriptorGroup.getAlias()) {
                Identifier identifier;
                if (!(genericName instanceof Identifier) || (identifier = (Identifier)((Object)genericName)).getAuthority() == Citations.GEOTOOLKIT || !AbstractIdentifiedObject.nameMatches((IdentifiedObject)parameterDescriptorGroup2, identifier.getCode())) continue;
                return true;
            }
            return false;
        }

        final boolean isSpherical() {
            return this.semiMajor == this.semiMinor;
        }

        final void ensureSpherical() throws IllegalArgumentException {
            if (!this.isSpherical()) {
                throw new IllegalArgumentException(Errors.format(48));
            }
        }

        public void validate() throws IllegalArgumentException {
            Parameters.ensureLongitudeInRange(Identifiers.CENTRAL_MERIDIAN, this.centralMeridian, true);
            Parameters.ensureLatitudeInRange(Identifiers.LATITUDE_OF_ORIGIN, this.latitudeOfOrigin, true);
            AffineTransform affineTransform = this.normalize(true);
            affineTransform.scale(Math.PI / 180, Math.PI / 180);
            if (this.centralMeridian != 0.0) {
                affineTransform.translate(-this.centralMeridian, 0.0);
            }
            AffineTransform affineTransform2 = this.normalize(false);
            double d = this.scaleFactor * this.semiMajor;
            affineTransform2.translate(this.falseEasting, this.falseNorthing);
            affineTransform2.scale(d, d);
            if (this.xyScaleAndRotation != null) {
                double d2 = this.xyScaleAndRotation[2];
                double d3 = d2 / 90.0;
                int n = (int)d3;
                if (d3 == (double)n) {
                    affineTransform2.quadrantRotate(n);
                } else {
                    affineTransform2.rotate(Math.toRadians(d2));
                }
                affineTransform2.scale(this.xyScaleAndRotation[0], this.xyScaleAndRotation[1]);
            }
        }

        @Override
        public ParameterValueGroup getParameterValues() {
            ParameterDescriptorGroup parameterDescriptorGroup = this.getParameterDescriptors();
            ParameterValueGroup parameterValueGroup = parameterDescriptorGroup.createValue();
            List<GeneralParameterDescriptor> list = parameterDescriptorGroup.descriptors();
            parameterValueGroup.parameter(MapProjection.SEMI_MAJOR.getName().getCode()).setValue(this.semiMajor);
            parameterValueGroup.parameter(MapProjection.SEMI_MINOR.getName().getCode()).setValue(this.semiMinor);
            if (this.rollLongitude != null) {
                parameterValueGroup.parameter(MapProjection.ROLL_LONGITUDE.getName().getCode()).setValue(this.rollLongitude);
            }
            Parameters.set(list, Identifiers.AZIMUTH, parameterValueGroup, this.azimuth);
            Parameters.set(list, Identifiers.CENTRAL_MERIDIAN, parameterValueGroup, this.centralMeridian);
            Parameters.set(list, Identifiers.LATITUDE_OF_ORIGIN, parameterValueGroup, this.latitudeOfOrigin);
            Parameters.set(list, Identifiers.SCALE_FACTOR, parameterValueGroup, this.scaleFactor);
            Parameters.set(list, Identifiers.FALSE_EASTING, parameterValueGroup, this.falseEasting);
            Parameters.set(list, Identifiers.FALSE_NORTHING, parameterValueGroup, this.falseNorthing);
            switch (this.standardParallels.length) {
                default: {
                    Parameters.set(list, Identifiers.STANDARD_PARALLEL_2, parameterValueGroup, this.standardParallels[1]);
                }
                case 1: {
                    Parameters.set(list, Identifiers.STANDARD_PARALLEL_1, parameterValueGroup, this.standardParallels[0]);
                }
                case 0: 
            }
            if (this.xyScaleAndRotation != null) {
                Parameters.set(list, MapProjection.X_SCALE, parameterValueGroup, this.xyScaleAndRotation[0]);
                Parameters.set(list, MapProjection.Y_SCALE, parameterValueGroup, this.xyScaleAndRotation[1]);
                Parameters.set(list, MapProjection.XY_PLANE_ROTATION, parameterValueGroup, this.xyScaleAndRotation[2]);
            }
            return parameterValueGroup;
        }

        @Override
        public int hashCode() {
            return Utilities.hash(this.semiMajor, Utilities.hash(this.semiMinor, Utilities.hash(this.centralMeridian, Utilities.hash(this.latitudeOfOrigin, Utilities.hash(this.scaleFactor, Utilities.hash(this.falseEasting, Utilities.hash(this.falseNorthing, Arrays.hashCode(this.standardParallels))))))));
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (super.equals(object)) {
                Parameters parameters = (Parameters)object;
                return Utilities.equals(this.semiMajor, parameters.semiMajor) && Utilities.equals(this.semiMinor, parameters.semiMinor) && Utilities.equals(this.rollLongitude, parameters.rollLongitude) && Utilities.equals(this.centralMeridian, parameters.centralMeridian) && Utilities.equals(this.latitudeOfOrigin, parameters.latitudeOfOrigin) && Arrays.equals(this.standardParallels, parameters.standardParallels) && Utilities.equals(this.azimuth, parameters.azimuth) && Utilities.equals(this.scaleFactor, parameters.scaleFactor) && Utilities.equals(this.falseEasting, parameters.falseEasting) && Utilities.equals(this.falseNorthing, parameters.falseNorthing) && Arrays.equals(this.xyScaleAndRotation, parameters.xyScaleAndRotation);
            }
            return false;
        }

        static double doubleValue(Collection<GeneralParameterDescriptor> collection, ParameterDescriptor<Double> parameterDescriptor, ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
            double d;
            ParameterDescriptor<?> parameterDescriptor2;
            if (parameterDescriptor instanceof Identifiers) {
                double d2;
                parameterDescriptor2 = ((Identifiers)parameterDescriptor).find(collection);
                if (parameterDescriptor2 != null && !Double.isNaN(d2 = org.geotoolkit.parameter.Parameters.doubleValue(parameterDescriptor2, parameterValueGroup))) {
                    return d2;
                }
            } else if (collection.contains(parameterDescriptor) && !Double.isNaN(d = org.geotoolkit.parameter.Parameters.doubleValue(parameterDescriptor, parameterValueGroup))) {
                return d;
            }
            return (parameterDescriptor2 = parameterDescriptor.getDefaultValue()) instanceof Number ? ((Number)((Object)parameterDescriptor2)).doubleValue() : Double.NaN;
        }

        static void ensureLongitudeInRange(ParameterDescriptor<? extends Number> parameterDescriptor, double d, boolean bl) throws IllegalArgumentException {
            if (bl ? d >= -180.0 && d <= 180.0 : d > -180.0 && d < 180.0) {
                return;
            }
            String string = parameterDescriptor.getName().getCode();
            throw new InvalidParameterValueException(Errors.format(95, new Longitude(d)), string, d);
        }

        static void ensureLatitudeInRange(ParameterDescriptor<? extends Number> parameterDescriptor, double d, boolean bl) throws IllegalArgumentException {
            if (bl ? d >= -90.0 && d <= 90.0 : d > -90.0 && d < 90.0) {
                return;
            }
            String string = parameterDescriptor.getName().getCode();
            throw new InvalidParameterValueException(Errors.format(92, new Latitude(d)), string, d);
        }

        static void ensureLatitudeEquals(ParameterDescriptor<? extends Number> parameterDescriptor, double d, double d2) throws IllegalArgumentException {
            if (!(Math.abs(Math.abs(d) - d2) < 5.729577951308232E-5)) {
                String string = parameterDescriptor.getName().getCode();
                throw new InvalidParameterValueException(Errors.format(63, string, new Latitude(d)), string, d);
            }
        }

        static void set(Collection<GeneralParameterDescriptor> collection, ParameterDescriptor<?> parameterDescriptor, ParameterValueGroup parameterValueGroup, double d) {
            Object obj;
            if (parameterDescriptor instanceof Identifiers ? (parameterDescriptor = ((Identifiers)parameterDescriptor).find(collection)) == null : !collection.contains(parameterDescriptor)) {
                return;
            }
            if (parameterDescriptor.getMinimumOccurs() == 0 && (obj = parameterDescriptor.getDefaultValue()) instanceof Number && Utilities.equals(((Number)obj).doubleValue(), d)) {
                return;
            }
            parameterValueGroup.parameter(parameterDescriptor.getName().getCode()).setValue(d);
        }
    }
}

