/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.provider;

import org.geotoolkit.internal.referencing.Identifiers;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.referencing.operation.projection.Equirectangular;
import org.geotoolkit.referencing.operation.provider.IdentifierCode;
import org.geotoolkit.referencing.operation.provider.MapProjection;
import org.geotoolkit.referencing.operation.provider.Mercator1SP;
import org.geotoolkit.resources.Vocabulary;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.MathTransform2D;

public class EquidistantCylindrical
extends MapProjection {
    private static final long serialVersionUID = -278288251842178001L;
    public static final ParameterDescriptor<Double> CENTRAL_MERIDIAN = Identifiers.CENTRAL_MERIDIAN.select("central_meridian", "Central_Meridian", "Longitude of natural origin", "ProjCenterLong");
    public static final ParameterDescriptor<Double> LATITUDE_OF_ORIGIN = Identifiers.LATITUDE_OF_ORIGIN.select("latitude_of_origin", "Latitude of natural origin", "Standard_Parallel_1", "ProjCenterLat");
    public static final ParameterDescriptor<Double> FALSE_EASTING = Mercator1SP.FALSE_EASTING;
    public static final ParameterDescriptor<Double> FALSE_NORTHING = Mercator1SP.FALSE_NORTHING;
    public static final ParameterDescriptorGroup PARAMETERS = Identifiers.createDescriptorGroup(new ReferenceIdentifier[]{new NamedIdentifier(Citations.OGC, "Equidistant_Cylindrical"), new NamedIdentifier(Citations.EPSG, "Equidistant Cylindrical"), new NamedIdentifier(Citations.EPSG, "Equidistant Cylindrical (Spherical)"), new IdentifierCode(Citations.EPSG, 1028), new IdentifierCode(Citations.EPSG, 1029), new IdentifierCode(Citations.EPSG, 9842, 1028), new IdentifierCode(Citations.EPSG, 9823, 1029), new NamedIdentifier(Citations.GEOTIFF, "CT_Equirectangular"), new IdentifierCode(Citations.GEOTIFF, 17), new NamedIdentifier(Citations.GEOTOOLKIT, Vocabulary.formatInternational(86))}, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, ROLL_LONGITUDE, CENTRAL_MERIDIAN, LATITUDE_OF_ORIGIN, FALSE_EASTING, FALSE_NORTHING});

    public EquidistantCylindrical() {
        super(PARAMETERS);
    }

    EquidistantCylindrical(ParameterDescriptorGroup parameterDescriptorGroup) {
        super(parameterDescriptorGroup);
    }

    public Class<CylindricalProjection> getOperationType() {
        return CylindricalProjection.class;
    }

    @Override
    protected MathTransform2D createMathTransform(ParameterValueGroup parameterValueGroup) {
        return Equirectangular.create(this.getParameters(), parameterValueGroup);
    }
}

