/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.provider;

import org.geotoolkit.internal.referencing.Identifiers;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.referencing.operation.projection.LambertConformal;
import org.geotoolkit.referencing.operation.provider.IdentifierCode;
import org.geotoolkit.referencing.operation.provider.LambertConformal1SP;
import org.geotoolkit.referencing.operation.provider.MapProjection;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.ConicProjection;
import org.opengis.referencing.operation.MathTransform2D;

public class LambertConformal2SP
extends MapProjection {
    private static final long serialVersionUID = 3240860802816724947L;
    public static final ParameterDescriptor<Double> CENTRAL_MERIDIAN = Identifiers.CENTRAL_MERIDIAN.select("central_meridian", "Central_Meridian", "Longitude of false origin", "FalseOriginLong");
    public static final ParameterDescriptor<Double> LATITUDE_OF_ORIGIN = Identifiers.LATITUDE_OF_ORIGIN.select("latitude_of_origin", "Latitude_Of_Origin", "Latitude of false origin", "FalseOriginLat");
    public static final ParameterDescriptor<Double> STANDARD_PARALLEL_1 = Identifiers.STANDARD_PARALLEL_1.select("standard_parallel_1", "Standard_Parallel_1", "Latitude of 1st standard parallel");
    public static final ParameterDescriptor<Double> STANDARD_PARALLEL_2 = Identifiers.STANDARD_PARALLEL_2.select("Latitude of 2nd standard parallel");
    public static final ParameterDescriptor<Double> FALSE_EASTING = Identifiers.FALSE_EASTING.select("Easting at false origin", "FalseOriginEasting");
    public static final ParameterDescriptor<Double> FALSE_NORTHING = Identifiers.FALSE_NORTHING.select("Northing at false origin", "FalseOriginNorthing");
    public static final ParameterDescriptorGroup PARAMETERS = Identifiers.createDescriptorGroup(new ReferenceIdentifier[]{new NamedIdentifier(Citations.OGC, "Lambert_Conformal_Conic_2SP"), new NamedIdentifier(Citations.EPSG, "Lambert Conic Conformal (2SP)"), new IdentifierCode(Citations.EPSG, 9802), new NamedIdentifier(Citations.GEOTIFF, "CT_LambertConfConic_2SP"), new NamedIdentifier(Citations.GEOTIFF, "CT_LambertConfConic"), new IdentifierCode(Citations.GEOTIFF, 9), LambertConformal2SP.sameNameAs(Citations.GEOTOOLKIT, LambertConformal1SP.PARAMETERS)}, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, ROLL_LONGITUDE, CENTRAL_MERIDIAN, LATITUDE_OF_ORIGIN, STANDARD_PARALLEL_1, STANDARD_PARALLEL_2, FALSE_EASTING, FALSE_NORTHING});

    public LambertConformal2SP() {
        super(PARAMETERS);
    }

    LambertConformal2SP(ParameterDescriptorGroup parameterDescriptorGroup) {
        super(parameterDescriptorGroup);
    }

    public Class<ConicProjection> getOperationType() {
        return ConicProjection.class;
    }

    @Override
    protected MathTransform2D createMathTransform(ParameterValueGroup parameterValueGroup) {
        return LambertConformal.create(this.getParameters(), parameterValueGroup);
    }

    public static class Belgium
    extends LambertConformal2SP {
        private static final long serialVersionUID = -6388030784088639876L;
        public static final ParameterDescriptorGroup PARAMETERS = Identifiers.createDescriptorGroup(new ReferenceIdentifier[]{new NamedIdentifier(Citations.OGC, "Lambert_Conformal_Conic_2SP_Belgium"), new NamedIdentifier(Citations.EPSG, "Lambert Conic Conformal (2SP Belgium)"), new IdentifierCode(Citations.EPSG, 9803), Belgium.sameNameAs(Citations.GEOTOOLKIT, PARAMETERS)}, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, ROLL_LONGITUDE, CENTRAL_MERIDIAN, LATITUDE_OF_ORIGIN, STANDARD_PARALLEL_1, STANDARD_PARALLEL_2, FALSE_EASTING, FALSE_NORTHING});

        public Belgium() {
            super(PARAMETERS);
        }
    }

    public static class ESRI
    extends LambertConformal2SP {
        private static final long serialVersionUID = -560511707695966609L;
        public static final ParameterDescriptor<Double> SCALE_FACTOR = LambertConformal1SP.SCALE_FACTOR;
        public static final ParameterDescriptorGroup PARAMETERS = Identifiers.createDescriptorGroup(new ReferenceIdentifier[]{new NamedIdentifier(Citations.ESRI, "Lambert_Conformal_Conic"), ESRI.sameNameAs(Citations.GEOTOOLKIT, PARAMETERS)}, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, ROLL_LONGITUDE, CENTRAL_MERIDIAN, LATITUDE_OF_ORIGIN, STANDARD_PARALLEL_1, STANDARD_PARALLEL_2, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});

        public ESRI() {
            super(PARAMETERS);
        }
    }
}

