/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.provider;

import java.awt.geom.AffineTransform;
import javax.measure.unit.NonSI;
import org.geotoolkit.internal.referencing.Identifiers;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.parameter.Parameters;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.referencing.operation.MathTransformProvider;
import org.geotoolkit.referencing.operation.provider.IdentifierCode;
import org.geotoolkit.referencing.operation.transform.ProjectiveTransform;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;

public class LongitudeRotation
extends MathTransformProvider {
    private static final long serialVersionUID = -2104496465933824935L;
    public static final ParameterDescriptor<Double> OFFSET = Identifiers.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.EPSG, "Longitude offset")}, Double.NaN, -180.0, 180.0, NonSI.DEGREE_ANGLE);
    public static final ParameterDescriptorGroup PARAMETERS = Identifiers.createDescriptorGroup(new ReferenceIdentifier[]{new NamedIdentifier(Citations.EPSG, "Longitude rotation"), new IdentifierCode(Citations.EPSG, 9601)}, new ParameterDescriptor[]{OFFSET});

    public LongitudeRotation() {
        super(2, 2, PARAMETERS);
    }

    public Class<Conversion> getOperationType() {
        return Conversion.class;
    }

    @Override
    protected MathTransform createMathTransform(ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
        double d = Parameters.doubleValue(OFFSET, parameterValueGroup);
        return ProjectiveTransform.create(AffineTransform.getTranslateInstance(d, 0.0));
    }
}

