/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.provider;

import org.geotoolkit.internal.referencing.Identifiers;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.referencing.operation.provider.IdentifierCode;
import org.geotoolkit.referencing.operation.provider.MapProjection;
import org.geotoolkit.referencing.operation.provider.Mercator1SP;
import org.geotoolkit.resources.Vocabulary;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.PlanarProjection;

public class Orthographic
extends MapProjection {
    private static final long serialVersionUID = 3180410512573499562L;
    public static final ParameterDescriptor<Double> LONGITUDE_OF_CENTRE = Identifiers.CENTRAL_MERIDIAN.select("central_meridian", "Longitude_Of_Center", "Longitude of natural origin", "ProjCenterLong");
    public static final ParameterDescriptor<Double> LATITUDE_OF_CENTRE = Identifiers.LATITUDE_OF_ORIGIN.select("latitude_of_origin", "Latitude_Of_Center", "Latitude of natural origin", "ProjCenterLat");
    public static final ParameterDescriptor<Double> SCALE_FACTOR = Identifiers.SCALE_FACTOR.select(false, "Scale factor at natural origin", "ScaleAtNatOrigin");
    public static final ParameterDescriptor<Double> FALSE_EASTING = Mercator1SP.FALSE_EASTING;
    public static final ParameterDescriptor<Double> FALSE_NORTHING = Mercator1SP.FALSE_NORTHING;
    public static final ParameterDescriptorGroup PARAMETERS = Identifiers.createDescriptorGroup(new ReferenceIdentifier[]{new NamedIdentifier(Citations.OGC, "Orthographic"), new NamedIdentifier(Citations.ESRI, "Orthographic"), new NamedIdentifier(Citations.EPSG, "Orthographic"), new IdentifierCode(Citations.EPSG, 9840), new NamedIdentifier(Citations.GEOTIFF, "CT_Orthographic"), new IdentifierCode(Citations.GEOTIFF, 21), new NamedIdentifier(Citations.GEOTOOLKIT, Vocabulary.formatInternational(197))}, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, ROLL_LONGITUDE, LONGITUDE_OF_CENTRE, LATITUDE_OF_CENTRE, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});

    public Orthographic() {
        super(PARAMETERS);
    }

    public Class<PlanarProjection> getOperationType() {
        return PlanarProjection.class;
    }

    @Override
    protected MathTransform2D createMathTransform(ParameterValueGroup parameterValueGroup) {
        return org.geotoolkit.referencing.operation.projection.Orthographic.create(this.getParameters(), parameterValueGroup);
    }
}

