/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.transform;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Length;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotoolkit.parameter.FloatParameter;
import org.geotoolkit.parameter.Parameter;
import org.geotoolkit.parameter.ParameterGroup;
import org.geotoolkit.referencing.operation.provider.EllipsoidToGeocentric;
import org.geotoolkit.referencing.operation.provider.GeocentricToEllipsoid;
import org.geotoolkit.referencing.operation.transform.AbstractMathTransform;
import org.geotoolkit.referencing.operation.transform.IterationStrategy;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Utilities;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.MathTransform;

public class GeocentricTransform
extends AbstractMathTransform
implements Serializable {
    private static final long serialVersionUID = -3352045463953828140L;
    private static final double MAX_ERROR = 0.01;
    private static final double COS_67P5 = 0.3826834323650898;
    private static final double AD_C = 1.0026;
    private final double a;
    private final double b;
    private final double a2;
    private final double b2;
    private final double e2;
    private final double ep2;
    private final boolean hasHeight;
    private transient MathTransform inverse;

    public GeocentricTransform(Ellipsoid ellipsoid, boolean bl) {
        this(ellipsoid.getSemiMajorAxis(), ellipsoid.getSemiMinorAxis(), ellipsoid.getAxisUnit(), bl);
    }

    public GeocentricTransform(double d, double d2, Unit<Length> unit, boolean bl) {
        this.hasHeight = bl;
        UnitConverter unitConverter = unit.getConverterTo(SI.METRE);
        this.a = unitConverter.convert(d);
        this.b = unitConverter.convert(d2);
        this.a2 = this.a * this.a;
        this.b2 = this.b * this.b;
        this.e2 = (this.a2 - this.b2) / this.a2;
        this.ep2 = (this.a2 - this.b2) / this.b2;
        GeocentricTransform.checkArgument("a", this.a, Double.MAX_VALUE);
        GeocentricTransform.checkArgument("b", this.b, this.a);
    }

    private static void checkArgument(String string, double d, double d2) throws IllegalArgumentException {
        if (!(d >= 0.0) || !(d <= d2)) {
            throw new IllegalArgumentException(Errors.format(63, string, d));
        }
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return EllipsoidToGeocentric.PARAMETERS;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return this.getParameterValues(this.getParameterDescriptors());
    }

    private ParameterValueGroup getParameterValues(ParameterDescriptorGroup parameterDescriptorGroup) {
        GeneralParameterValue[] generalParameterValueArray = new ParameterValue[this.hasHeight ? 2 : 3];
        int n = 0;
        if (!this.hasHeight) {
            Parameter<Integer> parameter = new Parameter<Integer>(EllipsoidToGeocentric.DIM);
            parameter.setValue(2);
            generalParameterValueArray[n++] = parameter;
        }
        generalParameterValueArray[n++] = new FloatParameter(EllipsoidToGeocentric.SEMI_MAJOR, this.a);
        generalParameterValueArray[n++] = new FloatParameter(EllipsoidToGeocentric.SEMI_MINOR, this.b);
        return new ParameterGroup(parameterDescriptorGroup, generalParameterValueArray);
    }

    @Override
    public final int getSourceDimensions() {
        return this.hasHeight ? 3 : 2;
    }

    @Override
    public final int getTargetDimensions() {
        return 3;
    }

    @Override
    protected void transform(double[] dArray, int n, double[] dArray2, int n2) {
        this.transform(dArray, n, dArray2, n2, 1, this.hasHeight);
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        this.transform(dArray, n, dArray2, n2, n3, this.hasHeight);
    }

    private void transform(double[] dArray, int n, double[] dArray2, int n2, int n3, boolean bl) {
        int n4 = bl ? 3 : 2;
        int n5 = 0;
        int n6 = 0;
        if (dArray == dArray2) {
            switch (IterationStrategy.suggest(n, n4, n2, 3, n3)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    n += (n3 - 1) * n4;
                    n2 += (n3 - 1) * 3;
                    n5 = -2 * n4;
                    n6 = -6;
                    break;
                }
                default: {
                    dArray = Arrays.copyOfRange(dArray, n, n + n3 * n4);
                    n = 0;
                }
            }
        }
        while (--n3 >= 0) {
            double d = Math.toRadians(dArray[n++]);
            double d2 = Math.toRadians(dArray[n++]);
            double d3 = bl ? dArray[n++] : 0.0;
            double d4 = Math.cos(d2);
            double d5 = Math.sin(d2);
            double d6 = this.a / Math.sqrt(1.0 - this.e2 * (d5 * d5));
            dArray2[n2++] = (d6 + d3) * d4 * Math.cos(d);
            dArray2[n2++] = (d6 + d3) * d4 * Math.sin(d);
            dArray2[n2++] = (d6 * (1.0 - this.e2) + d3) * d5;
            n += n5;
            n2 += n6;
        }
    }

    @Override
    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        int n4 = this.getSourceDimensions();
        int n5 = 0;
        int n6 = 0;
        if (fArray == fArray2) {
            switch (IterationStrategy.suggest(n, n4, n2, 3, n3)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    n += (n3 - 1) * n4;
                    n2 += (n3 - 1) * 3;
                    n5 = -2 * n4;
                    n6 = -6;
                    break;
                }
                default: {
                    fArray = Arrays.copyOfRange(fArray, n, n + n3 * n4);
                    n = 0;
                }
            }
        }
        while (--n3 >= 0) {
            double d = Math.toRadians(fArray[n++]);
            double d2 = Math.toRadians(fArray[n++]);
            double d3 = this.hasHeight ? (double)fArray[n++] : 0.0;
            double d4 = Math.cos(d2);
            double d5 = Math.sin(d2);
            double d6 = this.a / Math.sqrt(1.0 - this.e2 * (d5 * d5));
            fArray2[n2++] = (float)((d6 + d3) * d4 * Math.cos(d));
            fArray2[n2++] = (float)((d6 + d3) * d4 * Math.sin(d));
            fArray2[n2++] = (float)((d6 * (1.0 - this.e2) + d3) * d5);
            n += n5;
            n2 += n6;
        }
    }

    @Override
    public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) {
        while (--n3 >= 0) {
            double d = Math.toRadians(fArray[n++]);
            double d2 = Math.toRadians(fArray[n++]);
            double d3 = this.hasHeight ? (double)fArray[n++] : 0.0;
            double d4 = Math.cos(d2);
            double d5 = Math.sin(d2);
            double d6 = this.a / Math.sqrt(1.0 - this.e2 * (d5 * d5));
            dArray[n2++] = (d6 + d3) * d4 * Math.cos(d);
            dArray[n2++] = (d6 + d3) * d4 * Math.sin(d);
            dArray[n2++] = (d6 * (1.0 - this.e2) + d3) * d5;
        }
    }

    @Override
    public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) {
        while (--n3 >= 0) {
            double d = Math.toRadians(dArray[n++]);
            double d2 = Math.toRadians(dArray[n++]);
            double d3 = this.hasHeight ? dArray[n++] : 0.0;
            double d4 = Math.cos(d2);
            double d5 = Math.sin(d2);
            double d6 = this.a / Math.sqrt(1.0 - this.e2 * (d5 * d5));
            fArray[n2++] = (float)((d6 + d3) * d4 * Math.cos(d));
            fArray[n2++] = (float)((d6 + d3) * d4 * Math.sin(d));
            fArray[n2++] = (float)((d6 * (1.0 - this.e2) + d3) * d5);
        }
    }

    final void inverseTransform(float[] fArray, double[] dArray, int n, float[] fArray2, double[] dArray2, int n2, int n3, boolean bl) {
        boolean bl2 = this.hasHeight;
        if (!$assertionsDisabled) {
            bl2 = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (bl) {
            int n4 = (n3 - 1) * 3;
            n += n4;
            n2 += n4;
            if (!bl2) {
                n2 -= n3 - 1;
            }
        }
        while (--n3 >= 0) {
            double d;
            double d2;
            double d3;
            if (dArray != null) {
                d3 = dArray[n++];
                d2 = dArray[n++];
                d = dArray[n++];
            } else {
                d3 = fArray[n++];
                d2 = fArray[n++];
                d = fArray[n++];
            }
            double d4 = Math.hypot(d3, d2);
            double d5 = d * 1.0026;
            double d6 = Math.hypot(d5, d4);
            double d7 = d5 / d6;
            double d8 = d4 / d6;
            double d9 = d7 * d7 * d7;
            double d10 = d + this.b * this.ep2 * d9;
            double d11 = d4 - this.a * this.e2 * (d8 * d8 * d8);
            double d12 = Math.hypot(d10, d11);
            double d13 = d10 / d12;
            double d14 = d11 / d12;
            double d15 = Math.toDegrees(Math.atan2(d2, d3));
            double d16 = Math.toDegrees(Math.atan(d13 / d14));
            if (dArray2 != null) {
                dArray2[n2++] = d15;
                dArray2[n2++] = d16;
            } else {
                fArray2[n2++] = (float)d15;
                fArray2[n2++] = (float)d16;
            }
            if (bl2) {
                double d17;
                double d18 = this.a / Math.sqrt(1.0 - this.e2 * (d13 * d13));
                double d19 = d14 >= 0.3826834323650898 ? d4 / d14 - d18 : (d14 <= -0.3826834323650898 ? d4 / -d14 - d18 : d / d13 + d18 * (this.e2 - 1.0));
                if (this.hasHeight) {
                    if (dArray2 != null) {
                        dArray2[n2++] = d19;
                    } else {
                        fArray2[n2++] = (float)d19;
                    }
                }
                assert (0.01 > (d17 = this.checkTransform(new double[]{d3, d2, d, d15, d16, d19}))) : d17;
            }
            if (!bl) continue;
            n -= 6;
            n2 -= bl2 ? 6 : 4;
        }
    }

    private double checkTransform(double[] dArray) {
        this.transform(dArray, 3, dArray, 3, 1, true);
        double d = dArray[0] - dArray[3];
        double d2 = dArray[1] - dArray[4];
        double d3 = dArray[2] - dArray[5];
        return Math.sqrt(d * d + d2 * d2 + d3 * d3);
    }

    @Override
    public synchronized MathTransform inverse() {
        if (this.inverse == null) {
            this.inverse = new Inverse();
        }
        return this.inverse;
    }

    @Override
    public int hashCode() {
        long l = Double.doubleToLongBits(this.a) + 31L * (Double.doubleToLongBits(this.b) + 31L * (Double.doubleToLongBits(this.a2) + 31L * (Double.doubleToLongBits(this.b2) + 31L * (Double.doubleToLongBits(this.e2) + 31L * Double.doubleToLongBits(this.ep2)))));
        int n = (int)l ^ (int)(l >>> 32);
        if (this.hasHeight) {
            n += 37;
        }
        return n ^ 0x121296D4;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            GeocentricTransform geocentricTransform = (GeocentricTransform)object;
            return this.hasHeight == geocentricTransform.hasHeight && Utilities.equals(this.a, geocentricTransform.a) && Utilities.equals(this.b, geocentricTransform.b) && Utilities.equals(this.a2, geocentricTransform.a2) && Utilities.equals(this.b2, geocentricTransform.b2) && Utilities.equals(this.e2, geocentricTransform.e2) && Utilities.equals(this.ep2, geocentricTransform.ep2);
        }
        return false;
    }

    private final class Inverse
    extends AbstractMathTransform.Inverse
    implements Serializable {
        private static final long serialVersionUID = 6942084702259211803L;

        @Override
        public ParameterDescriptorGroup getParameterDescriptors() {
            return GeocentricToEllipsoid.PARAMETERS;
        }

        @Override
        public ParameterValueGroup getParameterValues() {
            return GeocentricTransform.this.getParameterValues(this.getParameterDescriptors());
        }

        @Override
        protected void transform(double[] dArray, int n, double[] dArray2, int n2) {
            GeocentricTransform.this.inverseTransform(null, dArray, n, null, dArray2, n2, 1, false);
        }

        @Override
        public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
            boolean bl = false;
            if (dArray == dArray2) {
                switch (IterationStrategy.suggest(n, this.getSourceDimensions(), n2, this.getTargetDimensions(), n3)) {
                    case ASCENDING: {
                        break;
                    }
                    case DESCENDING: {
                        bl = true;
                        break;
                    }
                    default: {
                        dArray = Arrays.copyOfRange(dArray, n, n + 3 * n3);
                        n = 0;
                    }
                }
            }
            GeocentricTransform.this.inverseTransform(null, dArray, n, null, dArray2, n2, n3, bl);
        }

        @Override
        public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
            boolean bl = false;
            if (fArray == fArray2) {
                switch (IterationStrategy.suggest(n, this.getSourceDimensions(), n2, this.getTargetDimensions(), n3)) {
                    case ASCENDING: {
                        break;
                    }
                    case DESCENDING: {
                        bl = true;
                        break;
                    }
                    default: {
                        fArray = Arrays.copyOfRange(fArray, n, n + 3 * n3);
                        n = 0;
                    }
                }
            }
            GeocentricTransform.this.inverseTransform(fArray, null, n, fArray2, null, n2, n3, bl);
        }

        @Override
        public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) {
            GeocentricTransform.this.inverseTransform(fArray, null, n, null, dArray, n2, n3, false);
        }

        @Override
        public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) {
            GeocentricTransform.this.inverseTransform(null, dArray, n, fArray, null, n2, n3, false);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            GeocentricTransform.this.inverse = this;
        }
    }
}

