/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.transform;

import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.geotoolkit.referencing.operation.matrix.MatrixFactory;
import org.geotoolkit.referencing.operation.matrix.XMatrix;
import org.geotoolkit.referencing.operation.transform.AbstractMathTransform;
import org.geotoolkit.referencing.operation.transform.GridTransform2D;
import org.geotoolkit.referencing.operation.transform.GridType;
import org.geotoolkit.referencing.operation.transform.IterationStrategy;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Utilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.Matrix;

public class GridTransform
extends AbstractMathTransform
implements Serializable {
    private static final long serialVersionUID = -7973466015425546562L;
    private static final int srcDim = 2;
    protected final int width;
    protected final int height;
    private final double xOrigin;
    private final double yOrigin;
    private final double scaleX;
    private final double scaleY;
    final GridType type;
    protected final transient DataBuffer grid;

    public static GridTransform create(int n, int n2, float[] ... fArray) {
        return GridTransform.create(GridType.LOCALIZATION, new DataBufferFloat(fArray, n * n2), new Dimension(n, n2), null);
    }

    public static GridTransform create(int n, int n2, double[] ... dArray) {
        return GridTransform.create(GridType.LOCALIZATION, new DataBufferDouble(dArray, n * n2), new Dimension(n, n2), null);
    }

    public static GridTransform create(GridType gridType, DataBuffer dataBuffer, Dimension dimension, Rectangle2D rectangle2D) {
        if (dataBuffer.getNumBanks() == 2) {
            return new GridTransform2D(gridType, dataBuffer, dimension, rectangle2D);
        }
        return new GridTransform(gridType, dataBuffer, dimension, rectangle2D);
    }

    protected GridTransform(GridType gridType, DataBuffer dataBuffer, Dimension dimension, Rectangle2D rectangle2D) {
        this.grid = dataBuffer;
        this.type = gridType;
        this.width = dimension.width;
        this.height = dimension.height;
        int n = this.width;
        if (n <= 0 || (n = this.height) <= 0) {
            throw new IllegalArgumentException(Errors.format(134, n));
        }
        if (dataBuffer.getSize() != this.width * this.height) {
            throw new IllegalArgumentException(Errors.format(98));
        }
        if (rectangle2D != null) {
            this.xOrigin = rectangle2D.getMinX();
            this.yOrigin = rectangle2D.getMinY();
            this.scaleX = (double)this.width / rectangle2D.getWidth();
            this.scaleY = (double)this.height / rectangle2D.getHeight();
        } else {
            this.xOrigin = 0.0;
            this.yOrigin = 0.0;
            this.scaleX = 1.0;
            this.scaleY = 1.0;
        }
    }

    @Override
    public final int getSourceDimensions() {
        return 2;
    }

    @Override
    public final int getTargetDimensions() {
        return this.grid.getNumBanks();
    }

    @Override
    public boolean isIdentity() {
        return false;
    }

    @Override
    public Matrix derivative(DirectPosition directPosition) {
        int n = directPosition.getDimension();
        if (n != 2) {
            throw new MismatchedDimensionException(Errors.format(101, "point", n, 2));
        }
        double d = directPosition.getOrdinate(0);
        double d2 = directPosition.getOrdinate(1);
        int n2 = Math.max(Math.min((int)d, this.width - 2), 0);
        int n3 = Math.max(Math.min((int)d2, this.height - 2), 0);
        int n4 = n2 + n3 * this.width;
        int n5 = n4 + this.width;
        int n6 = n4 + 1;
        int n7 = n5 + 1;
        double d3 = d - (double)n2;
        double d4 = d2 - (double)n3;
        int n8 = this.grid.getNumBanks();
        XMatrix xMatrix = MatrixFactory.create(n8, 2);
        for (int i = 0; i < n8; ++i) {
            double d5 = this.grid.getElemDouble(i, n4);
            double d6 = this.grid.getElemDouble(i, n5);
            double d7 = this.grid.getElemDouble(i, n6);
            double d8 = this.grid.getElemDouble(i, n7);
            double d9 = d7 - d5;
            d9 += (d8 - d6 - d9) * d4;
            double d10 = d6 - d5;
            d10 += (d8 - d7 - d10) * d3;
            switch (this.type) {
                case NADCON: {
                    d9 /= -3600.0;
                    d10 /= 3600.0;
                }
            }
            xMatrix.setElement(i, 0, d9);
            xMatrix.setElement(i, 1, d10);
        }
        return xMatrix;
    }

    @Override
    protected void transform(double[] dArray, int n, double[] dArray2, int n2) {
        double d = dArray[n++];
        double d2 = dArray[n++];
        double d3 = (d - this.xOrigin) * this.scaleX;
        double d4 = (d2 - this.yOrigin) * this.scaleY;
        int n3 = Math.max(Math.min((int)d3, this.width - 2), 0);
        int n4 = Math.max(Math.min((int)d4, this.height - 2), 0);
        int n5 = n3 + n4 * this.width;
        int n6 = n5 + this.width;
        int n7 = n5 + 1;
        int n8 = n6 + 1;
        double d5 = d3 - (double)n3;
        double d6 = d4 - (double)n4;
        int n9 = this.grid.getNumBanks();
        for (int i = 0; i < n9; ++i) {
            double d7 = this.grid.getElemDouble(i, n5);
            double d8 = this.grid.getElemDouble(i, n6);
            double d9 = (this.grid.getElemDouble(i, n7) - d7) * d5 + d7;
            double d10 = (this.grid.getElemDouble(i, n8) - d8) * d5 + d8;
            double d11 = d9 + (d10 - d9) * d6;
            block0 : switch (this.type) {
                case OFFSET: {
                    switch (i) {
                        case 0: {
                            d11 += d;
                            break;
                        }
                        case 1: {
                            d11 += d2;
                        }
                    }
                    break;
                }
                case NADCON: {
                    switch (i) {
                        case 0: {
                            d11 = d - d11 / 3600.0;
                            break block0;
                        }
                        case 1: {
                            d11 = d2 + d11 / 3600.0;
                        }
                    }
                }
            }
            dArray2[n2++] = d11;
        }
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        this.transform(null, dArray, n, null, dArray2, n2, n3);
    }

    @Override
    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        this.transform(fArray, null, n, fArray2, null, n2, n3);
    }

    @Override
    public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) {
        this.transform(null, dArray, n, fArray, null, n2, n3);
    }

    @Override
    public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) {
        this.transform(fArray, null, n, null, dArray, n2, n3);
    }

    private void transform(float[] fArray, double[] dArray, int n, float[] fArray2, double[] dArray2, int n2, int n3) {
        int n4;
        int n5 = this.width - 2;
        int n6 = this.height - 2;
        int n7 = this.grid.getNumBanks();
        int n8 = 0;
        Object[] objectArray = null;
        boolean bl = false;
        if (dArray != null ? dArray == dArray2 : fArray == fArray2) {
            switch (IterationStrategy.suggest(n, 2, n2, n7, n3)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    n += (n3 - 1) * 2;
                    n2 += (n3 - 1) * n7;
                    bl = true;
                    break;
                }
                default: {
                    n4 = n + n3 * 2;
                    if (fArray != null) {
                        fArray = Arrays.copyOfRange(fArray, n, n4);
                    } else {
                        dArray = Arrays.copyOfRange(dArray, n, n4);
                    }
                    n = 0;
                    break;
                }
                case BUFFER_TARGET: {
                    int n9 = n3 * n7;
                    if (fArray2 != null) {
                        objectArray = fArray2;
                        fArray2 = new float[n9];
                    } else {
                        objectArray = dArray2;
                        dArray2 = new double[n9];
                    }
                    n8 = n2;
                    n2 = 0;
                    break;
                }
            }
        }
        while (--n3 >= 0) {
            double d;
            double d2;
            if (dArray != null) {
                d2 = dArray[n++];
                d = dArray[n++];
            } else {
                d2 = fArray[n++];
                d = fArray[n++];
            }
            double d3 = (d2 - this.xOrigin) * this.scaleX;
            double d4 = (d - this.yOrigin) * this.scaleY;
            int n10 = Math.max(Math.min((int)d3, n5), 0);
            int n11 = Math.max(Math.min((int)d4, n6), 0);
            int n12 = n10 + n11 * this.width;
            int n13 = n12 + this.width;
            int n14 = n12 + 1;
            int n15 = n13 + 1;
            double d5 = d3 - (double)n10;
            double d6 = d4 - (double)n11;
            for (int i = 0; i < n7; ++i) {
                double d7 = this.grid.getElemDouble(i, n12);
                double d8 = this.grid.getElemDouble(i, n13);
                double d9 = (this.grid.getElemDouble(i, n14) - d7) * d5 + d7;
                double d10 = (this.grid.getElemDouble(i, n15) - d8) * d5 + d8;
                double d11 = d9 + (d10 - d9) * d6;
                block5 : switch (this.type) {
                    case OFFSET: {
                        switch (i) {
                            case 0: {
                                d11 += d2;
                                break;
                            }
                            case 1: {
                                d11 += d;
                            }
                        }
                        break;
                    }
                    case NADCON: {
                        switch (i) {
                            case 0: {
                                d11 = d2 - d11 / 3600.0;
                                break block5;
                            }
                            case 1: {
                                d11 = d + d11 / 3600.0;
                            }
                        }
                    }
                }
                if (dArray2 != null) {
                    dArray2[n2++] = d11;
                    continue;
                }
                fArray2[n2++] = (float)d11;
            }
            if (!bl) continue;
            n -= 4;
            n2 -= 2 * n7;
        }
        if (objectArray != null) {
            Object[] objectArray2;
            if (fArray2 != null) {
                objectArray2 = fArray2;
                n4 = fArray2.length;
            } else {
                objectArray2 = dArray2;
                n4 = dArray2.length;
            }
            System.arraycopy(objectArray2, 0, objectArray, n8, n4);
        }
    }

    @Override
    public int hashCode() {
        return Utilities.hash(this.xOrigin, Utilities.hash(this.yOrigin, Utilities.hash(this.scaleX, Utilities.hash(this.scaleY, Utilities.hash(this.width, Utilities.hash(this.height, this.grid.getNumBanks() ^ 0x79E936BE))))));
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            int n;
            GridTransform gridTransform = (GridTransform)object;
            if (this.width == gridTransform.width && this.height == gridTransform.height && Utilities.equals(this.xOrigin, gridTransform.xOrigin) && Utilities.equals(this.yOrigin, gridTransform.yOrigin) && Utilities.equals(this.scaleX, gridTransform.scaleX) && Utilities.equals(this.scaleY, gridTransform.scaleY) && (n = this.grid.getNumBanks()) == gridTransform.grid.getNumBanks()) {
                int n2 = this.width * this.height;
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        double d;
                        double d2 = this.grid.getElemDouble(i, j);
                        if (Utilities.equals(d2, d = gridTransform.grid.getElemDouble(i, j))) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Object object;
        objectOutputStream.defaultWriteObject();
        int n = this.grid.getSize();
        int[] nArray = this.grid.getOffsets();
        Class<?> clazz = this.grid.getClass();
        try {
            object = clazz.getMethod("getBankData", null).invoke((Object)this.grid, (Object[])null);
            int n2 = Array.getLength(object);
            while (--n2 >= 0) {
                Object object2 = Array.get(object, n2);
                int n3 = nArray[n2];
                if (n3 == 0 && Array.getLength(object2) == n) continue;
                Object object3 = object2;
                object2 = Array.newInstance(object3.getClass().getComponentType(), n);
                System.arraycopy(object3, n3, object2, 0, n);
                Array.set(object, n2, object2);
            }
        }
        catch (Exception exception) {
            NotSerializableException notSerializableException = new NotSerializableException(clazz.getCanonicalName());
            notSerializableException.initCause(exception);
            throw notSerializableException;
        }
        objectOutputStream.writeObject(clazz);
        objectOutputStream.writeObject(object);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = this.width * this.height;
        Object object = objectInputStream.readObject();
        Object object2 = objectInputStream.readObject();
        try {
            Class<DataBuffer> clazz = ((Class)object).asSubclass(DataBuffer.class);
            DataBuffer dataBuffer = clazz.getConstructor(object2.getClass(), Integer.TYPE).newInstance(object2, n);
            Field field = GridTransform.class.getDeclaredField("grid");
            field.setAccessible(true);
            field.set(this, dataBuffer);
        }
        catch (Exception exception) {
            InvalidObjectException invalidObjectException = new InvalidObjectException(Errors.format(209));
            invalidObjectException.initCause(exception);
            throw invalidObjectException;
        }
    }
}

