/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.transform;

import java.io.Serializable;
import org.geotoolkit.geometry.GeneralDirectPosition;
import org.geotoolkit.referencing.operation.matrix.MatrixFactory;
import org.geotoolkit.referencing.operation.provider.Affine;
import org.geotoolkit.referencing.operation.transform.AbstractMathTransform;
import org.geotoolkit.referencing.operation.transform.AffineTransform2D;
import org.geotoolkit.referencing.operation.transform.LinearTransform;
import org.geotoolkit.referencing.operation.transform.LinearTransform1D;
import org.geotoolkit.referencing.operation.transform.ProjectiveTransform;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;

public class IdentityTransform
extends AbstractMathTransform
implements LinearTransform,
Serializable {
    private static final long serialVersionUID = -5339040282922138164L;
    private final int dimension;
    private static final LinearTransform[] POOL = new LinearTransform[8];

    protected IdentityTransform(int n) {
        this.dimension = n;
    }

    public static synchronized LinearTransform create(int n) {
        LinearTransform linearTransform;
        if (n < POOL.length && (linearTransform = POOL[n]) != null) {
            return linearTransform;
        }
        switch (n) {
            case 1: {
                linearTransform = LinearTransform1D.IDENTITY;
                break;
            }
            case 2: {
                linearTransform = new AffineTransform2D();
                break;
            }
            default: {
                linearTransform = new IdentityTransform(n);
            }
        }
        if (n < POOL.length) {
            IdentityTransform.POOL[n] = linearTransform;
        }
        return linearTransform;
    }

    @Override
    public boolean isIdentity() {
        return true;
    }

    @Override
    public boolean isIdentity(double d) {
        return true;
    }

    @Override
    public int getSourceDimensions() {
        return this.dimension;
    }

    @Override
    public int getTargetDimensions() {
        return this.dimension;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Affine.PARAMETERS;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return ProjectiveTransform.getParameterValues(this.getMatrix());
    }

    @Override
    public Matrix getMatrix() {
        return MatrixFactory.create(this.dimension + 1);
    }

    @Override
    public Matrix derivative(DirectPosition directPosition) {
        return MatrixFactory.create(this.dimension);
    }

    @Override
    public DirectPosition transform(DirectPosition directPosition, DirectPosition directPosition2) {
        String string;
        int n = directPosition.getDimension();
        if (n != this.dimension) {
            string = "ptSrc";
        } else {
            if (directPosition2 == null) {
                return new GeneralDirectPosition(directPosition);
            }
            n = directPosition2.getDimension();
            if (n != this.dimension) {
                string = "ptDst";
            } else {
                for (int i = 0; i < this.dimension; ++i) {
                    directPosition2.setOrdinate(i, directPosition.getOrdinate(i));
                }
                return directPosition2;
            }
        }
        throw new MismatchedDimensionException(IdentityTransform.constructMessage(string, n, this.dimension));
    }

    @Override
    protected void transform(double[] dArray, int n, double[] dArray2, int n2) {
        System.arraycopy(dArray, n, dArray2, n2, this.dimension);
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        System.arraycopy(dArray, n, dArray2, n2, n3 * this.dimension);
    }

    @Override
    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        System.arraycopy(fArray, n, fArray2, n2, n3 * this.dimension);
    }

    @Override
    public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) {
        n3 *= this.dimension;
        while (--n3 >= 0) {
            fArray[n2++] = (float)dArray[n++];
        }
    }

    @Override
    public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) {
        n3 *= this.dimension;
        while (--n3 >= 0) {
            dArray[n2++] = fArray[n++];
        }
    }

    @Override
    public MathTransform inverse() {
        return this;
    }

    @Override
    public int hashCode() {
        return this.dimension ^ 0x6EECC5CC;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            IdentityTransform identityTransform = (IdentityTransform)object;
            return this.dimension == identityTransform.dimension;
        }
        return false;
    }
}

