/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.transform;

import java.io.Serializable;
import java.util.Arrays;
import org.geotoolkit.parameter.FloatParameter;
import org.geotoolkit.parameter.Parameter;
import org.geotoolkit.parameter.ParameterGroup;
import org.geotoolkit.referencing.operation.matrix.XMatrix;
import org.geotoolkit.referencing.operation.provider.AbridgedMolodensky;
import org.geotoolkit.referencing.operation.provider.Molodensky;
import org.geotoolkit.referencing.operation.transform.AbstractMathTransform;
import org.geotoolkit.referencing.operation.transform.IdentityTransform;
import org.geotoolkit.referencing.operation.transform.IterationStrategy;
import org.geotoolkit.referencing.operation.transform.MolodenskyTransform2D;
import org.geotoolkit.referencing.operation.transform.ProjectiveTransform;
import org.geotoolkit.util.Utilities;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;

public class MolodenskyTransform
extends AbstractMathTransform
implements Serializable {
    private static final long serialVersionUID = 7536566033885338422L;
    private static final double ISIN = 1.0000000000039173;
    private static final float TOLERANCE = 0.002f;
    final boolean abridged;
    private final boolean source3D;
    private final boolean target3D;
    final double dx;
    final double dy;
    final double dz;
    final double a;
    final double b;
    final double da;
    final double db;
    private final double df;
    private final double b_a;
    private final double a_b;
    private final double daa;
    private final double da_a;
    private final double e2;
    private final double adf;
    transient MolodenskyTransform inverse;

    protected MolodenskyTransform(boolean bl, double d, double d2, boolean bl2, double d3, double d4, boolean bl3, double d5, double d6, double d7) {
        this.abridged = bl;
        this.source3D = bl2;
        this.target3D = bl3;
        this.dx = d5;
        this.dy = d6;
        this.dz = d7;
        this.a = d;
        this.b = d2;
        this.da = d3 - d;
        this.db = d4 - d2;
        this.a_b = d / d2;
        this.b_a = d2 / d;
        this.daa = this.da * d;
        this.da_a = this.da / d;
        this.df = (d3 - d4) / d3 - (d - d2) / d;
        this.e2 = 1.0 - d2 * d2 / (d * d);
        this.adf = d * this.df + (d - d2) * this.da / d;
    }

    MolodenskyTransform(MolodenskyTransform molodenskyTransform) {
        this.abridged = molodenskyTransform.abridged;
        this.source3D = molodenskyTransform.target3D;
        this.target3D = molodenskyTransform.source3D;
        this.dx = -molodenskyTransform.dx;
        this.dy = -molodenskyTransform.dy;
        this.dz = -molodenskyTransform.dz;
        this.da = -molodenskyTransform.da;
        this.db = -molodenskyTransform.db;
        this.df = -molodenskyTransform.df;
        this.a = molodenskyTransform.a + molodenskyTransform.da;
        this.b = molodenskyTransform.b + molodenskyTransform.db;
        this.a_b = this.a / this.b;
        this.b_a = this.b / this.a;
        this.daa = this.da * this.a;
        this.da_a = this.da / this.a;
        this.e2 = 1.0 - this.b * this.b / (this.a * this.a);
        this.adf = this.a * this.df + (this.a - this.b) * this.da / this.a;
        this.inverse = molodenskyTransform;
        molodenskyTransform.inverse = this;
    }

    public static MathTransform create(boolean bl, double d, double d2, boolean bl2, double d3, double d4, boolean bl3, double d5, double d6, double d7) {
        MathTransform mathTransform;
        if (d5 == 0.0 && d6 == 0.0 && d7 == 0.0 && d == d3 && d2 == d4) {
            if (bl2 == bl3) {
                mathTransform = IdentityTransform.create(bl3 ? 3 : 2);
            } else {
                XMatrix xMatrix = ProjectiveTransform.createSelectMatrix(3, new int[]{0, 1});
                if (bl3) {
                    xMatrix.transpose();
                }
                mathTransform = ProjectiveTransform.create(xMatrix);
            }
        } else if (!bl2 && !bl3) {
            mathTransform = new MolodenskyTransform2D(bl, d, d2, d3, d4, d5, d6, d7);
            assert (!mathTransform.isIdentity());
        } else {
            mathTransform = new MolodenskyTransform(bl, d, d2, bl2, d3, d4, bl3, d5, d6, d7);
            assert (!mathTransform.isIdentity());
        }
        return mathTransform;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return this.abridged ? AbridgedMolodensky.PARAMETERS : Molodensky.PARAMETERS;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        Parameter<Integer> parameter = new Parameter<Integer>(Molodensky.DIM);
        parameter.setValue(this.getSourceDimensions());
        return new ParameterGroup(this.getParameterDescriptors(), (GeneralParameterValue[])new ParameterValue[]{parameter, new FloatParameter(Molodensky.DX, this.dx), new FloatParameter(Molodensky.DY, this.dy), new FloatParameter(Molodensky.DZ, this.dz), new FloatParameter(Molodensky.SRC_SEMI_MAJOR, this.a), new FloatParameter(Molodensky.SRC_SEMI_MINOR, this.b), new FloatParameter(Molodensky.TGT_SEMI_MAJOR, this.a + this.da), new FloatParameter(Molodensky.TGT_SEMI_MINOR, this.b + this.db)});
    }

    @Override
    public final int getSourceDimensions() {
        return this.source3D ? 3 : 2;
    }

    @Override
    public final int getTargetDimensions() {
        return this.target3D ? 3 : 2;
    }

    @Override
    protected void transform(double[] dArray, int n, double[] dArray2, int n2) {
        this.transform(null, dArray, n, null, dArray2, n2, 1, dArray == dArray2);
        if (!$assertionsDisabled && this.target3D && dArray != dArray2) {
            float f;
            float f2 = this.maxError(null, dArray, n, null, dArray2, n2, 1);
            if (f > 0.002f) {
                throw new AssertionError(f2);
            }
        }
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        this.transform(null, dArray, n, null, dArray2, n2, n3, dArray == dArray2);
        if (!$assertionsDisabled && this.target3D && dArray != dArray2) {
            float f;
            float f2 = this.maxError(null, dArray, n, null, dArray2, n2, n3);
            if (f > 0.002f) {
                throw new AssertionError(f2);
            }
        }
    }

    @Override
    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        this.transform(fArray, null, n, fArray2, null, n2, n3, fArray == fArray2);
        if (!$assertionsDisabled && this.target3D && fArray != fArray2) {
            float f;
            float f2 = this.maxError(fArray, null, n, fArray2, null, n2, n3);
            if (f > 0.002f) {
                throw new AssertionError(f2);
            }
        }
    }

    @Override
    public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) {
        this.transform(null, dArray, n, fArray, null, n2, n3, false);
        if (!$assertionsDisabled && this.target3D) {
            float f;
            float f2 = this.maxError(null, dArray, n, fArray, null, n2, n3);
            if (f > 0.002f) {
                throw new AssertionError(f2);
            }
        }
    }

    @Override
    public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) {
        this.transform(fArray, null, n, null, dArray, n2, n3, false);
        if (!$assertionsDisabled && this.target3D) {
            float f;
            float f2 = this.maxError(fArray, null, n, null, dArray, n2, n3);
            if (f > 0.002f) {
                throw new AssertionError(f2);
            }
        }
    }

    private void transform(float[] fArray, double[] dArray, int n, float[] fArray2, double[] dArray2, int n2, int n3, boolean bl) {
        int n4;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        Object[] objectArray = null;
        if (bl) {
            int n8 = this.getSourceDimensions();
            n4 = this.getTargetDimensions();
            switch (IterationStrategy.suggest(n, n8, n2, n4, n3)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    n += (n3 - 1) * n8;
                    n2 += (n3 - 1) * n4;
                    n5 = 2 * n8;
                    n6 = 2 * n4;
                    break;
                }
                default: {
                    int n9 = n + n3 * n8;
                    if (dArray != null) {
                        dArray = Arrays.copyOfRange(dArray, n, n9);
                    } else {
                        fArray = Arrays.copyOfRange(fArray, n, n9);
                    }
                    n = 0;
                    break;
                }
                case BUFFER_TARGET: {
                    if (dArray2 != null) {
                        objectArray = dArray2;
                        dArray2 = new double[n3 * n4];
                    } else {
                        objectArray = fArray2;
                        fArray2 = new float[n3 * n4];
                    }
                    n7 = n2;
                    n2 = 0;
                }
            }
        }
        while (--n3 >= 0) {
            double d;
            double d2;
            double d3;
            if (dArray != null) {
                d3 = dArray[n++];
                d2 = dArray[n++];
                d = this.source3D ? dArray[n++] : 0.0;
            } else {
                d3 = fArray[n++];
                d2 = fArray[n++];
                d = this.source3D ? (double)fArray[n++] : 0.0;
            }
            d3 = Math.toRadians(d3);
            d2 = Math.toRadians(d2);
            double d4 = Math.sin(d3);
            double d5 = Math.cos(d3);
            double d6 = Math.sin(d2);
            double d7 = Math.cos(d2);
            double d8 = d6 * d6;
            double d9 = this.a / Math.sqrt(1.0 - this.e2 * d8);
            double d10 = d9 * (1.0 - this.e2) / (1.0 - this.e2 * d8);
            if (this.abridged) {
                d2 += 1.0000000000039173 * ((this.dz * d7 - d6 * (this.dy * d4 + this.dx * d5) + this.adf * Math.sin(2.0 * d2)) / d10);
                d3 += 1.0000000000039173 * ((this.dy * d5 - this.dx * d4) / (d9 * d7));
            } else {
                d2 += 1.0000000000039173 * ((this.dz * d7 - d6 * (this.dy * d4 + this.dx * d5) + this.da_a * (d9 * this.e2 * d6 * d7) + this.df * (d10 * this.a_b + d9 * this.b_a) * d6 * d7) / (d10 + d));
                d3 += 1.0000000000039173 * ((this.dy * d5 - this.dx * d4) / ((d9 + d) * d7));
            }
            if (Math.abs(d2) >= 1.5707963267948966) {
                d3 = 0.0;
                d2 = Math.copySign(90.0, d2);
            } else {
                d3 = MolodenskyTransform.rollLongitude(Math.toDegrees(d3), 180.0);
                d2 = Math.toDegrees(d2);
            }
            if (dArray2 != null) {
                dArray2[n2++] = d3;
                dArray2[n2++] = d2;
            } else {
                fArray2[n2++] = (float)d3;
                fArray2[n2++] = (float)d2;
            }
            if (this.target3D) {
                d = this.abridged ? (d += this.dx * d7 * d5 + this.dy * d7 * d4 + this.dz * d6 + this.adf * d8 - this.da) : (d += this.dx * d7 * d5 + this.dy * d7 * d4 + this.dz * d6 + this.df * this.b_a * d9 * d8 - this.daa / d9);
                if (dArray2 != null) {
                    dArray2[n2++] = d;
                } else {
                    fArray2[n2++] = (float)d;
                }
            }
            n -= n5;
            n2 -= n6;
        }
        if (objectArray != null) {
            Object[] objectArray2;
            if (dArray2 != null) {
                objectArray2 = dArray2;
                n4 = dArray2.length;
            } else {
                objectArray2 = fArray2;
                n4 = fArray2.length;
            }
            System.arraycopy(objectArray2, 0, objectArray, n7, n4);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private float maxError(float[] fArray, double[] dArray, int n, float[] fArray2, double[] dArray2, int n2, int n3) {
        float f = 0.0f;
        if (this.inverse == null) {
            this.inverse();
            if (this.inverse == null) {
                return f;
            }
        }
        int n4 = this.getSourceDimensions();
        float[] fArray3 = new float[n3 * n4];
        this.inverse.transform(fArray2, dArray2, n2, fArray3, null, 0, n3, false);
        int n5 = 0;
        while (true) {
            block9: {
                if (n5 >= fArray3.length) {
                    return f;
                }
                float f2 = dArray != null ? (float)dArray[n] : fArray[n];
                float f3 = Math.abs(fArray3[n5] - f2);
                switch (n5 % n4) {
                    case 0: {
                        f3 = (float)((double)f3 - 360.0 * Math.floor(f3 / 360.0f));
                        break;
                    }
                    case 2: {
                        break block9;
                    }
                }
                if (f3 > f) {
                    f = f3;
                }
            }
            ++n5;
            ++n;
        }
    }

    @Override
    public boolean isIdentity() {
        return this.dx == 0.0 && this.dy == 0.0 && this.dz == 0.0 && this.da == 0.0 && this.db == 0.0 && this.source3D == this.target3D;
    }

    @Override
    public MathTransform inverse() {
        if (this.inverse == null) {
            this.inverse = new MolodenskyTransform(this);
        }
        return this.inverse;
    }

    @Override
    public final int hashCode() {
        long l = Double.doubleToLongBits(this.dx) + 31L * (Double.doubleToLongBits(this.dy) + 31L * (Double.doubleToLongBits(this.dz) + 31L * (Double.doubleToLongBits(this.a) + 31L * (Double.doubleToLongBits(this.b) + 31L * (Double.doubleToLongBits(this.da) + 31L * Double.doubleToLongBits(this.db))))));
        int n = (int)l ^ (int)(l >>> 32);
        if (this.abridged) {
            n ^= 1;
        }
        if (this.source3D) {
            n ^= 2;
        }
        if (this.target3D) {
            n ^= 4;
        }
        return n ^ 0x9C029B36;
    }

    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            MolodenskyTransform molodenskyTransform = (MolodenskyTransform)object;
            return this.abridged == molodenskyTransform.abridged && this.source3D == molodenskyTransform.source3D && this.target3D == molodenskyTransform.target3D && Utilities.equals(this.dx, molodenskyTransform.dx) && Utilities.equals(this.dy, molodenskyTransform.dy) && Utilities.equals(this.dz, molodenskyTransform.dz) && Utilities.equals(this.a, molodenskyTransform.a) && Utilities.equals(this.b, molodenskyTransform.b) && Utilities.equals(this.da, molodenskyTransform.da) && Utilities.equals(this.db, molodenskyTransform.db);
        }
        return false;
    }
}

