/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.transform;

import java.io.Serializable;
import java.util.Arrays;
import org.geotoolkit.geometry.GeneralDirectPosition;
import org.geotoolkit.internal.referencing.MatrixUtilities;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.referencing.operation.matrix.GeneralMatrix;
import org.geotoolkit.referencing.operation.transform.AbstractMathTransform;
import org.geotoolkit.referencing.operation.transform.IdentityTransform;
import org.geotoolkit.referencing.operation.transform.IterationStrategy;
import org.geotoolkit.referencing.operation.transform.LinearTransform;
import org.geotoolkit.referencing.operation.transform.PassThroughTransform2D;
import org.geotoolkit.referencing.operation.transform.ProjectiveTransform;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Utilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public class PassThroughTransform
extends AbstractMathTransform
implements Serializable {
    private static final long serialVersionUID = -1673997634240223449L;
    protected final int firstAffectedOrdinate;
    protected final int numTrailingOrdinates;
    protected final MathTransform subTransform;
    PassThroughTransform inverse;

    protected PassThroughTransform(int n, MathTransform mathTransform, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException(Errors.format(63, "firstAffectedOrdinate", n));
        }
        if (n2 < 0) {
            throw new IllegalArgumentException(Errors.format(63, "numTrailingOrdinates", n2));
        }
        if (mathTransform instanceof PassThroughTransform) {
            PassThroughTransform passThroughTransform = (PassThroughTransform)mathTransform;
            this.firstAffectedOrdinate = passThroughTransform.firstAffectedOrdinate + n;
            this.numTrailingOrdinates = passThroughTransform.numTrailingOrdinates + n2;
            this.subTransform = passThroughTransform.subTransform;
        } else {
            this.firstAffectedOrdinate = n;
            this.numTrailingOrdinates = n2;
            this.subTransform = mathTransform;
        }
    }

    public static MathTransform create(int n, MathTransform mathTransform, int n2) {
        int n3;
        if (n < 0) {
            throw new IllegalArgumentException(Errors.format(63, "firstAffectedOrdinate", n));
        }
        if (n2 < 0) {
            throw new IllegalArgumentException(Errors.format(63, "numTrailingOrdinates", n2));
        }
        if (n == 0 && n2 == 0) {
            return mathTransform;
        }
        if (mathTransform.isIdentity() && (n3 = mathTransform.getSourceDimensions()) == mathTransform.getTargetDimensions()) {
            return IdentityTransform.create(n + n3 + n2);
        }
        if (mathTransform instanceof LinearTransform) {
            GeneralMatrix generalMatrix = MatrixUtilities.toGeneralMatrix(((LinearTransform)mathTransform).getMatrix());
            generalMatrix = PassThroughTransform.expand(generalMatrix, n, n2, 1);
            return ProjectiveTransform.create(generalMatrix);
        }
        n3 = mathTransform.getSourceDimensions();
        if (mathTransform.getTargetDimensions() == n3 && (n3 += n + n2) == 2) {
            return new PassThroughTransform2D(n, mathTransform, n2);
        }
        return new PassThroughTransform(n, mathTransform, n2);
    }

    public final MathTransform getSubTransform() {
        return this.subTransform;
    }

    public final int[] getModifiedCoordinates() {
        int[] nArray = new int[this.subTransform.getSourceDimensions()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i + this.firstAffectedOrdinate;
        }
        return nArray;
    }

    @Override
    public final int getSourceDimensions() {
        return this.firstAffectedOrdinate + this.subTransform.getSourceDimensions() + this.numTrailingOrdinates;
    }

    @Override
    public final int getTargetDimensions() {
        return this.firstAffectedOrdinate + this.subTransform.getTargetDimensions() + this.numTrailingOrdinates;
    }

    @Override
    public boolean isIdentity() {
        return this.subTransform.isIdentity();
    }

    @Override
    protected void transform(double[] dArray, int n, double[] dArray2, int n2) throws TransformException {
        this.transform(dArray, n, dArray2, n2, 1);
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
        int n4 = this.subTransform.getSourceDimensions();
        int n5 = this.subTransform.getTargetDimensions();
        int n6 = this.numTrailingOrdinates;
        int n7 = this.numTrailingOrdinates;
        if (dArray == dArray2) {
            int n8 = this.firstAffectedOrdinate + this.numTrailingOrdinates;
            int n9 = n4 + n8;
            int n10 = n5 + n8;
            switch (IterationStrategy.suggest(n, n9, n2, n10, n3)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    n += (n3 - 1) * n9;
                    n2 += (n3 - 1) * n10;
                    n6 -= 2 * n9;
                    n7 -= 2 * n10;
                    break;
                }
                default: {
                    dArray = Arrays.copyOfRange(dArray, n, n + n3 * n9);
                    n = 0;
                }
            }
        }
        while (--n3 >= 0) {
            System.arraycopy(dArray, n, dArray2, n2, this.firstAffectedOrdinate);
            this.subTransform.transform(dArray, n += this.firstAffectedOrdinate, dArray2, n2 += this.firstAffectedOrdinate, 1);
            System.arraycopy(dArray, n += n4, dArray2, n2 += n5, this.numTrailingOrdinates);
            n += n6;
            n2 += n7;
        }
    }

    @Override
    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) throws TransformException {
        int n4 = this.subTransform.getSourceDimensions();
        int n5 = this.subTransform.getTargetDimensions();
        int n6 = this.numTrailingOrdinates;
        int n7 = this.numTrailingOrdinates;
        if (fArray == fArray2) {
            int n8 = this.firstAffectedOrdinate + this.numTrailingOrdinates;
            int n9 = n4 + n8;
            int n10 = n5 + n8;
            switch (IterationStrategy.suggest(n, n9, n2, n10, n3)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    n += (n3 - 1) * n9;
                    n2 += (n3 - 1) * n10;
                    n6 -= 2 * n9;
                    n7 -= 2 * n10;
                    break;
                }
                default: {
                    fArray = Arrays.copyOfRange(fArray, n, n + n3 * n9);
                    n = 0;
                }
            }
        }
        while (--n3 >= 0) {
            System.arraycopy(fArray, n, fArray2, n2, this.firstAffectedOrdinate);
            this.subTransform.transform(fArray, n += this.firstAffectedOrdinate, fArray2, n2 += this.firstAffectedOrdinate, 1);
            System.arraycopy(fArray, n += n4, fArray2, n2 += n5, this.numTrailingOrdinates);
            n += n6;
            n2 += n7;
        }
    }

    @Override
    public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) throws TransformException {
        int n4 = this.subTransform.getSourceDimensions();
        int n5 = this.subTransform.getTargetDimensions();
        while (--n3 >= 0) {
            int n6;
            for (n6 = 0; n6 < this.firstAffectedOrdinate; ++n6) {
                fArray[n2++] = (float)dArray[n++];
            }
            this.subTransform.transform(dArray, n, fArray, n2, 1);
            n += n4;
            n2 += n5;
            for (n6 = 0; n6 < this.numTrailingOrdinates; ++n6) {
                fArray[n2++] = (float)dArray[n++];
            }
        }
    }

    @Override
    public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) throws TransformException {
        int n4 = this.subTransform.getSourceDimensions();
        int n5 = this.subTransform.getTargetDimensions();
        while (--n3 >= 0) {
            int n6;
            for (n6 = 0; n6 < this.firstAffectedOrdinate; ++n6) {
                dArray[n2++] = fArray[n++];
            }
            this.subTransform.transform(fArray, n, dArray, n2, 1);
            n += n4;
            n2 += n5;
            for (n6 = 0; n6 < this.numTrailingOrdinates; ++n6) {
                dArray[n2++] = fArray[n++];
            }
        }
    }

    @Override
    public Matrix derivative(DirectPosition directPosition) throws TransformException {
        int n = this.firstAffectedOrdinate + this.numTrailingOrdinates;
        int n2 = this.subTransform.getSourceDimensions();
        int n3 = directPosition.getDimension();
        if (n3 != n2 + n) {
            throw new MismatchedDimensionException(Errors.format(101, "point", n3, n2 + n));
        }
        GeneralDirectPosition generalDirectPosition = new GeneralDirectPosition(n2);
        for (int i = 0; i < n2; ++i) {
            generalDirectPosition.ordinates[i] = directPosition.getOrdinate(i + this.firstAffectedOrdinate);
        }
        return PassThroughTransform.expand(MatrixUtilities.toGeneralMatrix(this.subTransform.derivative(generalDirectPosition)), this.firstAffectedOrdinate, this.numTrailingOrdinates, 0);
    }

    private static GeneralMatrix expand(GeneralMatrix generalMatrix, int n, int n2, int n3) {
        int n4;
        int n5 = n + n2;
        int n6 = generalMatrix.getNumRow() - n3;
        int n7 = generalMatrix.getNumCol() - n3;
        GeneralMatrix generalMatrix2 = new GeneralMatrix(n6 + (n5 + n3), n7 + (n5 + n3));
        generalMatrix2.setZero();
        for (n4 = 0; n4 < n; ++n4) {
            generalMatrix2.setElement(n4, n4, 1.0);
        }
        generalMatrix.copySubMatrix(0, 0, n6, n7, n, n, generalMatrix2);
        n4 = n7 - n6;
        int n8 = n6 + n5;
        for (int i = n8 - n2; i < n8; ++i) {
            generalMatrix2.setElement(i, i + n4, 1.0);
        }
        if (n3 != 0) {
            generalMatrix.copySubMatrix(0, n7, n6, n3, n, n7 + n5, generalMatrix2);
            generalMatrix.copySubMatrix(n6, 0, n3, n7, n6 + n5, n, generalMatrix2);
            generalMatrix.copySubMatrix(n6, n7, n3, n3, n6 + n5, n7 + n5, generalMatrix2);
        }
        return generalMatrix2;
    }

    @Override
    public synchronized MathTransform inverse() throws NoninvertibleTransformException {
        if (this.inverse == null) {
            this.inverse = new PassThroughTransform(this.firstAffectedOrdinate, this.subTransform.inverse(), this.numTrailingOrdinates);
            this.inverse.inverse = this;
        }
        return this.inverse;
    }

    @Override
    public int hashCode() {
        int n = this.firstAffectedOrdinate + 31 * this.numTrailingOrdinates ^ 0x58446727;
        if (this.subTransform != null) {
            n = n * 31 + this.subTransform.hashCode();
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            PassThroughTransform passThroughTransform = (PassThroughTransform)object;
            return this.firstAffectedOrdinate == passThroughTransform.firstAffectedOrdinate && this.numTrailingOrdinates == passThroughTransform.numTrailingOrdinates && Utilities.equals(this.subTransform, passThroughTransform.subTransform);
        }
        return false;
    }

    @Override
    public String formatWKT(Formatter formatter) {
        formatter.append(this.firstAffectedOrdinate);
        if (this.numTrailingOrdinates != 0) {
            formatter.append(this.numTrailingOrdinates);
            formatter.setInvalidWKT(PassThroughTransform.class);
        }
        formatter.append(this.subTransform);
        return "PASSTHROUGH_MT";
    }
}

