/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.resources;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

final class Loader
extends ResourceBundle.Control {
    private static final String EXTENSION = "utf";
    private static final List<String> FORMATS = Collections.singletonList("geotoolkit.utf");
    public static final Loader INSTANCE = new Loader();

    private Loader() {
    }

    @Override
    public List<String> getFormats(String string) {
        return FORMATS;
    }

    @Override
    public boolean needsReload(String string, Locale locale, String string2, ClassLoader classLoader, ResourceBundle resourceBundle, long l) {
        return false;
    }

    @Override
    public ResourceBundle newBundle(String string, Locale locale, String string2, ClassLoader classLoader, boolean bl) throws IllegalAccessException, InstantiationException, IOException {
        ResourceBundle resourceBundle;
        Constructor<?> constructor;
        Class<?> clazz;
        try {
            clazz = Class.forName(string, true, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        String string3 = this.toResourceName(this.toBundleName(clazz.getSimpleName(), locale), EXTENSION);
        if (clazz.getResource(string3) == null) {
            if (!Locale.ENGLISH.equals(locale)) {
                return null;
            }
            string3 = this.toResourceName(clazz.getSimpleName(), EXTENSION);
            if (clazz.getResource(string3) == null) {
                return null;
            }
        }
        try {
            constructor = clazz.getDeclaredConstructor(String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw Loader.instantiationFailure(noSuchMethodException);
        }
        try {
            resourceBundle = (ResourceBundle)constructor.newInstance(string3);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw Loader.instantiationFailure(invocationTargetException);
        }
        return resourceBundle;
    }

    private static InstantiationException instantiationFailure(Exception exception) {
        InstantiationException instantiationException = new InstantiationException(exception.getLocalizedMessage());
        instantiationException.initCause(exception);
        return instantiationException;
    }
}

