/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util;

import java.util.Date;
import javax.measure.converter.ConversionException;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Duration;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.MeasurementRange;
import org.geotoolkit.util.Range;

public class DateRange
extends Range<Date> {
    private static final long serialVersionUID = -6400011350250757942L;
    private static final Unit<Duration> MILLISECOND = SI.MILLI(SI.SECOND);

    public DateRange(Date date, Date date2) {
        super(Date.class, DateRange.clone(date), DateRange.clone(date2));
    }

    public DateRange(Date date, boolean bl, Date date2, boolean bl2) {
        super(Date.class, DateRange.clone(date), bl, DateRange.clone(date2), bl2);
    }

    public DateRange(MeasurementRange<?> measurementRange, Date date) throws ConversionException {
        this(measurementRange, DateRange.getConverter(measurementRange.getUnits()), date.getTime());
    }

    private DateRange(MeasurementRange<?> measurementRange, UnitConverter unitConverter, long l) throws ConversionException {
        super(Date.class, new Date(l + Math.round(unitConverter.convert(measurementRange.getMinimum()))), measurementRange.isMinIncluded(), new Date(l + Math.round(unitConverter.convert(measurementRange.getMaximum()))), measurementRange.isMaxIncluded());
    }

    @Override
    void checkElementClass() throws IllegalArgumentException {
        if (!Date.class.isAssignableFrom(this.elementClass)) {
            throw new IllegalArgumentException(Errors.format(66, this.elementClass, Date.class));
        }
    }

    private static Date clone(Date date) {
        return date != null ? (Date)date.clone() : null;
    }

    private static UnitConverter getConverter(Unit<?> unit) throws ConversionException {
        if (unit == null) {
            throw new ConversionException(Errors.format(151));
        }
        return unit.getConverterTo(MILLISECOND);
    }

    @Override
    public Date getMinValue() {
        return DateRange.clone((Date)super.getMinValue());
    }

    @Override
    public Date getMaxValue() {
        return DateRange.clone((Date)super.getMaxValue());
    }
}

