/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Locales;
import org.geotoolkit.util.AbstractInternationalString;
import org.geotoolkit.util.Utilities;
import org.opengis.util.InternationalString;

public class DefaultInternationalString
extends AbstractInternationalString
implements Serializable {
    private static final long serialVersionUID = 5760033376627376937L;
    private Map<Locale, String> localMap;
    private transient Set<Locale> localSet;

    public DefaultInternationalString() {
        this.localMap = Collections.emptyMap();
    }

    public DefaultInternationalString(String string) {
        this.localMap = string != null ? Collections.singletonMap(null, string) : Collections.emptyMap();
    }

    public DefaultInternationalString(Map<Locale, String> map) {
        if (map == null || map.isEmpty()) {
            this.localMap = Collections.emptyMap();
        } else {
            Iterator<Map.Entry<Locale, String>> iterator = map.entrySet().iterator();
            Map.Entry<Locale, String> entry = iterator.next();
            this.localMap = !iterator.hasNext() ? Collections.singletonMap(entry.getKey(), entry.getValue()) : new HashMap<Locale, String>(map);
        }
    }

    public synchronized void add(Locale locale, String string) throws IllegalArgumentException {
        if (string != null) {
            switch (this.localMap.size()) {
                case 0: {
                    this.localMap = Collections.singletonMap(locale, string);
                    this.defaultValue = null;
                    return;
                }
                case 1: {
                    this.localMap = new HashMap<Locale, String>(this.localMap);
                }
            }
            String string2 = this.localMap.get(locale);
            if (string2 != null) {
                if (string.equals(string2)) {
                    return;
                }
                throw new IllegalArgumentException(Errors.format(214, locale));
            }
            this.localMap.put(locale, string);
            this.defaultValue = null;
        }
    }

    public boolean add(String string, String string2, String string3) throws IllegalArgumentException {
        if (string2.startsWith(string)) {
            Locale locale = null;
            int n = string.length();
            if (string2.length() != n) {
                if (string2.charAt(n) == '_') {
                    locale = Locales.parse(string2.substring(n + 1));
                } else {
                    return false;
                }
            }
            this.add(locale, string3);
            return true;
        }
        return false;
    }

    public synchronized Set<Locale> getLocales() {
        if (this.localSet == null) {
            this.localSet = Collections.unmodifiableSet(this.localMap.keySet());
        }
        return this.localSet;
    }

    private String getString(Locale locale) {
        while (locale != null) {
            String string = this.localMap.get(locale);
            if (string != null) {
                return string;
            }
            String string2 = locale.getLanguage();
            String string3 = locale.getCountry();
            String string4 = locale.getVariant();
            if (string4.length() != 0) {
                locale = new Locale(string2, string3);
                continue;
            }
            if (string3.length() == 0) break;
            locale = new Locale(string2);
        }
        return null;
    }

    @Override
    public synchronized String toString(Locale locale) {
        String string = this.getString(locale);
        if (string == null && (string = this.localMap.get(null)) == null) {
            Locale locale2 = Locale.US;
            if (locale != locale2 && (string = this.getString(locale2)) != null) {
                return string;
            }
            locale2 = Locale.getDefault();
            if (locale != locale2 && locale2 != Locale.US && (string = this.getString(locale2)) != null) {
                return string;
            }
            Iterator<String> iterator = this.localMap.values().iterator();
            if (iterator.hasNext()) {
                string = iterator.next();
            }
        }
        return string;
    }

    public synchronized boolean isSubsetOf(Object object) {
        if (object instanceof InternationalString) {
            InternationalString internationalString = (InternationalString)object;
            for (Map.Entry<Locale, String> entry : this.localMap.entrySet()) {
                Locale locale = entry.getKey();
                String string = entry.getValue();
                if (string.equals(internationalString.toString(locale))) continue;
                return false;
            }
        } else if (object instanceof CharSequence) {
            String string = object.toString();
            for (String string2 : this.localMap.values()) {
                if (string2.equals(string)) continue;
                return false;
            }
        } else {
            if (object instanceof Map) {
                Map map = (Map)object;
                return map.entrySet().containsAll(this.localMap.entrySet());
            }
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            DefaultInternationalString defaultInternationalString = (DefaultInternationalString)object;
            return Utilities.equals(this.localMap, defaultInternationalString.localMap);
        }
        return false;
    }

    public int hashCode() {
        return 0x8C44C329 ^ ((Object)this.localMap).hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = this.localMap.size();
        if (n == 0) {
            return;
        }
        Map.Entry[] entryArray = new Map.Entry[n];
        entryArray = this.localMap.entrySet().toArray(entryArray);
        if (n == 1) {
            Map.Entry entry = entryArray[0];
            this.localMap = Collections.singletonMap(Locales.unique((Locale)entry.getKey()), entry.getValue());
        } else {
            this.localMap.clear();
            for (int i = 0; i < entryArray.length; ++i) {
                Map.Entry entry = entryArray[i];
                this.localMap.put(Locales.unique((Locale)entry.getKey()), (String)entry.getValue());
            }
        }
    }
}

