/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util;

import javax.measure.converter.ConversionException;
import javax.measure.converter.UnitConverter;
import javax.measure.unit.Unit;
import org.geotoolkit.util.NumberRange;
import org.geotoolkit.util.Range;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.converter.Classes;

public class MeasurementRange<T extends Number>
extends NumberRange<T> {
    private static final long serialVersionUID = 3980319420337513745L;
    private final Unit<?> units;

    public static MeasurementRange<Float> create(float f, float f2, Unit<?> unit) {
        return MeasurementRange.create(f, true, f2, true, unit);
    }

    public static MeasurementRange<Float> create(float f, boolean bl, float f2, boolean bl2, Unit<?> unit) {
        return new MeasurementRange<Float>(Float.class, Float.valueOf(f), bl, Float.valueOf(f2), bl2, unit);
    }

    public static MeasurementRange<Double> create(double d, double d2, Unit<?> unit) {
        return MeasurementRange.create(d, true, d2, true, unit);
    }

    public static MeasurementRange<Double> create(double d, boolean bl, double d2, boolean bl2, Unit<?> unit) {
        return new MeasurementRange<Double>(Double.class, d, bl, d2, bl2, unit);
    }

    public MeasurementRange(Class<T> clazz, T t, boolean bl, T t2, boolean bl2, Unit<?> unit) {
        super(clazz, t, bl, t2, bl2);
        this.units = unit;
    }

    public MeasurementRange(Range<T> range, Unit<?> unit) {
        super(range);
        this.units = unit;
    }

    private MeasurementRange(Class<T> clazz, Range<? extends Number> range, Unit<?> unit) {
        super(clazz, range);
        this.units = unit;
    }

    @Override
    MeasurementRange<T> create(T t, boolean bl, T t2, boolean bl2) {
        return new MeasurementRange<T>(this.elementClass, t, bl, t2, bl2, this.units);
    }

    @Override
    public Unit<?> getUnits() {
        return this.units;
    }

    public MeasurementRange<T> convertTo(Unit<?> unit) throws ConversionException {
        return this.convertAndCast(this.elementClass, unit);
    }

    @Override
    public <N extends Number> MeasurementRange<N> castTo(Class<N> clazz) {
        return this.convertAndCast((Range)this, (Class)clazz);
    }

    @Override
    <N extends Number> MeasurementRange<N> convertAndCast(Range<? extends Number> range, Class<N> clazz) throws IllegalArgumentException {
        if (range instanceof MeasurementRange) {
            MeasurementRange measurementRange = (MeasurementRange)range;
            return measurementRange.convertAndCast(clazz, this.units);
        }
        return new MeasurementRange<N>(clazz, range, this.units);
    }

    private <N extends Number> MeasurementRange<N> convertAndCast(Class<N> clazz, Unit<?> unit) throws ConversionException {
        Double d;
        if (unit == null || unit.equals(this.units)) {
            if (clazz.equals(this.elementClass)) {
                MeasurementRange measurementRange = this;
                return measurementRange;
            }
            return new MeasurementRange<N>(clazz, this, this.units);
        }
        if (this.units == null) {
            return new MeasurementRange<N>(clazz, this, unit);
        }
        UnitConverter unitConverter = this.units.getConverterTo(unit);
        if (unitConverter.equals(UnitConverter.IDENTITY)) {
            return new MeasurementRange<N>(clazz, this, unit);
        }
        boolean bl = this.isMinIncluded();
        boolean bl2 = this.isMaxIncluded();
        Double d2 = unitConverter.convert(this.getMinimum());
        if (d2.compareTo(d = Double.valueOf(unitConverter.convert(this.getMaximum()))) > 0) {
            Double d3 = d2;
            d2 = d;
            d = d3;
            boolean bl3 = bl;
            bl = bl2;
            bl2 = bl3;
        }
        return new MeasurementRange<N>(clazz, Classes.cast(d2, clazz), bl, Classes.cast(d, clazz), bl2, unit);
    }

    MeasurementRange<T>[] newArray(int n) {
        return new MeasurementRange[n];
    }

    @Override
    public MeasurementRange<?> union(Range<?> range) {
        return (MeasurementRange)super.union((Range)range);
    }

    @Override
    public MeasurementRange<?> intersect(Range<?> range) {
        return (MeasurementRange)super.intersect((Range)range);
    }

    public MeasurementRange<?>[] subtract(Range<?> range) {
        return (MeasurementRange[])super.subtract(range);
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            if (object instanceof MeasurementRange) {
                MeasurementRange measurementRange = (MeasurementRange)object;
                return Utilities.equals(this.units, measurementRange.units);
            }
            return true;
        }
        return false;
    }
}

