/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util;

import org.geotoolkit.lang.ValueRange;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Range;
import org.geotoolkit.util.converter.Classes;

public class NumberRange<T extends Number>
extends Range<T> {
    private static final long serialVersionUID = -818167965963008231L;

    public static NumberRange<Byte> create(byte by, byte by2) {
        return NumberRange.create(by, true, by2, true);
    }

    public static NumberRange<Byte> create(byte by, boolean bl, byte by2, boolean bl2) {
        return new NumberRange<Byte>(Byte.class, by, bl, by2, bl2);
    }

    public static NumberRange<Short> create(short s, short s2) {
        return NumberRange.create(s, true, s2, true);
    }

    public static NumberRange<Short> create(short s, boolean bl, short s2, boolean bl2) {
        return new NumberRange<Short>(Short.class, s, bl, s2, bl2);
    }

    public static NumberRange<Integer> create(int n, int n2) {
        return NumberRange.create(n, true, n2, true);
    }

    public static NumberRange<Integer> create(int n, boolean bl, int n2, boolean bl2) {
        return new NumberRange<Integer>(Integer.class, n, bl, n2, bl2);
    }

    public static NumberRange<Long> create(long l, long l2) {
        return NumberRange.create(l, true, l2, true);
    }

    public static NumberRange<Long> create(long l, boolean bl, long l2, boolean bl2) {
        return new NumberRange<Long>(Long.class, l, bl, l2, bl2);
    }

    public static NumberRange<Float> create(float f, float f2) {
        return NumberRange.create(f, true, f2, true);
    }

    public static NumberRange<Float> create(float f, boolean bl, float f2, boolean bl2) {
        return new NumberRange<Float>(Float.class, Float.valueOf(f), bl, Float.valueOf(f2), bl2);
    }

    public static NumberRange<Double> create(double d, double d2) {
        return NumberRange.create(d, true, d2, true);
    }

    public static NumberRange<Double> create(double d, boolean bl, double d2, boolean bl2) {
        return new NumberRange<Double>(Double.class, d, bl, d2, bl2);
    }

    public NumberRange(Class<T> clazz, T t, T t2) {
        super(clazz, (Comparable)t, (Comparable)t2);
    }

    public NumberRange(Class<T> clazz, T t, boolean bl, T t2, boolean bl2) {
        super(clazz, (Comparable)t, bl, (Comparable)t2, bl2);
    }

    public NumberRange(Class<T> clazz, ValueRange valueRange) {
        super(clazz, (Comparable)Classes.cast(NumberRange.valueOf(valueRange.minimum(), Double.NEGATIVE_INFINITY), clazz), valueRange.isMinIncluded(), (Comparable)Classes.cast(NumberRange.valueOf(valueRange.maximum(), Double.POSITIVE_INFINITY), clazz), valueRange.isMaxIncluded());
    }

    NumberRange(Class<T> clazz, Range<? extends Number> range) throws IllegalArgumentException {
        this(clazz, Classes.cast(range.getMinValue(), clazz), range.isMinIncluded(), Classes.cast(range.getMaxValue(), clazz), range.isMaxIncluded());
    }

    public NumberRange(Range<T> range) {
        super(range.getElementClass(), range.getMinValue(), range.isMinIncluded(), range.getMaxValue(), range.isMaxIncluded());
    }

    @Override
    NumberRange<T> create(T t, boolean bl, T t2, boolean bl2) {
        return new NumberRange<T>(this.elementClass, t, bl, t2, bl2);
    }

    private static Double valueOf(double d, double d2) {
        return d != d2 ? Double.valueOf(d) : null;
    }

    @Override
    void checkElementClass() throws IllegalArgumentException {
        NumberRange.ensureNumberClass(this.elementClass);
    }

    private static Class<? extends Number> getElementClass(Range<?> range) {
        NumberRange.ensureNonNull("range", range);
        Class clazz = range.elementClass;
        NumberRange.ensureNumberClass(clazz);
        Class clazz2 = clazz;
        return clazz2;
    }

    private static void ensureNumberClass(Class<?> clazz) throws IllegalArgumentException {
        if (!Number.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(Errors.format(66, clazz, Number.class));
        }
    }

    public static <N extends Number> NumberRange<N> wrap(Range<N> range) {
        if (range instanceof NumberRange) {
            NumberRange numberRange = (NumberRange)range;
            return numberRange;
        }
        return new NumberRange<N>(range);
    }

    <N extends Number> NumberRange<N> convertAndCast(Range<? extends Number> range, Class<N> clazz) throws IllegalArgumentException {
        if (clazz.equals(range.getElementClass())) {
            NumberRange<? extends Number> numberRange = NumberRange.wrap(range);
            return numberRange;
        }
        return new NumberRange<N>(clazz, range);
    }

    public <N extends Number> NumberRange<N> castTo(Class<N> clazz) throws IllegalArgumentException {
        return this.convertAndCast(this, clazz);
    }

    NumberRange<T>[] newArray(int n) {
        return new NumberRange[n];
    }

    public boolean contains(Number number) throws IllegalArgumentException {
        if (number != null && !(number instanceof Comparable)) {
            throw new IllegalArgumentException(Errors.format(132, number.getClass()));
        }
        return this.contains((Comparable)((Object)number));
    }

    @Override
    public boolean contains(Comparable<?> comparable) throws IllegalArgumentException {
        if (comparable == null) {
            return false;
        }
        NumberRange.ensureNumberClass(comparable.getClass());
        Number number = (Number)((Object)comparable);
        Class<? extends Number> clazz = Classes.widestClass(this.elementClass, number.getClass());
        number = Classes.cast(number, clazz);
        boolean bl = this.castTo(clazz).containsNC((Number)((Object)((Comparable)((Object)number))));
        return bl;
    }

    @Override
    public boolean contains(Range<?> range) {
        Class<? extends Number> clazz = Classes.widestClass(this.elementClass, NumberRange.getElementClass(range));
        range = this.convertAndCast(range, clazz);
        return this.castTo(clazz).containsNC(range);
    }

    @Override
    public boolean intersects(Range<?> range) {
        Class<? extends Number> clazz = Classes.widestClass(this.elementClass, NumberRange.getElementClass(range));
        range = this.convertAndCast(range, clazz);
        return this.castTo(clazz).intersectsNC(range);
    }

    @Override
    public NumberRange<?> union(Range<?> range) {
        Class<? extends Number> clazz = Classes.widestClass(this.elementClass, NumberRange.getElementClass(range));
        range = this.convertAndCast(range, clazz);
        return (NumberRange)this.castTo(clazz).unionNC(range);
    }

    @Override
    public NumberRange<?> intersect(Range<?> range) {
        Class<Number> clazz = NumberRange.getElementClass(range);
        Class<? extends Number> clazz2 = Classes.widestClass(this.elementClass, clazz);
        range = this.castTo(clazz2).intersectNC(this.convertAndCast(range, clazz2));
        clazz2 = Classes.finestClass(this.elementClass, clazz);
        if (range.minValue != null) {
            clazz2 = Classes.widestClass(clazz2, Classes.finestClass(((Number)range.minValue).doubleValue()));
        }
        if (range.maxValue != null) {
            clazz2 = Classes.widestClass(clazz2, Classes.finestClass(((Number)range.maxValue).doubleValue()));
        }
        return this.convertAndCast(range, clazz2);
    }

    public NumberRange<?>[] subtract(Range<?> range) {
        Class<? extends Number> clazz = Classes.widestClass(this.elementClass, NumberRange.getElementClass(range));
        return (NumberRange[])this.castTo(clazz).subtractNC(this.convertAndCast(range, clazz));
    }

    public double getMinimum() {
        Number number = (Number)this.getMinValue();
        return number != null ? number.doubleValue() : Double.NEGATIVE_INFINITY;
    }

    public double getMinimum(boolean bl) {
        double d = this.getMinimum();
        if (bl != this.isMinIncluded()) {
            d = NumberRange.next(this.getElementClass(), d, bl);
        }
        return d;
    }

    public double getMaximum() {
        Number number = (Number)this.getMaxValue();
        return number != null ? number.doubleValue() : Double.POSITIVE_INFINITY;
    }

    public double getMaximum(boolean bl) {
        double d = this.getMaximum();
        if (bl != this.isMaxIncluded()) {
            d = NumberRange.next(this.getElementClass(), d, !bl);
        }
        return d;
    }

    private static double next(Class<?> clazz, double d, boolean bl) {
        if (!bl) {
            d = -d;
        }
        if (Classes.isInteger(clazz)) {
            d += 1.0;
        } else if (clazz.equals(Float.class)) {
            d = Math.nextUp((float)d);
        } else if (clazz.equals(Double.class)) {
            d = Math.nextUp(d);
        } else {
            throw new IllegalStateException(Errors.format(198, clazz));
        }
        if (!bl) {
            d = -d;
        }
        return d;
    }
}

