/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;

public final class Utilities {
    private static final String[] spaces = new String[21];
    private static final int PRIME_NUMBER = 31;
    private static final Queue EMPTY_QUEUE;

    private Utilities() {
    }

    public static boolean equals(boolean bl, boolean bl2) {
        return bl == bl2;
    }

    public static boolean equals(char c, char c2) {
        return c == c2;
    }

    public static boolean equals(byte by, byte by2) {
        return by == by2;
    }

    public static boolean equals(short s, short s2) {
        return s == s2;
    }

    public static boolean equals(int n, int n2) {
        return n == n2;
    }

    public static boolean equals(long l, long l2) {
        return l == l2;
    }

    public static boolean equals(float f, float f2) {
        return Float.floatToIntBits(f) == Float.floatToIntBits(f2);
    }

    public static boolean equals(double d, double d2) {
        return Double.doubleToLongBits(d) == Double.doubleToLongBits(d2);
    }

    public static boolean equals(Object object, Object object2) throws AssertionError {
        assert (object == null || !object.getClass().isArray()) : object;
        assert (object2 == null || !object2.getClass().isArray()) : object2;
        return object == object2 || object != null && object.equals(object2);
    }

    public static boolean deepEquals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (object instanceof Object[]) {
            return object2 instanceof Object[] && Arrays.deepEquals((Object[])object, (Object[])object2);
        }
        if (object instanceof double[]) {
            return object2 instanceof double[] && Arrays.equals((double[])object, (double[])object2);
        }
        if (object instanceof float[]) {
            return object2 instanceof float[] && Arrays.equals((float[])object, (float[])object2);
        }
        if (object instanceof long[]) {
            return object2 instanceof long[] && Arrays.equals((long[])object, (long[])object2);
        }
        if (object instanceof int[]) {
            return object2 instanceof int[] && Arrays.equals((int[])object, (int[])object2);
        }
        if (object instanceof short[]) {
            return object2 instanceof short[] && Arrays.equals((short[])object, (short[])object2);
        }
        if (object instanceof byte[]) {
            return object2 instanceof byte[] && Arrays.equals((byte[])object, (byte[])object2);
        }
        if (object instanceof char[]) {
            return object2 instanceof char[] && Arrays.equals((char[])object, (char[])object2);
        }
        if (object instanceof boolean[]) {
            return object2 instanceof boolean[] && Arrays.equals((boolean[])object, (boolean[])object2);
        }
        return object.equals(object2);
    }

    public static int hash(boolean bl, int n) {
        return n * 31 + (bl ? 1231 : 1237);
    }

    public static int hash(char c, int n) {
        return n * 31 + c;
    }

    public static int hash(int n, int n2) {
        return n2 * 31 + n;
    }

    public static int hash(long l, int n) {
        return n * 31 + ((int)l ^ (int)(l >>> 32));
    }

    public static int hash(float f, int n) {
        return n * 31 + Float.floatToIntBits(f);
    }

    public static int hash(double d, int n) {
        return Utilities.hash(Double.doubleToLongBits(d), n);
    }

    public static int hash(Object object, int n) throws AssertionError {
        n *= 31;
        if (object != null) {
            assert (!object.getClass().isArray()) : object;
            n += object.hashCode();
        }
        return n;
    }

    public static int deepHashCode(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Object[]) {
            return Arrays.deepHashCode((Object[])object);
        }
        if (object instanceof double[]) {
            return Arrays.hashCode((double[])object);
        }
        if (object instanceof float[]) {
            return Arrays.hashCode((float[])object);
        }
        if (object instanceof long[]) {
            return Arrays.hashCode((long[])object);
        }
        if (object instanceof int[]) {
            return Arrays.hashCode((int[])object);
        }
        if (object instanceof short[]) {
            return Arrays.hashCode((short[])object);
        }
        if (object instanceof byte[]) {
            return Arrays.hashCode((byte[])object);
        }
        if (object instanceof char[]) {
            return Arrays.hashCode((char[])object);
        }
        if (object instanceof boolean[]) {
            return Arrays.hashCode((boolean[])object);
        }
        return object.hashCode();
    }

    public static String deepToString(Object object) {
        if (object instanceof Object[]) {
            return Arrays.deepToString((Object[])object);
        }
        if (object instanceof double[]) {
            return Arrays.toString((double[])object);
        }
        if (object instanceof float[]) {
            return Arrays.toString((float[])object);
        }
        if (object instanceof long[]) {
            return Arrays.toString((long[])object);
        }
        if (object instanceof int[]) {
            return Arrays.toString((int[])object);
        }
        if (object instanceof short[]) {
            return Arrays.toString((short[])object);
        }
        if (object instanceof byte[]) {
            return Arrays.toString((byte[])object);
        }
        if (object instanceof char[]) {
            return Arrays.toString((char[])object);
        }
        if (object instanceof boolean[]) {
            return Arrays.toString((boolean[])object);
        }
        return String.valueOf(object);
    }

    public static <E> Queue<E> emptyQueue() {
        return EMPTY_QUEUE;
    }

    public static int hashMapCapacity(int n) {
        int n2 = n >>> 2;
        if (n != n2 << 2) {
            ++n;
        }
        return n + n2;
    }

    public static String trim(String string) {
        if (string != null) {
            int n;
            int n2;
            for (n2 = string.length(); n2 != 0 && Character.isWhitespace(string.charAt(n2 - 1)); --n2) {
            }
            for (n = 0; n < n2 && Character.isWhitespace(string.charAt(n)); ++n) {
            }
            string = string.substring(n, n2);
        }
        return string;
    }

    public static String spaces(int n) {
        String string;
        if (n < 0) {
            n = 0;
        }
        if (n < spaces.length) {
            string = spaces[n];
            if (string == null) {
                Utilities.spaces[n] = string = spaces[spaces.length - 1].substring(0, n).intern();
            }
        } else {
            char[] cArray = new char[n];
            Arrays.fill(cArray, ' ');
            string = new String(cArray);
        }
        return string;
    }

    static {
        int n = spaces.length - 1;
        char[] cArray = new char[n];
        Arrays.fill(cArray, ' ');
        Utilities.spaces[n] = new String(cArray).intern();
        EMPTY_QUEUE = new EmptyQueue();
    }

    private static final class EmptyQueue<E>
    extends AbstractQueue<E>
    implements Serializable {
        private static final long serialVersionUID = -6147951199761870325L;

        private EmptyQueue() {
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator<E> iterator() {
            Set set = Collections.emptySet();
            return set.iterator();
        }

        @Override
        public boolean offer(E e) {
            return false;
        }

        @Override
        public E poll() {
            return null;
        }

        @Override
        public E peek() {
            return null;
        }

        protected Object readResolve() throws ObjectStreamException {
            return EMPTY_QUEUE;
        }
    }
}

