/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.collection;

import java.lang.ref.Reference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.geotoolkit.util.collection.Cache;

final class CacheEntries<K, V>
extends AbstractSet<Map.Entry<K, V>> {
    private final Set<Map.Entry<K, Object>> entries;

    CacheEntries(Set<Map.Entry<K, Object>> set) {
        this.entries = set;
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new Iter(this.entries.iterator());
    }

    private static final class Iter<K, V>
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<K, Object>> it;
        private Map.Entry<K, V> next;

        Iter(Iterator<Map.Entry<K, Object>> iterator) {
            this.it = iterator;
            this.advance();
        }

        private void advance() {
            while (this.it.hasNext()) {
                Map.Entry<K, Object> entry = this.it.next();
                Object object = entry.getValue();
                if (object == null || object instanceof Cache.Handler || object instanceof Reference && (object = ((Reference)object).get()) == null) continue;
                Object object2 = object;
                this.next = new AbstractMap.SimpleEntry<K, Object>(entry.getKey(), object2);
                return;
            }
            this.next = null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Map.Entry<K, V> next() {
            Map.Entry<K, V> entry = this.next;
            if (entry != null) {
                this.advance();
                return entry;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

