/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.collection;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.geotoolkit.util.collection.Cache;
import org.geotoolkit.util.logging.Logging;

final class CacheReferences
extends Thread {
    static final CacheReferences INSTANCE = new CacheReferences();
    private final BlockingQueue<Handler> queue = new LinkedBlockingQueue<Handler>(100000);

    private CacheReferences() {
        super("CacheReferences");
        this.setPriority(9);
        this.setDaemon(true);
    }

    final void add(Handler handler) {
        if (!this.queue.offer(handler)) {
            try {
                this.queue.put(handler);
            }
            catch (InterruptedException interruptedException) {
                handler.cancel();
                Logging.severeException(null, Cache.Handler.class, "unlock", interruptedException);
            }
        }
    }

    @Override
    public void run() {
        while (this.queue != null) {
            try {
                Handler handler = this.queue.take();
                handler.adjustReferences();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                Logging.unexpectedException(CacheReferences.class, "run", exception);
            }
            catch (AssertionError assertionError) {
                Logging.unexpectedException(CacheReferences.class, "run", (Throwable)((Object)assertionError));
            }
        }
        Logging.getLogger(CacheReferences.class).severe("Daemon stopped.");
    }

    static {
        INSTANCE.start();
    }

    static interface Handler {
        public void adjustReferences();

        public void cancel();
    }
}

