/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Cloneable;
import org.geotoolkit.util.NullArgumentException;
import org.geotoolkit.util.collection.CheckedCollection;
import org.geotoolkit.util.collection.SynchronizedIterator;

public class CheckedHashSet<E>
extends LinkedHashSet<E>
implements CheckedCollection<E>,
Cloneable {
    private static final long serialVersionUID = -9014541457174735097L;
    private final Class<E> type;

    public CheckedHashSet(Class<E> clazz) {
        this.type = clazz;
        this.ensureNonNull();
    }

    public CheckedHashSet(Class<E> clazz, int n) {
        super(n);
        this.type = clazz;
        this.ensureNonNull();
    }

    private void ensureNonNull() {
        if (this.type == null) {
            throw new NullArgumentException(Errors.format(152, "type"));
        }
    }

    @Override
    public Class<E> getElementType() {
        return this.type;
    }

    protected void ensureValidType(E e) throws IllegalArgumentException {
        if (e != null && !this.type.isInstance(e)) {
            throw new IllegalArgumentException(Errors.format(66, e.getClass(), this.type));
        }
    }

    private void ensureValid(Collection<? extends E> collection) throws IllegalArgumentException {
        if (collection != null) {
            for (E e : collection) {
                this.ensureValidType(e);
            }
        }
    }

    protected void checkWritePermission() throws UnsupportedOperationException {
    }

    protected Object getLock() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<E> iterator() {
        Object object;
        Object object2 = object = this.getLock();
        synchronized (object2) {
            return new SynchronizedIterator(super.iterator(), object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.getLock();
        synchronized (object) {
            return super.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.getLock();
        synchronized (object) {
            return super.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object object) {
        Object object2 = this.getLock();
        synchronized (object2) {
            return super.contains(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e) throws IllegalArgumentException, UnsupportedOperationException {
        this.ensureValidType(e);
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            return super.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> collection) throws IllegalArgumentException, UnsupportedOperationException {
        this.ensureValid(collection);
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            return super.addAll(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object object) throws UnsupportedOperationException {
        Object object2 = this.getLock();
        synchronized (object2) {
            this.checkWritePermission();
            return super.remove(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> collection) throws UnsupportedOperationException {
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            return super.removeAll(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> collection) throws UnsupportedOperationException {
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            return super.retainAll(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws UnsupportedOperationException {
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            super.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        Object object = this.getLock();
        synchronized (object) {
            return super.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] TArray) {
        Object object = this.getLock();
        synchronized (object) {
            return super.toArray(TArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        Object object = this.getLock();
        synchronized (object) {
            return super.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object) {
        Object object2 = this.getLock();
        synchronized (object2) {
            return super.equals(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        Object object = this.getLock();
        synchronized (object) {
            return super.hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CheckedHashSet<E> clone() {
        Object object = this.getLock();
        synchronized (object) {
            return (CheckedHashSet)super.clone();
        }
    }
}

