/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.collection;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Cloneable;
import org.geotoolkit.util.XArrays;

public class IntegerList
extends AbstractList<Integer>
implements RandomAccess,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1241962316404811189L;
    private static final int VALUE_SIZE = 64;
    private static final int BASE_SHIFT = 6;
    private static final int OFFSET_MASK = 63;
    private long[] values;
    private final int bitCount;
    private final int mask;
    private int size;

    public IntegerList(int n, int n2) {
        this(n, n2, false);
    }

    public IntegerList(int n, int n2, boolean bl) {
        if (n <= 0) {
            throw new IllegalArgumentException(Errors.format(134, n));
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException(Errors.format(134, n2));
        }
        int n3 = 0;
        do {
            ++n3;
        } while ((n2 >>>= 1) != 0);
        this.bitCount = n3;
        this.mask = (1 << n3) - 1;
        this.values = new long[this.length(n)];
        if (bl) {
            this.size = n;
        }
    }

    private int length(int n) {
        int n2 = (n *= this.bitCount) >>> 6;
        if ((n & 0x3F) != 0) {
            ++n2;
        }
        return n2;
    }

    public int maximalValue() {
        return this.mask;
    }

    @Override
    public int size() {
        return this.size;
    }

    public void resize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n > this.size) {
            int n2 = this.size * this.bitCount;
            int n3 = n2 & 0x3F;
            if (n3 != 0 && (n2 >>>= 6) < this.values.length) {
                int n4 = n2++;
                this.values[n4] = this.values[n4] & (1L << n3) - 1L;
            }
            int n5 = this.length(n);
            Arrays.fill(this.values, n2, Math.min(n5, this.values.length), 0L);
            if (n5 > this.values.length) {
                this.values = Arrays.copyOf(this.values, n5);
            }
        }
        this.size = n;
    }

    public void fill(int n) {
        long l;
        if (n < 0 || n > this.mask) {
            throw new IllegalArgumentException(Errors.format(215, n, 0, this.mask));
        }
        if (n == 0) {
            l = 0L;
        } else if (n == this.mask) {
            l = -1L;
        } else {
            switch (this.bitCount) {
                case 1: {
                    n |= n << 1;
                }
                case 2: {
                    n |= n << 2;
                }
                case 4: {
                    n |= n << 4;
                }
                case 8: {
                    n |= n << 8;
                }
                case 16: {
                    n |= n << 16;
                }
                case 32: {
                    l = (long)n & 0xFFFFFFFFL | (long)n << 32;
                    break;
                }
                default: {
                    for (int i = 0; i < this.size; ++i) {
                        this.setUnchecked(i, n);
                    }
                    return;
                }
            }
        }
        Arrays.fill(this.values, 0, this.length(this.size), l);
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public boolean add(Integer n) throws IllegalArgumentException {
        this.addInteger(n);
        return true;
    }

    public void addInteger(int n) throws IllegalArgumentException {
        if (n < 0 || n > this.mask) {
            throw new IllegalArgumentException(Errors.format(215, n, 0, this.mask));
        }
        int n2 = this.size++;
        int n3 = this.length(this.size);
        if (n3 > this.values.length) {
            this.values = Arrays.copyOf(this.values, 2 * this.values.length);
        }
        this.setUnchecked(n2, n);
    }

    @Override
    public Integer get(int n) throws IndexOutOfBoundsException {
        return this.getInteger(n);
    }

    public int getInteger(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(Errors.format(85, n));
        }
        return this.getUnchecked(n);
    }

    private int getUnchecked(int n) {
        int n2 = (n *= this.bitCount) >>> 6;
        int n3 = n & 0x3F;
        int n4 = (int)(this.values[n2] >>> n3);
        if ((n3 = 64 - n3) < this.bitCount) {
            int n5 = (int)this.values[++n2];
            n4 |= n5 << n3;
        }
        return n4 &= this.mask;
    }

    @Override
    public Integer set(int n, Integer n2) throws IndexOutOfBoundsException {
        Integer n3 = this.get(n);
        this.setInteger(n, n2);
        return n3;
    }

    public void setInteger(int n, int n2) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(Errors.format(85, n));
        }
        if (n2 < 0 || n2 > this.mask) {
            throw new IllegalArgumentException(Errors.format(215, n2, 0, this.mask));
        }
        this.setUnchecked(n, n2);
    }

    private void setUnchecked(int n, int n2) {
        int n3 = (n *= this.bitCount) >>> 6;
        int n4 = n & 0x3F;
        int n5 = n3;
        this.values[n5] = this.values[n5] & ((long)this.mask << n4 ^ 0xFFFFFFFFFFFFFFFFL);
        int n6 = n3++;
        this.values[n6] = this.values[n6] | (long)n2 << n4;
        if ((n4 = 64 - n4) < this.bitCount) {
            int n7 = n3;
            this.values[n7] = this.values[n7] & ((long)this.mask >>> n4 ^ 0xFFFFFFFFFFFFFFFFL);
            int n8 = n3;
            this.values[n8] = this.values[n8] | (long)(n2 >>>= n4);
        }
    }

    @Override
    public Integer remove(int n) throws IndexOutOfBoundsException {
        Integer n2 = this.get(n);
        this.removeRange(n, n + 1);
        return n2;
    }

    @Override
    public int removeLast() throws NoSuchElementException {
        if (this.size != 0) {
            return this.getUnchecked(--this.size);
        }
        throw new NoSuchElementException();
    }

    @Override
    protected void removeRange(int n, int n2) {
        int n3 = this.size;
        if (n < 0 || n2 > n3 || n > n2) {
            throw new IndexOutOfBoundsException(Errors.format(13, n, n2));
        }
        int n4 = n * this.bitCount;
        int n5 = n4 & 0x3F;
        int n6 = n2 * this.bitCount;
        if (n5 == (n6 & 0x3F)) {
            long l = (1L << n5) - 1L;
            long l2 = this.values[n4 >>>= 6] & l;
            System.arraycopy(this.values, n6 >>>= 6, this.values, n4, this.length(n3) - n6);
            this.values[n4] = this.values[n4] & (l ^ 0xFFFFFFFFFFFFFFFFL) | l2;
        } else {
            while (n2 < n3) {
                this.setUnchecked(n++, this.getUnchecked(n2++));
            }
        }
        this.size -= n2 - n;
    }

    public int occurence(int n) {
        int n2 = 0;
        int n3 = this.size;
        for (int i = 0; i < n3; ++i) {
            if (this.getUnchecked(i) != n) continue;
            ++n2;
        }
        return n2;
    }

    public void trimToSize() {
        this.values = XArrays.resize(this.values, this.length(this.size));
    }

    @Override
    public IntegerList clone() {
        IntegerList integerList;
        try {
            integerList = (IntegerList)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
        integerList.values = (long[])integerList.values.clone();
        return integerList;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.trimToSize();
        objectOutputStream.defaultWriteObject();
    }
}

