/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.collection;

import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.XArrays;
import org.geotoolkit.util.collection.CheckedCollection;
import org.geotoolkit.util.collection.WeakCollectionCleaner;
import org.geotoolkit.util.logging.Logging;

public class WeakHashSet<E>
extends AbstractSet<E>
implements CheckedCollection<E> {
    private static final int MIN_CAPACITY = 21;
    private static final float LOAD_FACTOR = 0.75f;
    private Entry[] table;
    private final Class<E> type;
    private final boolean isArray;
    private int count;
    private int threshold;
    private static final int REMOVE = -1;
    private static final int GET = 0;
    private static final int ADD = 1;
    private static final int INTERN = 2;

    public static <E> WeakHashSet<E> newInstance(Class<E> clazz) {
        return new WeakHashSet<E>(clazz);
    }

    protected WeakHashSet(Class<E> clazz) {
        this.type = clazz;
        this.isArray = clazz.isArray() || clazz.equals(Object.class);
        this.newEntryTable(21);
        this.threshold = Math.round((float)this.table.length * 0.75f);
    }

    private void newEntryTable(int n) {
        this.table = (Entry[])Array.newInstance(Entry.class, n);
    }

    @Override
    public Class<E> getElementType() {
        return this.type;
    }

    private synchronized void removeEntry(Entry entry) {
        assert (this.valid()) : this.count;
        int n = entry.hash % this.table.length;
        if (n < this.table.length) {
            Entry entry2 = null;
            Entry entry3 = this.table[n];
            while (entry3 != null) {
                if (entry3 == entry) {
                    if (entry2 != null) {
                        entry2.next = entry3.next;
                    } else {
                        this.table[n] = entry3.next;
                    }
                    --this.count;
                    assert (this.valid());
                    if (this.count <= this.threshold / 4) {
                        this.rehash("remove");
                    }
                    return;
                }
                entry2 = entry3;
                entry3 = entry3.next;
            }
        }
        assert (this.valid());
    }

    private void rehash(String string) {
        Object object;
        Object object2;
        assert (Thread.holdsLock(this));
        assert (this.valid());
        int n = Math.max(Math.round((float)this.count / 0.375f), this.count + 21);
        if (n == this.table.length) {
            return;
        }
        Entry[] entryArray = this.table;
        this.newEntryTable(n);
        this.threshold = Math.round((float)n * 0.75f);
        for (int i = 0; i < entryArray.length; ++i) {
            object2 = entryArray[i];
            while (object2 != null) {
                object = object2;
                object2 = ((Entry)object2).next;
                int n2 = ((Entry)object).hash % this.table.length;
                ((Entry)object).next = this.table[n2];
                this.table[n2] = object;
            }
        }
        Logger logger = Logging.getLogger(WeakHashSet.class);
        if (logger.isLoggable((Level)(object2 = Level.FINEST))) {
            object = new LogRecord((Level)object2, "Rehash from " + entryArray.length + " to " + this.table.length);
            ((LogRecord)object).setSourceMethodName(string);
            ((LogRecord)object).setSourceClassName(WeakHashSet.class.getName());
            ((LogRecord)object).setLoggerName(logger.getName());
            logger.log((LogRecord)object);
        }
        assert (this.valid());
    }

    private boolean valid() {
        int n = 0;
        for (int i = 0; i < this.table.length; ++i) {
            Entry entry = this.table[i];
            while (entry != null) {
                ++n;
                entry = entry.next;
            }
        }
        if (n != this.count) {
            this.count = n;
            return false;
        }
        return true;
    }

    @Override
    public synchronized int size() {
        assert (this.valid());
        return this.count;
    }

    @Override
    public synchronized boolean add(E e) {
        return this.intern(e, 1) == null;
    }

    @Override
    public synchronized boolean remove(Object object) {
        return this.intern(this.type.cast(object), -1) != null;
    }

    public synchronized <T extends E> T get(T t) {
        return this.intern(t, 0);
    }

    @Override
    public synchronized boolean contains(Object object) {
        return object != null && this.intern(this.type.cast(object), 0) != null;
    }

    public synchronized <T extends E> T unique(T t) {
        return this.intern(t, 2);
    }

    public synchronized void uniques(E[] EArray) {
        for (int i = 0; i < EArray.length; ++i) {
            EArray[i] = this.intern(EArray[i], 2);
        }
    }

    private final <T extends E> T intern(T t, int n) {
        assert (Thread.holdsLock(this));
        assert (WeakCollectionCleaner.DEFAULT.isAlive());
        assert (this.valid()) : this.count;
        if (t != null) {
            int n2 = (this.isArray ? Utilities.deepHashCode(t) : t.hashCode()) & Integer.MAX_VALUE;
            int n3 = n2 % this.table.length;
            Entry entry = this.table[n3];
            while (entry != null) {
                Object t2 = entry.get();
                if (this.isArray ? Utilities.deepEquals(t2, t) : t.equals(t2)) {
                    if (n == -1) {
                        entry.dispose();
                    }
                    assert (t2.getClass().equals(t.getClass())) : t2;
                    Object t3 = t2;
                    return t3;
                }
                entry = entry.next;
            }
            if (n >= 1) {
                if (this.count >= this.threshold) {
                    this.rehash("add");
                    n3 = n2 % this.table.length;
                }
                this.table[n3] = new Entry(t, this.table[n3], n2);
                ++this.count;
            }
        }
        assert (this.valid());
        return (T)(n == 2 ? t : null);
    }

    @Override
    public synchronized void clear() {
        Arrays.fill(this.table, null);
        this.count = 0;
    }

    @Override
    public synchronized E[] toArray() {
        assert (this.valid());
        Object[] objectArray = (Object[])Array.newInstance(this.type, this.count);
        int n = 0;
        for (int i = 0; i < this.table.length; ++i) {
            Entry entry = this.table[i];
            while (entry != null) {
                objectArray[n] = entry.get();
                if (objectArray[n] != null) {
                    ++n;
                }
                entry = entry.next;
            }
        }
        return XArrays.resize(objectArray, n);
    }

    @Override
    public Iterator<E> iterator() {
        return Arrays.asList(this.toArray()).iterator();
    }

    private final class Entry
    extends WeakReference<E>
    implements WeakCollectionCleaner.Disposeable {
        Entry next;
        final int hash;

        Entry(E e, Entry entry, int n) {
            super(e, WeakCollectionCleaner.DEFAULT.queue);
            this.next = entry;
            this.hash = n;
        }

        @Override
        public void dispose() {
            this.clear();
            WeakHashSet.this.removeEntry(this);
        }
    }
}

