/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.converter;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.geotoolkit.resources.Errors;

public final class Classes {
    public static final byte DOUBLE = 8;
    public static final byte FLOAT = 7;
    public static final byte LONG = 6;
    public static final byte INTEGER = 5;
    public static final byte SHORT = 4;
    public static final byte BYTE = 3;
    public static final byte CHARACTER = 2;
    public static final byte BOOLEAN = 1;
    public static final byte OTHER = 0;
    private static final Map<Class<?>, Classes> MAPPING = new HashMap(16);
    private final Class<?> primitive;
    private final Class<?> wrapper;
    private final boolean isFloat;
    private final boolean isInteger;
    private final byte size;
    private final byte ordinal;
    private final char internal;

    private Classes(Class<?> clazz, boolean bl, boolean bl2, byte by) {
        this.wrapper = clazz;
        this.primitive = this.wrapper;
        this.isFloat = bl;
        this.isInteger = bl2;
        this.size = (byte)-1;
        this.ordinal = by;
        this.internal = (char)76;
        if (MAPPING.put(clazz, this) != null) {
            throw new AssertionError();
        }
    }

    private Classes(Class<?> clazz, Class<?> clazz2, boolean bl, boolean bl2, byte by, byte by2, char c) {
        this.primitive = clazz;
        this.wrapper = clazz2;
        this.isFloat = bl;
        this.isInteger = bl2;
        this.size = by;
        this.ordinal = by2;
        this.internal = c;
        if (MAPPING.put(clazz, this) != null || MAPPING.put(clazz2, this) != null) {
            throw new AssertionError();
        }
    }

    public static Class<?> changeArrayDimension(Class<?> clazz, int n) {
        if (n != 0 && clazz != null) {
            if (n < 0) {
                while ((clazz = clazz.getComponentType()) != null && ++n != 0) {
                }
            } else if (!clazz.equals(Void.TYPE)) {
                StringBuilder stringBuilder = new StringBuilder();
                do {
                    stringBuilder.insert(0, '[');
                } while (--n != 0);
                if (clazz.isPrimitive()) {
                    stringBuilder.append(Classes.MAPPING.get(clazz).internal);
                } else if (clazz.isArray()) {
                    stringBuilder.append(clazz.getName());
                } else {
                    stringBuilder.append('L').append(clazz.getName()).append(';');
                }
                String string = stringBuilder.toString();
                try {
                    clazz = Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new AssertionError((Object)classNotFoundException);
                }
            }
        }
        return clazz;
    }

    public static Class<?> boundOfParameterizedAttribute(Field field) {
        return Classes.getActualTypeArgument(field.getGenericType());
    }

    public static Class<?> boundOfParameterizedAttribute(Method method) {
        Type[] typeArray;
        Class<?> clazz = Classes.getActualTypeArgument(method.getGenericReturnType());
        if (clazz == null && (typeArray = method.getGenericParameterTypes()) != null && typeArray.length == 1) {
            clazz = Classes.getActualTypeArgument(typeArray[0]);
        }
        return clazz;
    }

    private static Class<?> getActualTypeArgument(Type type) {
        if (type instanceof ParameterizedType) {
            Type[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
            while (typeArray != null && typeArray.length == 1) {
                type = typeArray[0];
                if (type instanceof Class) {
                    return (Class)type;
                }
                if (!(type instanceof WildcardType)) break;
                typeArray = ((WildcardType)type).getUpperBounds();
            }
        }
        return null;
    }

    public static <T> Class<? extends T> getClass(T t) {
        return t != null ? t.getClass() : null;
    }

    public static <T> Set<Class<? extends T>> getClasses(Collection<? extends T> collection) {
        LinkedHashSet<Class<T>> linkedHashSet = new LinkedHashSet<Class<T>>();
        for (T t : collection) {
            linkedHashSet.add(Classes.getClass(t));
        }
        return linkedHashSet;
    }

    public static Set<Class<?>> getAllInterfaces(Class<?> clazz) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        Classes.getAllInterfaces(clazz, linkedHashSet);
        return linkedHashSet;
    }

    private static void getAllInterfaces(Class<?> clazz, Set<Class<?>> set) {
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            if (!set.add(clazz2)) continue;
            Classes.getAllInterfaces(clazz2, set);
        }
    }

    public static Class<?> findSpecializedClass(Collection<?> collection) {
        Set<Class<?>> set = Classes.getClasses(collection);
        set.remove(null);
        Iterator<Class<?>> iterator = set.iterator();
        block0: while (iterator.hasNext()) {
            Class<?> clazz = iterator.next();
            for (Class<?> clazz2 : set) {
                if (clazz == clazz2 || !clazz.isAssignableFrom(clazz2)) continue;
                iterator.remove();
                continue block0;
            }
        }
        return Classes.common(set);
    }

    private static Class<?> common(Set<Class<?>> set) {
        Iterator<Class<?>> iterator = set.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        Class<?> clazz = iterator.next();
        while (iterator.hasNext()) {
            clazz = Classes.findCommonClass(clazz, iterator.next());
        }
        return clazz;
    }

    public static Class<?> findCommonClass(Collection<?> collection) {
        Set<Class<?>> set = Classes.getClasses(collection);
        set.remove(null);
        return Classes.common(set);
    }

    public static Class<?> findCommonClass(Class<?> clazz, Class<?> clazz2) {
        if (clazz == null) {
            return clazz2;
        }
        if (clazz2 == null) {
            return clazz;
        }
        do {
            if (clazz.isAssignableFrom(clazz2)) {
                return clazz;
            }
            if (clazz2.isAssignableFrom(clazz)) {
                return clazz2;
            }
            clazz = clazz.getSuperclass();
            clazz2 = clazz2.getSuperclass();
        } while (clazz != null && clazz2 != null);
        return Object.class;
    }

    public static Set<Class<?>> findCommonInterfaces(Class<?> clazz, Class<?> clazz2) {
        Set<Class<Class<?>>> set = Classes.getAllInterfaces(clazz);
        Set<Class<?>> set2 = Classes.getAllInterfaces(clazz2);
        set.retainAll(set2);
        Iterator<Class<?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Class<?> clazz3 = iterator.next();
            set2.clear();
            Classes.getAllInterfaces(clazz3, set2);
            if (!set.removeAll(set2)) continue;
            iterator = set.iterator();
        }
        return set;
    }

    public static <T> boolean implementSameInterfaces(Class<? extends T> clazz, Class<? extends T> clazz2, Class<T> clazz3) {
        Class<?> clazz4;
        int n;
        if (clazz == clazz2) {
            return true;
        }
        if (clazz == null || clazz2 == null) {
            return false;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        Class<?>[] classArray2 = clazz2.getInterfaces();
        int n2 = 0;
        for (n = 0; n < classArray2.length; ++n) {
            clazz4 = classArray2[n];
            if (!clazz3.isAssignableFrom(clazz4)) continue;
            classArray2[n2++] = clazz4;
        }
        block1: for (n = 0; n < classArray.length; ++n) {
            clazz4 = classArray[n];
            if (!clazz3.isAssignableFrom(clazz4)) continue;
            for (int i = 0; i < n2; ++i) {
                if (!clazz4.equals(classArray2[i])) continue;
                System.arraycopy(classArray2, i + 1, classArray2, i, --n2 - i);
                continue block1;
            }
            return false;
        }
        return n2 == 0;
    }

    public static boolean isFloat(Class<?> clazz) {
        Classes classes = MAPPING.get(clazz);
        return classes != null && classes.isFloat;
    }

    public static boolean isInteger(Class<?> clazz) {
        Classes classes = MAPPING.get(clazz);
        return classes != null && classes.isInteger;
    }

    public static int primitiveBitCount(Class<?> clazz) throws IllegalArgumentException {
        byte by;
        Classes classes = MAPPING.get(clazz);
        if (classes != null && (by = classes.size) >= 0) {
            return by;
        }
        if (clazz == null) {
            return 0;
        }
        throw Classes.unknownType(clazz);
    }

    public static Class<?> primitiveToWrapper(Class<?> clazz) {
        Classes classes = MAPPING.get(clazz);
        return classes != null ? classes.wrapper : clazz;
    }

    public static Class<?> wrapperToPrimitive(Class<?> clazz) {
        Classes classes = MAPPING.get(clazz);
        return classes != null ? classes.primitive : clazz;
    }

    public static Class<? extends Number> widestClass(Number number, Number number2) throws IllegalArgumentException {
        return Classes.widestClass(number != null ? number.getClass() : null, number2 != null ? number2.getClass() : null);
    }

    public static Class<? extends Number> widestClass(Class<? extends Number> clazz, Class<? extends Number> clazz2) throws IllegalArgumentException {
        Classes classes = MAPPING.get(clazz);
        if (classes == null && clazz != null) {
            throw Classes.unknownType(clazz);
        }
        Classes classes2 = MAPPING.get(clazz2);
        if (classes2 == null && clazz2 != null) {
            throw Classes.unknownType(clazz2);
        }
        if (clazz == null) {
            return clazz2;
        }
        if (clazz2 == null) {
            return clazz;
        }
        return classes.ordinal >= classes2.ordinal ? clazz : clazz2;
    }

    public static Class<? extends Number> finestClass(Number number, Number number2) throws IllegalArgumentException {
        return Classes.finestClass(number != null ? number.getClass() : null, number2 != null ? number2.getClass() : null);
    }

    public static Class<? extends Number> finestClass(Class<? extends Number> clazz, Class<? extends Number> clazz2) throws IllegalArgumentException {
        Classes classes = MAPPING.get(clazz);
        if (classes == null && clazz != null) {
            throw Classes.unknownType(clazz);
        }
        Classes classes2 = MAPPING.get(clazz2);
        if (classes2 == null && clazz2 != null) {
            throw Classes.unknownType(clazz2);
        }
        if (clazz == null) {
            return clazz2;
        }
        if (clazz2 == null) {
            return clazz;
        }
        return classes.ordinal < classes2.ordinal ? clazz : clazz2;
    }

    public static Class<? extends Number> finestClass(double d) {
        long l = (long)d;
        if (d == (double)l) {
            return Classes.finestClass(l);
        }
        float f = (float)d;
        if (Double.doubleToRawLongBits(d) == Double.doubleToRawLongBits(f)) {
            return Float.class;
        }
        return Double.class;
    }

    public static Class<? extends Number> finestClass(long l) {
        if (l <= 127L && l >= -128L) {
            return Byte.class;
        }
        if (l <= 32767L && l >= -32768L) {
            return Short.class;
        }
        if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
            return Integer.class;
        }
        return Long.class;
    }

    public static Number finestNumber(double d) {
        long l = (long)d;
        if (d == (double)l) {
            return Classes.finestNumber(l);
        }
        float f = (float)d;
        if (Double.doubleToRawLongBits(d) == Double.doubleToRawLongBits(f)) {
            return Float.valueOf(f);
        }
        return d;
    }

    public static Number finestNumber(long l) {
        if (l <= 127L && l >= -128L) {
            return (byte)l;
        }
        if (l <= 32767L && l >= -32768L) {
            return (short)l;
        }
        if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
            return (int)l;
        }
        return l;
    }

    public static Number finestNumber(String string) throws NumberFormatException {
        string = string.trim();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c != '.' && c != 'e' && c != 'E') continue;
            return Classes.finestNumber(Double.parseDouble(string));
        }
        return Classes.finestNumber(Long.parseLong(string));
    }

    public static <N extends Number> N cast(Number number, Class<N> clazz) throws IllegalArgumentException {
        if (number == null || number.getClass().equals(clazz)) {
            return (N)number;
        }
        if (Byte.class.equals(clazz)) {
            return (N)Byte.valueOf(number.byteValue());
        }
        if (Short.class.equals(clazz)) {
            return (N)Short.valueOf(number.shortValue());
        }
        if (Integer.class.equals(clazz)) {
            return (N)Integer.valueOf(number.intValue());
        }
        if (Long.class.equals(clazz)) {
            return (N)Long.valueOf(number.longValue());
        }
        if (Float.class.equals(clazz)) {
            return (N)Float.valueOf(number.floatValue());
        }
        if (Double.class.equals(clazz)) {
            return (N)Double.valueOf(number.doubleValue());
        }
        throw Classes.unknownType(clazz);
    }

    public static <T> T valueOf(Class<T> clazz, String string) throws IllegalArgumentException, NumberFormatException {
        if (string == null) {
            return null;
        }
        if (Double.class.equals(clazz)) {
            return (T)Double.valueOf(string);
        }
        if (Float.class.equals(clazz)) {
            return (T)Float.valueOf(string);
        }
        if (Long.class.equals(clazz)) {
            return (T)Long.valueOf(string);
        }
        if (Integer.class.equals(clazz)) {
            return (T)Integer.valueOf(string);
        }
        if (Short.class.equals(clazz)) {
            return (T)Short.valueOf(string);
        }
        if (Byte.class.equals(clazz)) {
            return (T)Byte.valueOf(string);
        }
        if (Boolean.class.equals(clazz)) {
            return (T)Boolean.valueOf(string);
        }
        if (Character.class.equals(clazz)) {
            return (T)Character.valueOf(string.length() != 0 ? string.charAt(0) : (char)'\u0000');
        }
        if (String.class.equals(clazz)) {
            return (T)string;
        }
        throw Classes.unknownType(clazz);
    }

    public static byte getEnumConstant(Class<?> clazz) {
        Classes classes = MAPPING.get(clazz);
        if (classes != null && classes.size >= 0) {
            return classes.ordinal;
        }
        return 0;
    }

    public static String getShortName(Class<?> clazz) {
        if (clazz == null) {
            return "<*>";
        }
        Class<?> clazz2 = clazz.getEnclosingClass();
        while (clazz.isAnonymousClass()) {
            clazz = clazz.getSuperclass();
        }
        String string = clazz.getSimpleName();
        if (clazz2 != null) {
            string = Classes.getShortName(clazz2) + '.' + string;
        }
        return string;
    }

    public static String getShortClassName(Object object) {
        return Classes.getShortName(Classes.getClass(object));
    }

    private static IllegalArgumentException unknownType(Class<?> clazz) {
        return new IllegalArgumentException(Errors.format(198, clazz));
    }

    static {
        new Classes(BigDecimal.class, true, false, 10);
        new Classes(BigInteger.class, false, true, 9);
        new Classes(Double.TYPE, Double.class, true, false, 64, 8, 'D');
        new Classes(Float.TYPE, Float.class, true, false, 32, 7, 'F');
        new Classes(Long.TYPE, Long.class, false, true, 64, 6, 'J');
        new Classes(Integer.TYPE, Integer.class, false, true, 32, 5, 'I');
        new Classes(Short.TYPE, Short.class, false, true, 16, 4, 'S');
        new Classes(Byte.TYPE, Byte.class, false, true, 8, 3, 'B');
        new Classes(Character.TYPE, Character.class, false, false, 16, 2, 'C');
        new Classes(Boolean.TYPE, Boolean.class, false, false, 1, 1, 'Z');
        new Classes(Void.TYPE, Void.class, false, false, 0, 0, 'V');
    }
}

