/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.converter;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.geotoolkit.util.converter.SimpleConverter;

abstract class CollectionConverter<T>
extends SimpleConverter<Collection<?>, T>
implements Serializable {
    private static final long serialVersionUID = -4515250904953131514L;

    CollectionConverter() {
    }

    @Override
    public final Class<Collection<?>> getSourceClass() {
        return Collection.class;
    }

    static final class List
    extends CollectionConverter<java.util.List<?>> {
        private static final long serialVersionUID = 5492247760609833586L;
        public static final List INSTANCE = new List();

        private List() {
        }

        @Override
        public Class<java.util.List<?>> getTargetClass() {
            return java.util.List.class;
        }

        @Override
        public java.util.List<?> convert(Collection<?> collection) {
            if (collection == null) {
                return null;
            }
            if (collection instanceof java.util.List) {
                return (java.util.List)collection;
            }
            return new ArrayList(collection);
        }

        protected Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    static final class Set
    extends CollectionConverter<java.util.Set<?>> {
        private static final long serialVersionUID = -4200659837453206164L;
        public static final Set INSTANCE = new Set();

        private Set() {
        }

        @Override
        public Class<java.util.Set<?>> getTargetClass() {
            return java.util.Set.class;
        }

        @Override
        public java.util.Set<?> convert(Collection<?> collection) {
            if (collection == null) {
                return null;
            }
            if (collection instanceof java.util.Set) {
                return (java.util.Set)collection;
            }
            return new LinkedHashSet(collection);
        }

        protected Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }
}

