/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.converter;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Date;
import org.geotoolkit.util.converter.SimpleConverter;

abstract class DateConverter<T>
extends SimpleConverter<Date, T>
implements Serializable {
    private static final long serialVersionUID = -7770401534710581917L;

    DateConverter() {
    }

    @Override
    public final Class<Date> getSourceClass() {
        return Date.class;
    }

    static final class Long
    extends DateConverter<java.lang.Long> {
        private static final long serialVersionUID = 3163928356094316134L;
        public static final Long INSTANCE = new Long();

        private Long() {
        }

        @Override
        public Class<java.lang.Long> getTargetClass() {
            return java.lang.Long.class;
        }

        @Override
        public java.lang.Long convert(Date date) {
            if (date == null) {
                return null;
            }
            return date.getTime();
        }

        protected Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    static final class Timestamp
    extends DateConverter<java.sql.Timestamp> {
        private static final long serialVersionUID = 3798633184562706892L;
        public static final Timestamp INSTANCE = new Timestamp();

        private Timestamp() {
        }

        @Override
        public Class<java.sql.Timestamp> getTargetClass() {
            return java.sql.Timestamp.class;
        }

        @Override
        public java.sql.Timestamp convert(Date date) {
            if (date == null) {
                return null;
            }
            return new java.sql.Timestamp(date.getTime());
        }

        protected Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }
}

