/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.converter;

import java.io.Serializable;
import java.util.Iterator;
import javax.swing.tree.MutableTreeNode;
import org.geotoolkit.gui.swing.tree.DefaultMutableTreeNode;
import org.geotoolkit.gui.swing.tree.Trees;
import org.geotoolkit.util.converter.ClassPair;
import org.geotoolkit.util.converter.Classes;
import org.geotoolkit.util.converter.NonconvertibleObjectException;
import org.geotoolkit.util.converter.ObjectConverter;

final class FallbackConverter<S, T>
extends ClassPair<S, T>
implements ObjectConverter<S, T>,
Serializable {
    private static final long serialVersionUID = -6588190939281568858L;
    private ObjectConverter<S, ? extends T> primary;
    private ObjectConverter<S, ? extends T> fallback;

    private FallbackConverter(ObjectConverter<S, ? extends T> objectConverter, ObjectConverter<S, ? extends T> objectConverter2) {
        super(objectConverter.getSourceClass(), FallbackConverter.commonClass(objectConverter.getSourceClass(), objectConverter.getTargetClass(), objectConverter2.getTargetClass()));
        if (FallbackConverter.swap(objectConverter, objectConverter2)) {
            this.primary = objectConverter2;
            this.fallback = objectConverter;
        } else {
            this.primary = objectConverter;
            this.fallback = objectConverter2;
        }
        assert (this.sourceClass.equals(objectConverter.getSourceClass())) : objectConverter;
        assert (this.sourceClass.equals(objectConverter2.getSourceClass())) : objectConverter2;
        assert (this.targetClass.isAssignableFrom(objectConverter.getTargetClass())) : objectConverter;
        assert (this.targetClass.isAssignableFrom(objectConverter2.getTargetClass())) : objectConverter2;
    }

    private static <T> Class<? extends T> commonClass(Class<?> clazz, Class<? extends T> clazz2, Class<? extends T> clazz3) {
        Object object;
        Class clazz4 = Classes.findCommonClass(clazz2, clazz3);
        if (clazz4.equals(Object.class)) {
            object = Classes.findCommonInterfaces(clazz2, clazz3);
            object.removeAll(Classes.getAllInterfaces(clazz));
            Iterator iterator = object.iterator();
            if (iterator.hasNext()) {
                clazz4 = (Class)iterator.next();
            }
        }
        object = clazz4;
        return object;
    }

    private static <S> boolean swap(ObjectConverter<S, ?> objectConverter, ObjectConverter<S, ?> objectConverter2) {
        Class<?> clazz;
        assert (!objectConverter.equals(objectConverter2)) : objectConverter;
        if (objectConverter instanceof FallbackConverter) {
            FallbackConverter fallbackConverter = (FallbackConverter)objectConverter;
            return FallbackConverter.swap(fallbackConverter.primary, objectConverter2) && FallbackConverter.swap(fallbackConverter.fallback, objectConverter2);
        }
        Class<?> clazz2 = objectConverter.getTargetClass();
        return !clazz2.isAssignableFrom(clazz = objectConverter2.getTargetClass()) && clazz.isAssignableFrom(clazz2);
    }

    final ObjectConverter<S, ? extends T> converter(boolean bl) {
        assert (Thread.holdsLock(this));
        return bl ? this.primary : this.fallback;
    }

    private void add(ObjectConverter<S, ?> objectConverter, boolean bl) {
        assert (Thread.holdsLock(this));
        assert (this.targetClass.isAssignableFrom(objectConverter.getTargetClass())) : objectConverter;
        if (bl) {
            this.primary = new FallbackConverter<S, T>(this.primary, objectConverter);
        } else {
            this.fallback = new FallbackConverter<S, T>(this.fallback, objectConverter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <S> void add(FallbackConverter<S, ?> fallbackConverter, ObjectConverter<S, ?> objectConverter) {
        Class<Object> clazz = objectConverter.getTargetClass();
        boolean bl = false;
        while (true) {
            FallbackConverter fallbackConverter2 = fallbackConverter;
            synchronized (fallbackConverter2) {
                ObjectConverter<S, ?> objectConverter2 = fallbackConverter.converter(bl);
                Class<Object> clazz2 = objectConverter2.getTargetClass();
                if (clazz2.isAssignableFrom(clazz)) {
                    if (objectConverter2 instanceof FallbackConverter) {
                        if (!clazz2.equals(clazz)) {
                            fallbackConverter = (FallbackConverter)objectConverter2;
                            bl = false;
                            continue;
                        }
                    } else {
                        super.add(objectConverter, bl);
                        return;
                    }
                }
                if (bl) {
                    bl = clazz.isAssignableFrom(fallbackConverter.primary.getTargetClass()) && !clazz.isAssignableFrom(fallbackConverter.fallback.getTargetClass());
                    fallbackConverter.add(objectConverter, bl);
                    return;
                }
                bl = true;
            }
        }
    }

    public static <S, T> ObjectConverter<S, ? extends T> create(ObjectConverter<S, ? extends T> objectConverter, ObjectConverter<S, ? extends T> objectConverter2) {
        if (objectConverter2 == null) {
            return objectConverter;
        }
        if (objectConverter == null) {
            return objectConverter2;
        }
        if (objectConverter instanceof FallbackConverter) {
            FallbackConverter fallbackConverter = (FallbackConverter)objectConverter;
            if (fallbackConverter.targetClass.isAssignableFrom(objectConverter2.getTargetClass())) {
                FallbackConverter.add(fallbackConverter, objectConverter2);
                return fallbackConverter;
            }
        }
        return new FallbackConverter<S, T>(objectConverter, objectConverter2);
    }

    static ObjectConverter<?, ?> createUnsafe(ObjectConverter<?, ?> objectConverter, ObjectConverter<?, ?> objectConverter2) {
        assert (objectConverter.getSourceClass().equals(objectConverter2.getSourceClass()));
        return FallbackConverter.create(objectConverter, objectConverter2);
    }

    @Override
    public final Class<? super S> getSourceClass() {
        return this.sourceClass;
    }

    @Override
    public final Class<? extends T> getTargetClass() {
        return this.targetClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasRestrictions() {
        ObjectConverter<S, T> objectConverter;
        ObjectConverter<S, T> objectConverter2;
        FallbackConverter fallbackConverter = this;
        synchronized (fallbackConverter) {
            objectConverter2 = this.primary;
            objectConverter = this.fallback;
        }
        return objectConverter2.hasRestrictions() && objectConverter.hasRestrictions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOrderPreserving() {
        ObjectConverter<S, T> objectConverter;
        ObjectConverter<S, T> objectConverter2;
        FallbackConverter fallbackConverter = this;
        synchronized (fallbackConverter) {
            objectConverter2 = this.primary;
            objectConverter = this.fallback;
        }
        return objectConverter2.isOrderPreserving() && objectConverter.isOrderPreserving();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOrderReversing() {
        ObjectConverter<S, T> objectConverter;
        ObjectConverter<S, T> objectConverter2;
        FallbackConverter fallbackConverter = this;
        synchronized (fallbackConverter) {
            objectConverter2 = this.primary;
            objectConverter = this.fallback;
        }
        return objectConverter2.isOrderReversing() && objectConverter.isOrderReversing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T convert(S s) throws NonconvertibleObjectException {
        ObjectConverter<S, T> objectConverter;
        ObjectConverter<S, T> objectConverter2;
        FallbackConverter fallbackConverter = this;
        synchronized (fallbackConverter) {
            objectConverter2 = this.primary;
            objectConverter = this.fallback;
        }
        try {
            return objectConverter2.convert(s);
        }
        catch (NonconvertibleObjectException nonconvertibleObjectException) {
            try {
                return objectConverter.convert(s);
            }
            catch (NonconvertibleObjectException nonconvertibleObjectException2) {
                nonconvertibleObjectException.add(nonconvertibleObjectException2);
                throw nonconvertibleObjectException;
            }
        }
    }

    private void toTree(ObjectConverter<?, ?> objectConverter, MutableTreeNode mutableTreeNode) {
        ClassPair classPair = new ClassPair(objectConverter);
        MutableTreeNode mutableTreeNode2 = new DefaultMutableTreeNode(classPair);
        if (objectConverter instanceof FallbackConverter) {
            FallbackConverter fallbackConverter = (FallbackConverter)objectConverter;
            boolean bl = fallbackConverter.targetClass.equals(this.targetClass);
            if (bl) {
                mutableTreeNode2 = mutableTreeNode;
            }
            fallbackConverter.toTree(mutableTreeNode2);
            if (bl) {
                return;
            }
        }
        mutableTreeNode.insert(mutableTreeNode2, mutableTreeNode.getChildCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void toTree(MutableTreeNode mutableTreeNode) {
        ObjectConverter<S, ? extends T> objectConverter;
        ObjectConverter<S, ? extends T> objectConverter2;
        FallbackConverter fallbackConverter = this;
        synchronized (fallbackConverter) {
            objectConverter2 = this.primary;
            objectConverter = this.fallback;
        }
        this.toTree(objectConverter2, mutableTreeNode);
        this.toTree(objectConverter, mutableTreeNode);
    }

    @Override
    public String toString() {
        ClassPair classPair = new ClassPair(this);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(classPair);
        this.toTree(defaultMutableTreeNode);
        return Trees.toString(defaultMutableTreeNode);
    }
}

