/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.converter;

import java.io.Serializable;
import org.geotoolkit.util.converter.SimpleConverter;

final class IdentityConverter<T>
extends SimpleConverter<T, T>
implements Serializable {
    private static final long serialVersionUID = -7203549932226245206L;
    static final IdentityConverter<CharSequence> CHAR_SEQUENCE = new IdentityConverter<CharSequence>(CharSequence.class);
    static final IdentityConverter<String> STRING = new IdentityConverter<String>(String.class);
    private final Class<T> type;

    public static <T> IdentityConverter<T> create(Class<T> clazz) {
        if (String.class.equals(clazz)) {
            return STRING;
        }
        if (CharSequence.class.equals(clazz)) {
            return CHAR_SEQUENCE;
        }
        return new IdentityConverter<T>(clazz);
    }

    private IdentityConverter(Class<T> clazz) {
        this.type = clazz;
    }

    @Override
    public Class<? super T> getSourceClass() {
        return this.type;
    }

    @Override
    public Class<? extends T> getTargetClass() {
        return this.type;
    }

    @Override
    public T convert(T t) {
        return t;
    }
}

