/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.logging;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public abstract class LoggerAdapter
extends Logger {
    private static final Pattern MESSAGE_FORMAT = Pattern.compile("\\{\\d+\\}");

    protected LoggerAdapter(String string) {
        super(string, null);
        super.setUseParentHandlers(false);
        super.setLevel(Level.ALL);
    }

    @Override
    public abstract void setLevel(Level var1);

    @Override
    public abstract Level getLevel();

    protected Level getDebugLevel() {
        return Level.FINER;
    }

    @Override
    public abstract boolean isLoggable(Level var1);

    @Override
    public abstract void severe(String var1);

    @Override
    public abstract void warning(String var1);

    @Override
    public abstract void info(String var1);

    @Override
    public abstract void config(String var1);

    @Override
    public abstract void fine(String var1);

    @Override
    public abstract void finer(String var1);

    @Override
    public abstract void finest(String var1);

    @Override
    public void entering(String string, String string2) {
        this.logp(this.getDebugLevel(), string, string2, "ENTRY");
    }

    @Override
    public void entering(String string, String string2, Object object) {
        this.logp(this.getDebugLevel(), string, string2, "ENTRY {0}", object);
    }

    @Override
    public void entering(String string, String string2, Object[] objectArray) {
        String string3;
        if (objectArray == null) {
            string3 = "ENTRY";
        } else {
            switch (objectArray.length) {
                case 0: {
                    string3 = "ENTRY";
                    break;
                }
                case 1: {
                    string3 = "ENTRY {0}";
                    break;
                }
                case 2: {
                    string3 = "ENTRY {0} {1}";
                    break;
                }
                default: {
                    StringBuilder stringBuilder = new StringBuilder("ENTRY");
                    for (int i = 0; i < objectArray.length; ++i) {
                        stringBuilder.append(" {").append(i).append('}');
                    }
                    string3 = stringBuilder.toString();
                    break;
                }
            }
        }
        this.logp(this.getDebugLevel(), string, string2, string3, objectArray);
    }

    @Override
    public void exiting(String string, String string2) {
        this.logp(this.getDebugLevel(), string, string2, "RETURN");
    }

    @Override
    public void exiting(String string, String string2, Object object) {
        this.logp(this.getDebugLevel(), string, string2, "RETURN {0}", object);
    }

    @Override
    public void throwing(String string, String string2, Throwable throwable) {
        this.logp(this.getDebugLevel(), string, string2, "THROW", throwable);
    }

    @Override
    public void log(LogRecord logRecord) {
        boolean bl;
        Filter filter = this.getFilter();
        if (filter != null && !filter.isLoggable(logRecord)) {
            return;
        }
        Level level = logRecord.getLevel();
        String string = logRecord.getSourceClassName();
        String string2 = logRecord.getSourceMethodName();
        String string3 = logRecord.getResourceBundleName();
        String string4 = logRecord.getMessage();
        Object[] objectArray = logRecord.getParameters();
        Throwable throwable = logRecord.getThrown();
        ResourceBundle resourceBundle = logRecord.getResourceBundle();
        boolean bl2 = false;
        if (resourceBundle != null) {
            try {
                string4 = resourceBundle.getString(string4);
                bl2 = true;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        boolean bl3 = bl = throwable != null && (objectArray == null || objectArray.length == 0);
        if (bl2) {
            if (bl) {
                this.logp(level, string, string2, string4, throwable);
            } else {
                this.logp(level, string, string2, string4, objectArray);
            }
        } else if (bl) {
            this.logrb(level, string, string2, string3, string4, throwable);
        } else {
            this.logrb(level, string, string2, string3, string4, objectArray);
        }
    }

    @Override
    public void log(Level level, String string) {
        int n = level.intValue();
        switch (n / 100) {
            default: {
                if (n < 0 || n == Integer.MAX_VALUE) break;
            }
            case 10: {
                this.severe(string);
                break;
            }
            case 9: {
                this.warning(string);
                break;
            }
            case 8: {
                this.info(string);
                break;
            }
            case 7: {
                this.config(string);
                break;
            }
            case 5: 
            case 6: {
                this.fine(string);
                break;
            }
            case 4: {
                this.finer(string);
                break;
            }
            case 3: {
                this.finest(string);
            }
            case 0: 
            case 1: 
            case 2: 
        }
    }

    @Override
    public void log(Level level, String string, Throwable throwable) {
        this.log(level, string);
    }

    @Override
    public void log(Level level, String string, Object object) {
        if (this.isLoggable(level)) {
            this.log(level, string, LoggerAdapter.asArray(object));
        }
    }

    @Override
    public void log(Level level, String string, Object[] objectArray) {
        if (this.isLoggable(level)) {
            this.log(level, LoggerAdapter.format(string, objectArray));
        }
    }

    @Override
    public void logp(Level level, String string, String string2, String string3) {
        this.log(level, string3);
    }

    @Override
    public void logp(Level level, String string, String string2, String string3, Throwable throwable) {
        this.log(level, string3, throwable);
    }

    @Override
    public void logp(Level level, String string, String string2, String string3, Object object) {
        if (this.isLoggable(level)) {
            this.logp(level, string, string2, string3, LoggerAdapter.asArray(object));
        }
    }

    @Override
    public void logp(Level level, String string, String string2, String string3, Object[] objectArray) {
        if (this.isLoggable(level)) {
            this.logp(level, string, string2, LoggerAdapter.format(string3, objectArray));
        }
    }

    @Override
    public void logrb(Level level, String string, String string2, String string3, String string4) {
        if (this.isLoggable(level)) {
            this.logp(level, string, string2, LoggerAdapter.localize(string3, string4));
        }
    }

    @Override
    public void logrb(Level level, String string, String string2, String string3, String string4, Throwable throwable) {
        if (this.isLoggable(level)) {
            this.logp(level, string, string2, LoggerAdapter.localize(string3, string4), throwable);
        }
    }

    @Override
    public void logrb(Level level, String string, String string2, String string3, String string4, Object object) {
        if (this.isLoggable(level)) {
            this.logp(level, string, string2, LoggerAdapter.localize(string3, string4), object);
        }
    }

    @Override
    public void logrb(Level level, String string, String string2, String string3, String string4, Object[] objectArray) {
        if (this.isLoggable(level)) {
            this.logp(level, string, string2, LoggerAdapter.localize(string3, string4), objectArray);
        }
    }

    @Override
    public void addHandler(Handler handler) {
    }

    @Override
    public void removeHandler(Handler handler) {
    }

    @Override
    public void setUseParentHandlers(boolean bl) {
    }

    @Override
    public void setParent(Logger logger) {
    }

    @Override
    public void setFilter(Filter filter) {
    }

    private static Object[] asArray(Object object) {
        Object[] objectArray;
        if (object != null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = object;
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    private static String format(String string, Object[] objectArray) {
        if (objectArray != null && objectArray.length != 0 && MESSAGE_FORMAT.matcher(string).find()) {
            try {
                string = MessageFormat.format(string, objectArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return string;
    }

    private static String localize(String string, String string2) {
        if (string != null) {
            try {
                string2 = ResourceBundle.getBundle(string).getString(string2);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return string2;
    }
}

