/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.logging;

import java.util.logging.Logger;
import org.geotoolkit.util.collection.WeakValueHashMap;

public abstract class LoggerFactory<L> {
    public static final String COMMONS_LOGGING = "org.geotoolkit.util.logging.CommonsLoggerFactory";
    public static final String LOG4J = "org.geotoolkit.util.logging.Log4JLoggerFactory";
    private final Class<L> loggerClass;
    private final WeakValueHashMap<String, Logger> loggers;

    protected LoggerFactory(Class<L> clazz) {
        this.loggerClass = clazz;
        this.loggers = new WeakValueHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Logger getLogger(String string) {
        L l = this.getImplementation(string);
        if (l == null) {
            return null;
        }
        WeakValueHashMap<String, Logger> weakValueHashMap = this.loggers;
        synchronized (weakValueHashMap) {
            Logger logger = this.loggers.get(string);
            if (logger == null || !l.equals(this.unwrap(logger))) {
                logger = this.wrap(string, l);
                this.loggers.put(string, logger);
            }
            return logger;
        }
    }

    public Class<L> getImplementationClass() {
        return this.loggerClass;
    }

    protected abstract L getImplementation(String var1);

    protected abstract Logger wrap(String var1, L var2);

    protected abstract L unwrap(Logger var1);
}

